/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.melee;

import com.google.common.collect.Multimap;
import com.infamous.dungeons_gear.combat.CombatEventHandler;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.interfaces.IMeleeWeapon;
import com.infamous.dungeons_gear.interfaces.IOffhandAttack;
import com.infamous.dungeons_gear.interfaces.ISoulGatherer;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.SwordItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class DaggerItem
extends SwordItem
implements IOffhandAttack,
IMeleeWeapon,
ISoulGatherer {
    private final boolean unique;

    public DaggerItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder, boolean isUnique) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.unique = isUnique;
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        Multimap attributeModifiers = (Multimap)ObfuscationReflectionHelper.getPrivateValue(SwordItem.class, (Object)this, (String)"field_234810_b_");
        return equipmentSlot == EquipmentSlotType.MAINHAND || equipmentSlot == EquipmentSlotType.OFFHAND ? attributeModifiers : super.func_111205_h(equipmentSlot);
    }

    public Rarity func_77613_e(ItemStack itemStack) {
        if (this.unique) {
            return Rarity.RARE;
        }
        return Rarity.UNCOMMON;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        if (stack.func_77973_b() == DeferredItemInit.FANG_OF_FROST.get()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "This lauded dagger of the northern mountains is known to freeze its foes to solid ice."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Slows Mobs (Freezing I)"));
        }
        if (stack.func_77973_b() == DeferredItemInit.MOON_DAGGER.get()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "This curved blade shines like the crescent moon on a dark night."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Souls Critical Boost (Enigma Resonator I)"));
        }
        if (stack.func_77973_b() == DeferredItemInit.DAGGER.get()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "Daggers are the weapon of cravens - or so folks say."));
        }
        if (stack.func_77973_b() == DeferredItemInit.SHEAR_DAGGER.get()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "Even the simplest of farmers can wield these Shear Daggers with savage results."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Chance To Spawn Area Damage (Swirling I)"));
        }
        list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Dual Wield"));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (handIn == Hand.OFF_HAND && worldIn.field_72995_K) {
            CombatEventHandler.checkForOffhandAttack();
            ItemStack offhand = playerIn.func_184586_b(handIn);
            return new ActionResult(ActionResultType.SUCCESS, (Object)offhand);
        }
        return new ActionResult(ActionResultType.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    @Override
    public int getGatherAmount(ItemStack stack) {
        if (stack.func_77973_b() == DeferredItemInit.MOON_DAGGER.get()) {
            return 1;
        }
        return 0;
    }
}

