/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.melee;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.interfaces.IMeleeWeapon;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.item.TieredItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MaceItem
extends TieredItem
implements IMeleeWeapon {
    private final boolean unique;
    private final float attackDamage;
    private final float attackSpeed;
    private Multimap<Attribute, AttributeModifier> attributeModifierMultimap;

    public MaceItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties properties, boolean isUnique) {
        super(tier, properties);
        this.attackDamage = (float)attackDamageIn + tier.func_200929_c();
        this.attackSpeed = attackSpeedIn;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.attackSpeed, AttributeModifier.Operation.ADDITION));
        this.attributeModifierMultimap = builder.build();
        this.unique = isUnique;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return slot == EquipmentSlotType.MAINHAND ? this.attributeModifierMultimap : super.getAttributeModifiers(slot, stack);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, p_220039_0_ -> p_220039_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return true;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return 1.0f;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(2, entityLiving, p_220044_0_ -> p_220044_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public boolean func_150897_b(BlockState blockIn) {
        return blockIn.getHarvestLevel() < 3;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y.func_77557_a(Items.field_151040_l) && enchantment != Enchantments.field_191530_r;
    }

    public Rarity func_77613_e(ItemStack itemStack) {
        if (this.unique) {
            return Rarity.RARE;
        }
        return Rarity.UNCOMMON;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        if (stack.func_77973_b() == DeferredItemInit.FLAIL.get()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "This ancient weapon inflicts grave blunt damage to those who cannot evade the deadly metal ball."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Binds And Chains Enemies (Chains I)"));
        }
        if (stack.func_77973_b() == DeferredItemInit.SUNS_GRACE.get()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "This mace, engraved with secret healing runes, grants powerful restorative powers."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Heals Allies In Area (Radiance I)"));
        }
        if (stack.func_77973_b() == DeferredItemInit.MACE.get()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "The Mace is a brutal tool of war and what it lacks in finesse; it makes up for in power."));
        }
    }
}

