/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.ranged.crossbows;

import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.interfaces.ISoulGatherer;
import com.infamous.dungeons_gear.ranged.crossbows.AbstractDungeonsCrossbowItem;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class BurstCrossbowItem
extends AbstractDungeonsCrossbowItem
implements ISoulGatherer {
    public BurstCrossbowItem(Item.Properties builder, int defaultChargeTimeIn, boolean isUniqueIn) {
        super(builder, defaultChargeTimeIn, isUniqueIn);
    }

    @Override
    public boolean hasMultishotBuiltIn(ItemStack stack) {
        return true;
    }

    @Override
    public boolean shootsFasterArrows(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasEnigmaResonatorBuiltIn(ItemStack stack) {
        return stack.func_77973_b() == DeferredItemInit.SOUL_HUNTER_CROSSBOW.get();
    }

    @Override
    public boolean hasDynamoBuiltIn(ItemStack stack) {
        return stack.func_77973_b() == DeferredItemInit.CORRUPTED_CROSSBOW.get();
    }

    @Override
    public void fireCrossbowProjectiles(World world, LivingEntity livingEntity, Hand hand, ItemStack stack, float velocityIn, float inaccuracyIn) {
        List<ItemStack> list = AbstractDungeonsCrossbowItem.getChargedProjectiles(stack);
        float[] randomSoundPitches = AbstractDungeonsCrossbowItem.getRandomSoundPitches(livingEntity.func_70681_au());
        for (int i = 0; i < list.size(); ++i) {
            boolean playerInCreativeMode;
            ItemStack currentProjectile = list.get(i);
            boolean bl = playerInCreativeMode = livingEntity instanceof PlayerEntity && ((PlayerEntity)livingEntity).field_71075_bZ.field_75098_d;
            if (currentProjectile.func_190926_b()) continue;
            if (i == 0) {
                this.func_220016_a(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i], playerInCreativeMode, velocityIn, inaccuracyIn, 0.0f);
                continue;
            }
            if (i == 1) {
                this.func_220016_a(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i], playerInCreativeMode, velocityIn, inaccuracyIn, -5.0f);
                continue;
            }
            if (i == 2) {
                this.func_220016_a(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i], playerInCreativeMode, velocityIn, inaccuracyIn, 5.0f);
                continue;
            }
            if (i == 3) {
                this.func_220016_a(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 2], playerInCreativeMode, velocityIn, inaccuracyIn, -10.0f);
                continue;
            }
            if (i == 4) {
                this.func_220016_a(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 2], playerInCreativeMode, velocityIn, inaccuracyIn, 10.0f);
                continue;
            }
            if (i == 5) {
                this.func_220016_a(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 4], playerInCreativeMode, velocityIn, inaccuracyIn, -20.0f);
                continue;
            }
            if (i != 6) continue;
            this.func_220016_a(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 4], playerInCreativeMode, velocityIn, inaccuracyIn, 20.0f);
        }
        AbstractDungeonsCrossbowItem.fireProjectilesAfter(world, livingEntity, stack);
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        if (stack.func_77973_b() == DeferredItemInit.CORRUPTED_CROSSBOW.get()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "This crossbow has a subtle yet corrupting power that is suitable for thieves and nimble warriors alike."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Boosts Next Attack On Jump (Dynamo I)"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Fast Multiple Projectiles"));
        }
        if (stack.func_77973_b() == DeferredItemInit.SOUL_HUNTER_CROSSBOW.get()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Souls Critical Boost (Enigma Resonator I)"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Fast Multiple Projectiles"));
        }
        if (stack.func_77973_b() == DeferredItemInit.BURST_CROSSBOW.get()) {
            list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "A tactical crossbow favored by warriors and hunters alike, the Burst Crossbow is a powerful tool for any hero."));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Fast Multiple Projectiles"));
        }
    }

    @Override
    public int getGatherAmount(ItemStack stack) {
        if (stack.func_77973_b() == DeferredItemInit.BURST_CROSSBOW.get()) {
            return 1;
        }
        return 0;
    }
}

