/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.ranged.crossbows;

import com.infamous.dungeons_gear.capabilities.weapon.IWeapon;
import com.infamous.dungeons_gear.enchantments.lists.RangedEnchantmentList;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.ranged.crossbows.AbstractDungeonsCrossbowItem;
import com.infamous.dungeons_gear.utilties.AOECloudHelper;
import com.infamous.dungeons_gear.utilties.AreaOfEffectHelper;
import com.infamous.dungeons_gear.utilties.CapabilityHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_gear")
public class CrossbowEvents {
    @SubscribeEvent
    public static void onAccelerateCrossbowFired(PlayerInteractEvent.RightClickItem event) {
        PlayerEntity playerEntity = event.getPlayer();
        World world = playerEntity.func_130014_f_();
        long worldTime = world.func_82737_E();
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof CrossbowItem & CrossbowItem.func_220012_d((ItemStack)stack)) {
            IWeapon weaponCap = CapabilityHelper.getWeaponCapability(stack);
            if (weaponCap == null) {
                return;
            }
            long lastFiredTime = weaponCap.getLastFiredTime();
            int crossbowChargeTime = weaponCap.getCrossbowChargeTime();
            int accelerateLevel = EnchantmentHelper.func_77506_a((Enchantment)RangedEnchantmentList.ACCELERATE, (ItemStack)stack);
            if (stack.func_77973_b() == DeferredItemInit.AUTO_CROSSBOW.get()) {
                ++accelerateLevel;
            }
            int defaultChargeTime = 25;
            if (stack.func_77973_b() instanceof AbstractDungeonsCrossbowItem) {
                defaultChargeTime = ((AbstractDungeonsCrossbowItem)stack.func_77973_b()).getDefaultChargeTime();
            }
            if (accelerateLevel > 0) {
                if (lastFiredTime < worldTime - (long)(Math.max(crossbowChargeTime, 0) + 23) && crossbowChargeTime < defaultChargeTime) {
                    weaponCap.setCrossbowChargeTime(defaultChargeTime);
                } else {
                    int fireRateReduction = (int)((double)defaultChargeTime * (0.04 + 0.04 * (double)accelerateLevel));
                    weaponCap.setCrossbowChargeTime(crossbowChargeTime - fireRateReduction);
                }
                weaponCap.setLastFiredTime(worldTime);
            }
        }
    }

    @SubscribeEvent
    public static void onExplodingCrossbowImpact(ProjectileImpactEvent.Arrow event) {
        AbstractArrowEntity arrowEntity = event.getArrow();
        if (arrowEntity.func_234616_v_() instanceof LivingEntity) {
            boolean explodingCrossbowFlag;
            LivingEntity shooter = (LivingEntity)arrowEntity.func_234616_v_();
            boolean bl = explodingCrossbowFlag = arrowEntity.func_184216_O().contains("ExplodingCrossbow") || arrowEntity.func_184216_O().contains("FireboltThrower") || arrowEntity.func_184216_O().contains("ImplodingCrossbow");
            if (explodingCrossbowFlag && event.getRayTraceResult() instanceof BlockRayTraceResult) {
                BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)event.getRayTraceResult();
                BlockPos blockPos = blockRayTraceResult.func_216350_a();
                float f = (float)arrowEntity.func_213322_ci().func_72433_c();
                int damage = MathHelper.func_76143_f((double)MathHelper.func_151237_a((double)((double)f * arrowEntity.func_70242_d()), (double)0.0, (double)2.147483647E9));
                if (arrowEntity.func_70241_g()) {
                    long criticalDamageBonus = shooter.func_70681_au().nextInt(damage / 2 + 2);
                    damage = (int)Math.min(criticalDamageBonus + (long)damage, Integer.MAX_VALUE);
                }
                arrowEntity.field_70170_p.func_184148_a((PlayerEntity)null, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 64.0f, 1.0f);
                AOECloudHelper.spawnExplosionCloudAtPos(shooter, true, blockPos, 3.0f);
                AreaOfEffectHelper.causeExplosionAttackAtPos(shooter, true, blockPos, damage, 3.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onExplodingCrossbowDamage(LivingDamageEvent event) {
        AbstractArrowEntity arrowEntity;
        if (event.getSource() instanceof IndirectEntityDamageSource && event.getSource().func_76364_f() instanceof AbstractArrowEntity && (arrowEntity = (AbstractArrowEntity)event.getSource().func_76364_f()).func_234616_v_() instanceof LivingEntity) {
            boolean explodingCrossbowFlag;
            LivingEntity shooter = (LivingEntity)arrowEntity.func_234616_v_();
            boolean bl = explodingCrossbowFlag = arrowEntity.func_184216_O().contains("ExplodingCrossbow") || arrowEntity.func_184216_O().contains("FireboltThrower") || arrowEntity.func_184216_O().contains("ImplodingCrossbow");
            if (explodingCrossbowFlag) {
                LivingEntity victim = event.getEntityLiving();
                victim.field_70170_p.func_184148_a((PlayerEntity)null, victim.func_226277_ct_(), victim.func_226278_cu_(), victim.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 64.0f, 1.0f);
                AOECloudHelper.spawnExplosionCloud(shooter, victim, 3.0f);
                AreaOfEffectHelper.causeExplosionAttack(shooter, victim, event.getAmount(), 3.0f);
            }
        }
    }
}

