/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.utilties;

import com.infamous.dungeons_gear.DungeonsGear;
import com.infamous.dungeons_gear.config.DungeonsGearConfig;
import com.infamous.dungeons_gear.goals.GoalUtils;
import com.infamous.dungeons_gear.goals.WildRageAttackGoal;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.AxisAlignedBB;

public class AbilityHelper {
    public static void stealSpeedFromTarget(LivingEntity attacker, LivingEntity target, int amplifer) {
        EffectInstance speed = new EffectInstance(Effects.field_76424_c, 80, amplifer);
        EffectInstance slowness = new EffectInstance(Effects.field_76421_d, 80, amplifer);
        attacker.func_195064_c(speed);
        target.func_195064_c(slowness);
    }

    public static void makeNearbyPetsAttackTarget(LivingEntity target, LivingEntity owner) {
        List nearbyEntities = owner.func_130014_f_().func_225316_b(LivingEntity.class, new AxisAlignedBB(owner.func_226277_ct_() - 12.0, owner.func_226278_cu_() - 12.0, owner.func_226281_cx_() - 12.0, owner.func_226277_ct_() + 12.0, owner.func_226278_cu_() + 12.0, owner.func_226281_cx_() + 12.0), nearbyEntity -> AbilityHelper.canPetAttackEntity(owner, nearbyEntity));
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            if (nearbyEntity2 instanceof TameableEntity) {
                TameableEntity tameableEntity = (TameableEntity)nearbyEntity2;
                tameableEntity.func_70624_b(target);
            }
            if (nearbyEntity2 instanceof LlamaEntity) {
                LlamaEntity llamaEntity = (LlamaEntity)nearbyEntity2;
                llamaEntity.func_70624_b(target);
            }
            if (!(nearbyEntity2 instanceof IronGolemEntity)) continue;
            IronGolemEntity ironGolemEntity = (IronGolemEntity)nearbyEntity2;
            ironGolemEntity.func_70624_b(target);
        }
    }

    private static boolean canPetAttackEntity(LivingEntity owner, LivingEntity nearbyEntity) {
        return nearbyEntity != owner && AbilityHelper.isPetOfAttacker(owner, nearbyEntity) && nearbyEntity.func_70089_S();
    }

    public static boolean isPetOfAttacker(LivingEntity possibleOwner, LivingEntity possiblePet) {
        if (possiblePet instanceof TameableEntity) {
            TameableEntity pet = (TameableEntity)possiblePet;
            return pet.func_70902_q() == possibleOwner;
        }
        if (possiblePet instanceof AbstractHorseEntity) {
            AbstractHorseEntity abstractHorse = (AbstractHorseEntity)possiblePet;
            return GoalUtils.getOwner(abstractHorse) == possibleOwner;
        }
        if (possiblePet instanceof IronGolemEntity) {
            IronGolemEntity ironGolem = (IronGolemEntity)possiblePet;
            return GoalUtils.getOwner(ironGolem) == possibleOwner;
        }
        if (possiblePet instanceof BatEntity) {
            BatEntity batEntity = (BatEntity)possiblePet;
            return GoalUtils.getOwner(batEntity) == possibleOwner;
        }
        if (possiblePet instanceof BeeEntity) {
            BeeEntity beeEntity = (BeeEntity)possiblePet;
            return GoalUtils.getOwner(beeEntity) == possibleOwner;
        }
        if (possiblePet instanceof SheepEntity) {
            SheepEntity sheepEntity = (SheepEntity)possiblePet;
            return GoalUtils.getOwner(sheepEntity) == possibleOwner;
        }
        return false;
    }

    private static boolean isAVillagerOrIronGolem(LivingEntity nearbyEntity) {
        return nearbyEntity instanceof AbstractVillagerEntity || nearbyEntity instanceof IronGolemEntity;
    }

    private static boolean isNotTheTargetOrAttacker(LivingEntity attacker, LivingEntity target, LivingEntity nearbyEntity) {
        return nearbyEntity != target && nearbyEntity != attacker;
    }

    private static boolean isNotAPlayerOrCanApplyToPlayers(LivingEntity nearbyEntity) {
        if (!(nearbyEntity instanceof PlayerEntity)) {
            return true;
        }
        return (Boolean)DungeonsGearConfig.ENABLE_AREA_OF_EFFECT_ON_PLAYERS.get();
    }

    public static boolean canHealEntity(LivingEntity healer, LivingEntity nearbyEntity) {
        return nearbyEntity != healer && AbilityHelper.isAlly(healer, nearbyEntity) && AbilityHelper.isAliveAndCanBeSeen(nearbyEntity, healer);
    }

    private static boolean isAlly(LivingEntity healer, LivingEntity nearbyEntity) {
        return AbilityHelper.isPetOfAttacker(healer, nearbyEntity) || AbilityHelper.isAVillagerOrIronGolem(nearbyEntity) || healer.func_184191_r((Entity)nearbyEntity);
    }

    private static boolean isAliveAndCanBeSeen(LivingEntity nearbyEntity, LivingEntity attacker) {
        return nearbyEntity.func_70089_S() && attacker.func_70685_l((Entity)nearbyEntity);
    }

    public static boolean canApplyToEnemy(LivingEntity attacker, LivingEntity target, LivingEntity nearbyEntity) {
        return AbilityHelper.isNotTheTargetOrAttacker(attacker, target, nearbyEntity) && AbilityHelper.isAliveAndCanBeSeen(nearbyEntity, attacker) && !AbilityHelper.isAlly(attacker, nearbyEntity) && AbilityHelper.isNotAPlayerOrCanApplyToPlayers(nearbyEntity);
    }

    public static boolean canApplyToEnemy(LivingEntity attacker, LivingEntity nearbyEntity) {
        return nearbyEntity != attacker && AbilityHelper.isAliveAndCanBeSeen(nearbyEntity, attacker) && !AbilityHelper.isAlly(attacker, nearbyEntity) && AbilityHelper.isNotAPlayerOrCanApplyToPlayers(nearbyEntity);
    }

    public static void sendIntoWildRage(MobEntity mobEntity) {
        mobEntity.field_70715_bh.func_75776_a(0, (Goal)new WildRageAttackGoal(mobEntity));
        DungeonsGear.PROXY.spawnParticles((Entity)mobEntity, ParticleTypes.field_197609_b);
    }
}

