/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.utilties;

import com.infamous.dungeons_gear.DungeonsGear;
import com.infamous.dungeons_gear.damagesources.ElectricShockDamageSource;
import com.infamous.dungeons_gear.effects.CustomEffects;
import com.infamous.dungeons_gear.goals.LoverHurtByTargetGoal;
import com.infamous.dungeons_gear.goals.LoverHurtTargetGoal;
import com.infamous.dungeons_gear.init.ParticleInit;
import com.infamous.dungeons_gear.utilties.AbilityHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class AreaOfEffectHelper {
    public static void pullInNearbyEntities(LivingEntity attacker, LivingEntity target, float distance) {
        World world = target.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(target.func_226277_ct_() - (double)distance, target.func_226278_cu_() - (double)distance, target.func_226281_cx_() - (double)distance, target.func_226277_ct_() + (double)distance, target.func_226278_cu_() + (double)distance, target.func_226281_cx_() + (double)distance), nearbyEntity -> AbilityHelper.canApplyToEnemy(attacker, target, nearbyEntity));
        DungeonsGear.PROXY.spawnParticles((Entity)target, ParticleTypes.field_197599_J);
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            double motionX = target.func_226277_ct_() - nearbyEntity2.func_226277_ct_();
            double motionY = target.func_226278_cu_() - nearbyEntity2.func_226278_cu_();
            double motionZ = target.func_226281_cx_() - nearbyEntity2.func_226281_cx_();
            Vector3d vector3d = new Vector3d(motionX, motionY, motionZ);
            nearbyEntity2.func_213317_d(vector3d);
            DungeonsGear.PROXY.spawnParticles((Entity)nearbyEntity2, ParticleTypes.field_197599_J);
        }
    }

    public static void healNearbyAllies(LivingEntity healer, EffectInstance potionEffect, float distance) {
        World world = healer.func_130014_f_();
        PlayerEntity playerentity = healer instanceof PlayerEntity ? (PlayerEntity)healer : null;
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(healer.func_226277_ct_() - (double)distance, healer.func_226278_cu_() - (double)distance, healer.func_226281_cx_() - (double)distance, healer.func_226277_ct_() + (double)distance, healer.func_226278_cu_() + (double)distance, healer.func_226281_cx_() + (double)distance), nearbyEntity -> AbilityHelper.canHealEntity(healer, nearbyEntity));
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            if (!(nearbyEntity2.func_110143_aJ() < nearbyEntity2.func_110138_aP())) continue;
            if (potionEffect.func_188419_a().func_76403_b()) {
                potionEffect.func_188419_a().func_180793_a((Entity)playerentity, (Entity)playerentity, nearbyEntity2, potionEffect.func_76458_c(), 1.0);
            } else {
                nearbyEntity2.func_195064_c(new EffectInstance(potionEffect));
            }
            DungeonsGear.PROXY.spawnParticles((Entity)nearbyEntity2, ParticleTypes.field_197633_z);
        }
    }

    public static void healNearbyAllies(LivingEntity healer, float amount, float distance) {
        World world = healer.func_130014_f_();
        PlayerEntity playerentity = healer instanceof PlayerEntity ? (PlayerEntity)healer : null;
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(healer.func_226277_ct_() - (double)distance, healer.func_226278_cu_() - (double)distance, healer.func_226281_cx_() - (double)distance, healer.func_226277_ct_() + (double)distance, healer.func_226278_cu_() + (double)distance, healer.func_226281_cx_() + (double)distance), nearbyEntity -> AbilityHelper.canHealEntity(healer, nearbyEntity));
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            if (!(nearbyEntity2.func_110143_aJ() < nearbyEntity2.func_110138_aP())) continue;
            nearbyEntity2.func_70691_i(amount);
            DungeonsGear.PROXY.spawnParticles((Entity)nearbyEntity2, ParticleTypes.field_197633_z);
        }
    }

    public static float healMostInjuredAlly(LivingEntity healer, float distance) {
        World world = healer.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(healer.func_226277_ct_() - (double)distance, healer.func_226278_cu_() - (double)distance, healer.func_226281_cx_() - (double)distance, healer.func_226277_ct_() + (double)distance, healer.func_226278_cu_() + (double)distance, healer.func_226281_cx_() + (double)distance), nearbyEntity -> AbilityHelper.canHealEntity(healer, nearbyEntity));
        if (!nearbyEntities.isEmpty()) {
            nearbyEntities.sort((o1, o2) -> {
                float o1LostHealth = o1.func_110138_aP() - o1.func_110143_aJ();
                float o2LostHealth = o2.func_110138_aP() - o2.func_110143_aJ();
                return Float.compare(o1LostHealth, o2LostHealth);
            });
            LivingEntity mostInjuredAlly = (LivingEntity)nearbyEntities.get(nearbyEntities.size() - 1);
            float currentHealth = mostInjuredAlly.func_110143_aJ();
            float maxHealth = mostInjuredAlly.func_110138_aP();
            float lostHealth = maxHealth - currentHealth;
            if (lostHealth < maxHealth * 0.2f) {
                mostInjuredAlly.func_70606_j(currentHealth + lostHealth);
                DungeonsGear.PROXY.spawnParticles((Entity)mostInjuredAlly, ParticleTypes.field_197633_z);
                float healedAmount = lostHealth;
                return healedAmount;
            }
            mostInjuredAlly.func_70606_j(currentHealth + maxHealth * 0.2f);
            DungeonsGear.PROXY.spawnParticles((Entity)mostInjuredAlly, ParticleTypes.field_197633_z);
            float healedAmount = maxHealth * 0.2f;
            return healedAmount;
        }
        return 0.0f;
    }

    public static void pullInNearbyEntitiesAtPos(LivingEntity attacker, BlockPos blockPos, int distance) {
        World world = attacker.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB((double)(blockPos.func_177958_n() - distance), (double)(blockPos.func_177956_o() - distance), (double)(blockPos.func_177952_p() - distance), (double)(blockPos.func_177958_n() + distance), (double)(blockPos.func_177956_o() + distance), (double)(blockPos.func_177952_p() + distance)), nearbyEntity -> AbilityHelper.canApplyToEnemy(attacker, nearbyEntity));
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            double motionX = (double)blockPos.func_177958_n() - nearbyEntity2.func_226277_ct_();
            double motionY = (double)blockPos.func_177956_o() - nearbyEntity2.func_226278_cu_();
            double motionZ = (double)blockPos.func_177952_p() - nearbyEntity2.func_226281_cx_();
            Vector3d vector3d = new Vector3d(motionX, motionY, motionZ);
            nearbyEntity2.func_213317_d(vector3d);
            DungeonsGear.PROXY.spawnParticles((Entity)nearbyEntity2, ParticleTypes.field_197599_J);
        }
    }

    public static void chainNearbyEntities(LivingEntity attacker, LivingEntity target, float distance, int timeMultiplier) {
        World world = target.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(target.func_226277_ct_() - (double)distance, target.func_226278_cu_() - (double)distance, target.func_226281_cx_() - (double)distance, target.func_226277_ct_() + (double)distance, target.func_226278_cu_() + (double)distance, target.func_226281_cx_() + (double)distance), nearbyEntity -> AbilityHelper.canApplyToEnemy(attacker, target, nearbyEntity));
        DungeonsGear.PROXY.spawnParticles((Entity)target, ParticleTypes.field_197599_J);
        EffectInstance chained = new EffectInstance(Effects.field_76421_d, 20 * timeMultiplier, 5);
        target.func_195064_c(chained);
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            double motionX = target.func_226277_ct_() - nearbyEntity2.func_226277_ct_();
            double motionY = target.func_226278_cu_() - nearbyEntity2.func_226278_cu_();
            double motionZ = target.func_226281_cx_() - nearbyEntity2.func_226281_cx_();
            Vector3d vector3d = new Vector3d(motionX, motionY, motionZ);
            nearbyEntity2.func_213317_d(vector3d);
            nearbyEntity2.func_195064_c(chained);
            DungeonsGear.PROXY.spawnParticles((Entity)nearbyEntity2, ParticleTypes.field_197599_J);
        }
    }

    public static void weakenNearbyEntities(LivingEntity attacker, LivingEntity target, int distance, int amplifier) {
        World world = target.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(target.func_226277_ct_() - (double)distance, target.func_226278_cu_() - (double)distance, target.func_226281_cx_() - (double)distance, target.func_226277_ct_() + (double)distance, target.func_226278_cu_() + (double)distance, target.func_226281_cx_() + (double)distance), nearbyEntity -> AbilityHelper.canApplyToEnemy(attacker, target, nearbyEntity));
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            EffectInstance weakness = new EffectInstance(Effects.field_76437_t, 100, amplifier);
            nearbyEntity2.func_195064_c(weakness);
        }
    }

    public static void causeShockwave(LivingEntity attacker, LivingEntity target, float damageAmount, float distance) {
        World world = target.func_130014_f_();
        DamageSource shockwave = DamageSource.func_188405_b((LivingEntity)attacker);
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(target.func_226277_ct_() - (double)distance, target.func_226278_cu_() - (double)distance, target.func_226281_cx_() - (double)distance, target.func_226277_ct_() + (double)distance, target.func_226278_cu_() + (double)distance, target.func_226281_cx_() + (double)distance), nearbyEntity -> AbilityHelper.canApplyToEnemy(attacker, target, nearbyEntity));
        if (nearbyEntities.isEmpty()) {
            return;
        }
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            nearbyEntity2.func_70097_a(shockwave, damageAmount);
        }
    }

    public static void causeExplosionAttack(LivingEntity attacker, LivingEntity target, float damageAmount, float distance) {
        World world = target.func_130014_f_();
        DamageSource explosion = DamageSource.func_188405_b((LivingEntity)attacker);
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(target.func_226277_ct_() - (double)distance, target.func_226278_cu_() - (double)distance, target.func_226281_cx_() - (double)distance, target.func_226277_ct_() + (double)distance, target.func_226278_cu_() + (double)distance, target.func_226281_cx_() + (double)distance), nearbyEntity -> AbilityHelper.canApplyToEnemy(attacker, nearbyEntity));
        if (nearbyEntities.isEmpty()) {
            return;
        }
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            nearbyEntity2.func_70097_a(explosion, damageAmount);
        }
    }

    public static void causeMagicExplosionAttack(LivingEntity attacker, LivingEntity target, float damageAmount, float distance) {
        World world = target.func_130014_f_();
        DamageSource magicExplosion = DamageSource.func_188405_b((LivingEntity)attacker).func_76348_h().func_82726_p();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(target.func_226277_ct_() - (double)distance, target.func_226278_cu_() - (double)distance, target.func_226281_cx_() - (double)distance, target.func_226277_ct_() + (double)distance, target.func_226278_cu_() + (double)distance, target.func_226281_cx_() + (double)distance), nearbyEntity -> AbilityHelper.canApplyToEnemy(attacker, nearbyEntity));
        if (nearbyEntities.isEmpty()) {
            return;
        }
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            nearbyEntity2.func_70097_a(magicExplosion, damageAmount);
        }
    }

    public static void burnNearbyEnemies(LivingEntity attacker, float damage, float distance) {
        World world = attacker.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(attacker.func_226277_ct_() - (double)distance, attacker.func_226278_cu_() - (double)distance, attacker.func_226281_cx_() - (double)distance, attacker.func_226277_ct_() + (double)distance, attacker.func_226278_cu_() + (double)distance, attacker.func_226281_cx_() + (double)distance), nearbyEntity -> AbilityHelper.canApplyToEnemy(attacker, nearbyEntity));
        if (nearbyEntities.isEmpty()) {
            return;
        }
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            nearbyEntity2.func_70097_a(DamageSource.field_76370_b, damage);
            DungeonsGear.PROXY.spawnParticles((Entity)nearbyEntity2, ParticleTypes.field_197631_x);
        }
    }

    public static void freezeNearbyEnemies(LivingEntity attacker, int amplifier, float distance) {
        World world = attacker.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(attacker.func_226277_ct_() - (double)distance, attacker.func_226278_cu_() - (double)distance, attacker.func_226281_cx_() - (double)distance, attacker.func_226277_ct_() + (double)distance, attacker.func_226278_cu_() + (double)distance, attacker.func_226281_cx_() + (double)distance), nearbyEntity -> AbilityHelper.canApplyToEnemy(attacker, nearbyEntity));
        if (nearbyEntities.isEmpty()) {
            return;
        }
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            EffectInstance slowness = new EffectInstance(Effects.field_76421_d, 20, amplifier);
            EffectInstance fatigue = new EffectInstance(Effects.field_76419_f, 20, amplifier * 2 - 1);
            nearbyEntity2.func_195064_c(slowness);
            nearbyEntity2.func_195064_c(fatigue);
            DungeonsGear.PROXY.spawnParticles((Entity)nearbyEntity2, ParticleTypes.field_197593_D);
        }
    }

    public static void causeExplosionAttackAtPos(LivingEntity attacker, boolean arrow, BlockPos blockPos, float damageAmount, float distance) {
        int inGroundMitigator = arrow ? 1 : 0;
        World world = attacker.func_130014_f_();
        DamageSource explosion = DamageSource.func_188405_b((LivingEntity)attacker);
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB((double)((float)blockPos.func_177958_n() - distance), (double)((float)(blockPos.func_177956_o() + inGroundMitigator) - distance), (double)((float)blockPos.func_177952_p() - distance), (double)((float)blockPos.func_177958_n() + distance), (double)((float)(blockPos.func_177956_o() + inGroundMitigator) + distance), (double)((float)blockPos.func_177952_p() + distance)), nearbyEntity -> AbilityHelper.canApplyToEnemy(attacker, nearbyEntity));
        if (nearbyEntities.isEmpty()) {
            return;
        }
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            nearbyEntity2.func_70097_a(explosion, damageAmount);
        }
    }

    public static void causeSwirlingAttack(PlayerEntity attacker, LivingEntity target, float damageAmount, float distance) {
        World world = target.func_130014_f_();
        DamageSource swirling = DamageSource.func_76365_a((PlayerEntity)attacker);
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(attacker.func_226277_ct_() - (double)distance, attacker.func_226278_cu_() - (double)distance, attacker.func_226281_cx_() - (double)distance, attacker.func_226277_ct_() + (double)distance, attacker.func_226278_cu_() + (double)distance, attacker.func_226281_cx_() + (double)distance), nearbyEntity -> AbilityHelper.canApplyToEnemy((LivingEntity)attacker, target, nearbyEntity));
        if (nearbyEntities.isEmpty()) {
            return;
        }
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            nearbyEntity2.func_70097_a(swirling, damageAmount);
        }
    }

    public static void causeEchoAttack(LivingEntity attacker, LivingEntity target, float damageAmount, float distance, int echoLevel) {
        List nearbyEntities;
        World world = target.func_130014_f_();
        DamageSource echo = DamageSource.func_76358_a((LivingEntity)attacker);
        if (attacker instanceof PlayerEntity) {
            echo = DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker));
        }
        if ((nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(target.func_226277_ct_() - (double)distance, target.func_226278_cu_() - (double)distance, target.func_226281_cx_() - (double)distance, target.func_226277_ct_() + (double)distance, target.func_226278_cu_() + (double)distance, target.func_226281_cx_() + (double)distance), nearbyEntity -> AbilityHelper.canApplyToEnemy(attacker, target, nearbyEntity))).isEmpty()) {
            return;
        }
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            if (nearbyEntity2 == null) {
                return;
            }
            nearbyEntity2.func_70097_a(echo, damageAmount);
            if (--echoLevel > 0) continue;
            return;
        }
    }

    public static void createVisualLightningBoltOnEntity(Entity target) {
        World world = target.func_130014_f_();
        LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
        if (lightningboltentity != null) {
            lightningboltentity.func_225653_b_(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
            lightningboltentity.func_233623_a_(true);
            world.func_217376_c((Entity)lightningboltentity);
        }
    }

    public static void electrify(LivingEntity attacker, LivingEntity victim, float damageAmount) {
        AreaOfEffectHelper.createVisualLightningBoltOnEntity((Entity)victim);
        ElectricShockDamageSource lightning = (ElectricShockDamageSource)new ElectricShockDamageSource((Entity)attacker).func_82726_p().func_76348_h();
        DungeonsGear.PROXY.spawnParticles((Entity)victim, (BasicParticleType)ParticleInit.ELECTRIC_SHOCK.get());
        victim.func_70097_a((DamageSource)lightning, damageAmount);
    }

    public static void electrifyNearbyEnemies(LivingEntity attacker, float distance, float damageAmount, int limit) {
        World world = attacker.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(attacker.func_226277_ct_() - (double)distance, attacker.func_226278_cu_() - (double)distance, attacker.func_226281_cx_() - (double)distance, attacker.func_226277_ct_() + (double)distance, attacker.func_226278_cu_() + (double)distance, attacker.func_226281_cx_() + (double)distance), nearbyEntity -> AbilityHelper.canApplyToEnemy(attacker, nearbyEntity));
        if (nearbyEntities.isEmpty()) {
            return;
        }
        if (limit > nearbyEntities.size()) {
            limit = nearbyEntities.size();
        }
        attacker.field_70170_p.func_184148_a((PlayerEntity)null, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), SoundEvents.field_187754_de, SoundCategory.WEATHER, 64.0f, 1.0f);
        attacker.field_70170_p.func_184148_a((PlayerEntity)null, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), SoundEvents.field_187752_dd, SoundCategory.WEATHER, 64.0f, 1.0f);
        for (int i = 0; i < limit; ++i) {
            if (nearbyEntities.size() < i + 1) continue;
            LivingEntity nearbyEntity2 = (LivingEntity)nearbyEntities.get(i);
            AreaOfEffectHelper.electrify(attacker, nearbyEntity2, damageAmount);
        }
    }

    public static void poisonAndSlowNearbyEnemies(World worldIn, PlayerEntity playerIn) {
        List nearbyEntities = worldIn.func_225316_b(LivingEntity.class, new AxisAlignedBB(playerIn.func_226277_ct_() - 5.0, playerIn.func_226278_cu_() - 5.0, playerIn.func_226281_cx_() - 5.0, playerIn.func_226277_ct_() + 5.0, playerIn.func_226278_cu_() + 5.0, playerIn.func_226281_cx_() + 5.0), nearbyEntity -> AbilityHelper.canApplyToEnemy((LivingEntity)playerIn, nearbyEntity));
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            EffectInstance entangled = new EffectInstance(Effects.field_76421_d, 140, 4);
            EffectInstance poison = new EffectInstance(Effects.field_76436_u, 140, 1);
            nearbyEntity2.func_195064_c(entangled);
            nearbyEntity2.func_195064_c(poison);
        }
    }

    public static void weakenAndMakeNearbyEnemiesVulnerable(PlayerEntity playerIn, World world) {
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(playerIn.func_226277_ct_() - 5.0, playerIn.func_226278_cu_() - 5.0, playerIn.func_226281_cx_() - 5.0, playerIn.func_226277_ct_() + 5.0, playerIn.func_226278_cu_() + 5.0, playerIn.func_226281_cx_() + 5.0), nearbyEntity -> nearbyEntity != playerIn && !AbilityHelper.isPetOfAttacker((LivingEntity)playerIn, nearbyEntity) && nearbyEntity.func_70089_S());
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            EffectInstance weakness = new EffectInstance(Effects.field_76437_t, 140);
            EffectInstance vulnerability = new EffectInstance(Effects.field_76429_m, 140, -2);
            nearbyEntity2.func_195064_c(weakness);
            nearbyEntity2.func_195064_c(vulnerability);
        }
    }

    public static void stunNearbyEnemies(World worldIn, PlayerEntity playerIn) {
        List nearbyEntities = worldIn.func_225316_b(LivingEntity.class, new AxisAlignedBB(playerIn.func_226277_ct_() - 5.0, playerIn.func_226278_cu_() - 5.0, playerIn.func_226281_cx_() - 5.0, playerIn.func_226277_ct_() + 5.0, playerIn.func_226278_cu_() + 5.0, playerIn.func_226281_cx_() + 5.0), nearbyEntity -> nearbyEntity != playerIn && !AbilityHelper.isPetOfAttacker((LivingEntity)playerIn, nearbyEntity) && nearbyEntity.func_70089_S());
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            EffectInstance stunned = new EffectInstance(CustomEffects.STUNNED, 100);
            EffectInstance nausea = new EffectInstance(Effects.field_76431_k, 100);
            EffectInstance slowness = new EffectInstance(Effects.field_76421_d, 100, 4);
            nearbyEntity2.func_195064_c(slowness);
            nearbyEntity2.func_195064_c(nausea);
            nearbyEntity2.func_195064_c(stunned);
        }
    }

    public static void makeLoversOutOfNearbyEnemies(PlayerEntity playerIn, World world) {
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(playerIn.func_226277_ct_() - 5.0, playerIn.func_226278_cu_() - 5.0, playerIn.func_226281_cx_() - 5.0, playerIn.func_226277_ct_() + 5.0, playerIn.func_226278_cu_() + 5.0, playerIn.func_226281_cx_() + 5.0), nearbyEntity -> nearbyEntity instanceof IMob && !AbilityHelper.isPetOfAttacker((LivingEntity)playerIn, nearbyEntity) && nearbyEntity.func_70089_S() && nearbyEntity.func_184222_aU());
        int maxLovers = 3;
        int loverCount = 0;
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            if (!(nearbyEntity2 instanceof MonsterEntity)) continue;
            MonsterEntity mobEntity = (MonsterEntity)nearbyEntity2;
            DungeonsGear.PROXY.spawnParticles((Entity)nearbyEntity2, ParticleTypes.field_197633_z);
            mobEntity.field_70715_bh.func_75776_a(0, (Goal)new LoverHurtByTargetGoal((MobEntity)mobEntity, (LivingEntity)playerIn));
            mobEntity.field_70715_bh.func_75776_a(1, (Goal)new LoverHurtTargetGoal((MobEntity)mobEntity, (LivingEntity)playerIn));
            if (++loverCount != maxLovers) continue;
            break;
        }
    }

    public static void knockbackNearbyEnemies(World worldIn, PlayerEntity playerIn) {
        List nearbyEntities = worldIn.func_225316_b(LivingEntity.class, new AxisAlignedBB(playerIn.func_226277_ct_() - 5.0, playerIn.func_226278_cu_() - 5.0, playerIn.func_226281_cx_() - 5.0, playerIn.func_226277_ct_() + 5.0, playerIn.func_226278_cu_() + 5.0, playerIn.func_226281_cx_() + 5.0), nearbyEntity -> nearbyEntity != playerIn && !AbilityHelper.isPetOfAttacker((LivingEntity)playerIn, nearbyEntity) && nearbyEntity.func_70089_S());
        DungeonsGear.PROXY.spawnParticles((Entity)playerIn, ParticleTypes.field_197613_f);
        for (LivingEntity nearbyEntity2 : nearbyEntities) {
            float knockbackMultiplier = 3.0f;
            double xRatio = playerIn.func_226277_ct_() - nearbyEntity2.func_226277_ct_();
            double zRatio = playerIn.func_226281_cx_() - nearbyEntity2.func_226281_cx_();
            while (xRatio * xRatio + zRatio * zRatio < 1.0E-4) {
                xRatio = (Math.random() - Math.random()) * 0.01;
                zRatio = (Math.random() - Math.random()) * 0.01;
            }
            nearbyEntity2.field_70739_aP = (float)(MathHelper.func_181159_b((double)zRatio, (double)xRatio) * 57.2957763671875 - (double)nearbyEntity2.field_70177_z);
            nearbyEntity2.func_233627_a_(0.4f * knockbackMultiplier, xRatio, zRatio);
            DungeonsGear.PROXY.spawnParticles((Entity)nearbyEntity2, ParticleTypes.field_197613_f);
            EffectInstance stun = new EffectInstance(Effects.field_76421_d, 60, 4);
            nearbyEntity2.func_195064_c(stun);
        }
    }
}

