/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.utilties;

import com.infamous.dungeons_gear.capabilities.summoning.ISummonable;
import com.infamous.dungeons_gear.capabilities.summoning.ISummoner;
import com.infamous.dungeons_gear.goals.BatFollowOwnerGoal;
import com.infamous.dungeons_gear.goals.BatMeleeAttackGoal;
import com.infamous.dungeons_gear.goals.BatOwnerHurtByTargetGoal;
import com.infamous.dungeons_gear.goals.BatOwnerHurtTargetGoal;
import com.infamous.dungeons_gear.utilties.CapabilityHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ArmorEffectHelper {
    public static void summonOrTeleportBat(PlayerEntity playerEntity, World world) {
        Entity entity;
        ISummoner summonerCap = CapabilityHelper.getSummonerCapability((Entity)playerEntity);
        if (summonerCap == null) {
            return;
        }
        if (summonerCap.getSummonedBat() == null) {
            ISummonable summonable;
            BatEntity batEntity = (BatEntity)EntityType.field_200791_e.func_200721_a(world);
            if (batEntity != null && (summonable = CapabilityHelper.getSummonableCapability((Entity)batEntity)) != null) {
                summonable.setSummoner(playerEntity.func_110124_au());
                summonerCap.setSummonedBat(batEntity.func_110124_au());
                ArmorEffectHelper.createBat(playerEntity, world, batEntity);
            }
        } else if (world instanceof ServerWorld && (entity = ((ServerWorld)world).func_217461_a(summonerCap.getSummonedBat())) instanceof BatEntity) {
            BatEntity batEntity = (BatEntity)entity;
            batEntity.func_223102_j(playerEntity.func_226277_ct_() + (double)playerEntity.func_70047_e(), playerEntity.func_226278_cu_() + (double)playerEntity.func_70047_e(), playerEntity.func_226281_cx_() + (double)playerEntity.func_70047_e());
        }
    }

    private static void createBat(PlayerEntity playerEntity, World world, BatEntity batEntity) {
        batEntity.func_70012_b(playerEntity.func_226277_ct_() + (double)playerEntity.func_70047_e(), playerEntity.func_226278_cu_() + (double)playerEntity.func_70047_e(), playerEntity.func_226281_cx_() + (double)playerEntity.func_70047_e(), 0.0f, 0.0f);
        batEntity.field_70714_bg.func_75776_a(1, (Goal)new BatMeleeAttackGoal(batEntity, 1.0, true));
        batEntity.field_70714_bg.func_75776_a(2, (Goal)new BatFollowOwnerGoal(batEntity, 2.1, 10.0f, 2.0f, false));
        batEntity.field_70715_bh.func_75776_a(1, (Goal)new BatOwnerHurtByTargetGoal(batEntity));
        batEntity.field_70715_bh.func_75776_a(2, (Goal)new BatOwnerHurtTargetGoal(batEntity));
        batEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)batEntity, LivingEntity.class, 5, false, false, entityIterator -> entityIterator instanceof IMob && !(entityIterator instanceof CreeperEntity)));
        world.func_184148_a((PlayerEntity)null, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_187740_w, SoundCategory.AMBIENT, 64.0f, 1.0f);
        world.func_217376_c((Entity)batEntity);
    }

    public static void teleportOnHit(LivingEntity livingEntity) {
        World world = livingEntity.func_130014_f_();
        if (!world.field_72995_K) {
            double lvt_5_1_ = livingEntity.func_226277_ct_();
            double lvt_7_1_ = livingEntity.func_226278_cu_();
            double lvt_9_1_ = livingEntity.func_226281_cx_();
            for (int i = 0; i < 16; ++i) {
                double teleportX = livingEntity.func_226277_ct_() + (livingEntity.func_70681_au().nextDouble() - 0.5) * 16.0;
                double teleportY = MathHelper.func_151237_a((double)(livingEntity.func_226278_cu_() + (double)(livingEntity.func_70681_au().nextInt(16) - 8)), (double)0.0, (double)(world.func_234938_ad_() - 1));
                double teleportZ = livingEntity.func_226281_cx_() + (livingEntity.func_70681_au().nextDouble() - 0.5) * 16.0;
                if (livingEntity.func_184218_aH()) {
                    livingEntity.func_184210_p();
                }
                if (!livingEntity.func_213373_a(teleportX, teleportY, teleportZ, true)) continue;
                SoundEvent lvt_18_1_ = livingEntity instanceof FoxEntity ? SoundEvents.field_232710_ez_ : SoundEvents.field_187544_ad;
                world.func_184148_a((PlayerEntity)null, lvt_5_1_, lvt_7_1_, lvt_9_1_, lvt_18_1_, SoundCategory.PLAYERS, 1.0f, 1.0f);
                livingEntity.func_184185_a(lvt_18_1_, 1.0f, 1.0f);
                break;
            }
        }
    }
}

