/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.utilties;

import com.infamous.dungeons_gear.enchantments.lists.MeleeRangedEnchantmentList;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.ranged.crossbows.AbstractDungeonsCrossbowItem;
import com.infamous.dungeons_gear.utilties.AbilityHelper;
import com.infamous.dungeons_gear.utilties.ModEnchantmentHelper;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class ProjectileEffectHelper {
    public static void ricochetArrowTowardsOtherEntity(LivingEntity attacker, LivingEntity victim, AbstractArrowEntity arrowEntity, int distance) {
        World world = attacker.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(victim.func_226277_ct_() - (double)distance, victim.func_226278_cu_() - (double)distance, victim.func_226281_cx_() - (double)distance, victim.func_226277_ct_() + (double)distance, victim.func_226278_cu_() + (double)distance, victim.func_226281_cx_() + (double)distance), nearbyEntity -> AbilityHelper.canApplyToEnemy(attacker, victim, nearbyEntity));
        if (nearbyEntities.isEmpty()) {
            return;
        }
        nearbyEntities.sort(Comparator.comparingDouble(livingEntity -> livingEntity.func_70068_e((Entity)victim)));
        LivingEntity target = (LivingEntity)nearbyEntities.get(0);
        if (target != null) {
            byte pierceLevel = arrowEntity.func_213874_s();
            pierceLevel = (byte)(pierceLevel + 1);
            arrowEntity.func_213872_b(pierceLevel);
            double towardsX = target.func_226277_ct_() - victim.func_226277_ct_();
            double towardsZ = target.func_226281_cx_() - victim.func_226281_cx_();
            double euclideanDist = MathHelper.func_76133_a((double)(towardsX * towardsX + towardsZ * towardsZ));
            double towardsY = target.func_226283_e_(0.3333333333333333) - arrowEntity.func_226278_cu_() + euclideanDist * (double)0.2f;
            ProjectileEffectHelper.setProjectileTowards((ProjectileEntity)arrowEntity, towardsX, towardsY, towardsZ, 0.0f);
        }
    }

    public static void fireBonusShotTowardsOtherEntity(LivingEntity attacker, int distance, double bonusShotDamageMultiplier, float arrowVelocity) {
        World world = attacker.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(attacker.func_226277_ct_() - (double)distance, attacker.func_226278_cu_() - (double)distance, attacker.func_226281_cx_() - (double)distance, attacker.func_226277_ct_() + (double)distance, attacker.func_226278_cu_() + (double)distance, attacker.func_226281_cx_() + (double)distance), nearbyEntity -> AbilityHelper.canApplyToEnemy(attacker, nearbyEntity));
        if (nearbyEntities.size() < 2) {
            return;
        }
        nearbyEntities.sort(Comparator.comparingDouble(livingEntity -> livingEntity.func_70068_e((Entity)attacker)));
        LivingEntity target = (LivingEntity)nearbyEntities.get(0);
        if (target != null) {
            ArrowItem arrowItem = (ArrowItem)Items.field_151032_g;
            AbstractArrowEntity arrowEntity = arrowItem.func_200887_a(world, new ItemStack((IItemProvider)Items.field_151032_g), attacker);
            arrowEntity.func_70239_b(arrowEntity.func_70242_d() * bonusShotDamageMultiplier);
            double towardsX = target.func_226277_ct_() - attacker.func_226277_ct_();
            double towardsZ = target.func_226281_cx_() - attacker.func_226281_cx_();
            double euclideanDist = MathHelper.func_76133_a((double)(towardsX * towardsX + towardsZ * towardsZ));
            double towardsY = target.func_226283_e_(0.3333333333333333) - arrowEntity.func_226278_cu_() + euclideanDist * (double)0.2f;
            arrowEntity.func_234612_a_((Entity)attacker, attacker.field_70125_A, attacker.field_70177_z, 0.0f, arrowVelocity * 3.0f, 1.0f);
            ProjectileEffectHelper.setProjectileTowards((ProjectileEntity)arrowEntity, towardsX, towardsY, towardsZ, 0.0f);
            arrowEntity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
            arrowEntity.func_184211_a("BonusProjectile");
            attacker.field_70170_p.func_217376_c((Entity)arrowEntity);
        }
    }

    public static void fireSnowballAtNearbyEnemy(LivingEntity attacker, int distance) {
        World world = attacker.func_130014_f_();
        List nearbyEntities = world.func_225316_b(LivingEntity.class, new AxisAlignedBB(attacker.func_226277_ct_() - (double)distance, attacker.func_226278_cu_() - (double)distance, attacker.func_226281_cx_() - (double)distance, attacker.func_226277_ct_() + (double)distance, attacker.func_226278_cu_() + (double)distance, attacker.func_226281_cx_() + (double)distance), nearbyEntity -> AbilityHelper.canApplyToEnemy(attacker, nearbyEntity));
        if (nearbyEntities.size() < 2) {
            return;
        }
        nearbyEntities.sort(Comparator.comparingDouble(livingEntity -> livingEntity.func_70068_e((Entity)attacker)));
        LivingEntity target = (LivingEntity)nearbyEntities.get(0);
        if (target != null) {
            SnowballEntity snowballEntity = new SnowballEntity(world, attacker);
            double towardsX = target.func_226277_ct_() - attacker.func_226277_ct_();
            double towardsZ = target.func_226281_cx_() - attacker.func_226281_cx_();
            double euclideanDist = MathHelper.func_76133_a((double)(towardsX * towardsX + towardsZ * towardsZ));
            double towardsY = target.func_226283_e_(0.3333333333333333) - snowballEntity.func_226278_cu_() + euclideanDist * (double)0.2f;
            snowballEntity.func_234612_a_((Entity)attacker, attacker.field_70125_A, attacker.field_70177_z, 0.0f, 1.5f, 1.0f);
            ProjectileEffectHelper.setProjectileTowards((ProjectileEntity)snowballEntity, towardsX, towardsY, towardsZ, 0.0f);
            attacker.field_70170_p.func_217376_c((Entity)snowballEntity);
        }
    }

    public static void ricochetArrowLikeShield(AbstractArrowEntity arrowEntity, LivingEntity entity) {
        arrowEntity.func_213317_d(arrowEntity.func_213322_ci().func_186678_a(-0.1));
        arrowEntity.field_70177_z += 180.0f;
        arrowEntity.field_70126_B += 180.0f;
        if (!arrowEntity.field_70170_p.field_72995_K && arrowEntity.func_213322_ci().func_189985_c() < 1.0E-7) {
            if (arrowEntity.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                arrowEntity.func_70099_a(new ItemStack((IItemProvider)Items.field_151032_g), 0.1f);
            }
            arrowEntity.func_70106_y();
        }
    }

    private static AbstractArrowEntity createChainReactionProjectile(World world, LivingEntity attacker, ItemStack ammoStack, AbstractArrowEntity originalArrow) {
        ArrowItem arrowItem = (ArrowItem)(ammoStack.func_77973_b() instanceof ArrowItem ? ammoStack.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity abstractArrowEntity = arrowItem.func_200887_a(world, ammoStack, attacker);
        if (attacker instanceof PlayerEntity) {
            abstractArrowEntity.func_70243_d(true);
        }
        abstractArrowEntity.func_213869_a(SoundEvents.field_219609_bA);
        abstractArrowEntity.func_213865_o(true);
        abstractArrowEntity.func_184211_a("ChainReactionProjectile");
        Set originalArrowTags = originalArrow.func_184216_O();
        for (String tag : originalArrowTags) {
            abstractArrowEntity.func_184211_a(tag);
        }
        return abstractArrowEntity;
    }

    public static void fireChainReactionProjectiles(World world, LivingEntity attacker, LivingEntity victim, float v, float v1, AbstractArrowEntity originalArrow) {
        float[] randomSoundPitches = AbstractDungeonsCrossbowItem.getRandomSoundPitches(victim.func_70681_au());
        for (int i = 0; i < 4; ++i) {
            ItemStack currentProjectile = new ItemStack((IItemProvider)Items.field_151032_g);
            if (currentProjectile.func_190926_b()) continue;
            if (i == 0) {
                ProjectileEffectHelper.fireChainReactionProjectileFromVictim(world, attacker, victim, currentProjectile, randomSoundPitches[1], v, v1, 45.0f, originalArrow);
                continue;
            }
            if (i == 1) {
                ProjectileEffectHelper.fireChainReactionProjectileFromVictim(world, attacker, victim, currentProjectile, randomSoundPitches[2], v, v1, -45.0f, originalArrow);
                continue;
            }
            if (i == 2) {
                ProjectileEffectHelper.fireChainReactionProjectileFromVictim(world, attacker, victim, currentProjectile, randomSoundPitches[1], v, v1, 135.0f, originalArrow);
                continue;
            }
            if (i != 3) continue;
            ProjectileEffectHelper.fireChainReactionProjectileFromVictim(world, attacker, victim, currentProjectile, randomSoundPitches[2], v, v1, -135.0f, originalArrow);
        }
    }

    private static void fireChainReactionProjectileFromVictim(World world, LivingEntity attacker, LivingEntity victim, ItemStack projectileStack, float soundPitch, float v1, float v2, float centerOffset, AbstractArrowEntity originalArrow) {
        if (!world.field_72995_K) {
            AbstractArrowEntity projectile = ProjectileEffectHelper.createChainReactionProjectile(world, attacker, projectileStack, originalArrow);
            projectile.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
            Vector3d upVector = victim.func_213286_i(1.0f);
            Quaternion quaternion = new Quaternion(new Vector3f(upVector), centerOffset, true);
            Vector3d lookVector = victim.func_70676_i(1.0f);
            Vector3f vector3f = new Vector3f(lookVector);
            vector3f.func_214905_a(quaternion);
            projectile.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), v1, v2);
            world.func_217376_c((Entity)projectile);
            world.func_184148_a((PlayerEntity)null, victim.func_226277_ct_(), victim.func_226278_cu_(), victim.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, soundPitch);
        }
    }

    public static boolean soulsCriticalBoost(PlayerEntity attacker, ItemStack mainhand) {
        boolean uniqueWeaponFlag;
        int numSouls = Math.min(attacker.field_71067_cb, 50);
        boolean bl = uniqueWeaponFlag = mainhand.func_77973_b() == DeferredItemInit.FERAL_SOUL_CROSSBOW.get() || mainhand.func_77973_b() == DeferredItemInit.SOUL_HUNTER_CROSSBOW.get();
        if (ModEnchantmentHelper.hasEnchantment(mainhand, MeleeRangedEnchantmentList.ENIGMA_RESONATOR)) {
            int enigmaResonatorLevel = EnchantmentHelper.func_77506_a((Enchantment)MeleeRangedEnchantmentList.ENIGMA_RESONATOR, (ItemStack)mainhand);
            float soulsCriticalBoostChanceCap = 0.1f + 0.05f * (float)enigmaResonatorLevel;
            float soulsCriticalBoostRand = attacker.func_70681_au().nextFloat();
            if ((double)soulsCriticalBoostRand <= Math.min((double)numSouls / 50.0, (double)soulsCriticalBoostChanceCap)) {
                return true;
            }
        }
        if (uniqueWeaponFlag) {
            float soulsCriticalBoostRand = attacker.func_70681_au().nextFloat();
            return (double)soulsCriticalBoostRand <= Math.min((double)numSouls / 50.0, (double)0.15f);
        }
        return false;
    }

    public static void setProjectileTowards(ProjectileEntity projectileEntity, double x, double y, double z, float inaccuracy) {
        Random random = new Random();
        Vector3d vector3d = new Vector3d(x, y, z).func_72432_b().func_72441_c(random.nextGaussian() * (double)0.0075f * (double)inaccuracy, random.nextGaussian() * (double)0.0075f * (double)inaccuracy, random.nextGaussian() * (double)0.0075f * (double)inaccuracy);
        projectileEntity.func_213317_d(vector3d);
        float f = MathHelper.func_76133_a((double)Entity.func_213296_b((Vector3d)vector3d));
        projectileEntity.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
        projectileEntity.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875);
        projectileEntity.field_70126_B = projectileEntity.field_70177_z;
        projectileEntity.field_70127_C = projectileEntity.field_70125_A;
    }
}

