/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_gear.utilties;

import com.infamous.dungeons_gear.capabilities.weapon.IWeapon;
import com.infamous.dungeons_gear.enchantments.lists.RangedEnchantmentList;
import com.infamous.dungeons_gear.init.DeferredItemInit;
import com.infamous.dungeons_gear.ranged.bows.AbstractDungeonsBowItem;
import com.infamous.dungeons_gear.ranged.crossbows.AbstractDungeonsCrossbowItem;
import com.infamous.dungeons_gear.utilties.CapabilityHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;

public class RangedAttackHelper {
    public static int getVanillaCrossbowChargeTime(ItemStack stack) {
        int quickChargeLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
        int accelerateLevel = EnchantmentHelper.func_77506_a((Enchantment)RangedEnchantmentList.ACCELERATE, (ItemStack)stack);
        IWeapon weaponCap = CapabilityHelper.getWeaponCapability(stack);
        if (weaponCap == null) {
            return Math.max(25 - 5 * quickChargeLevel, 0);
        }
        int crossbowChargeTime = weaponCap.getCrossbowChargeTime();
        long lastFiredTime = weaponCap.getLastFiredTime();
        if (accelerateLevel > 0 && lastFiredTime > 0L) {
            return Math.max(crossbowChargeTime - 5 * quickChargeLevel, 0);
        }
        return Math.max(25 - 5 * quickChargeLevel, 0);
    }

    public static float getVanillaArrowVelocity(ItemStack stack, int charge) {
        float bowChargeTime = RangedAttackHelper.getVanillaBowChargeTime(stack);
        if (bowChargeTime <= 0.0f) {
            bowChargeTime = 1.0f;
        }
        float arrowVelocity = (float)charge / bowChargeTime;
        if ((arrowVelocity = (arrowVelocity * arrowVelocity + arrowVelocity * 2.0f) / 3.0f) > 1.0f) {
            arrowVelocity = 1.0f;
        }
        return arrowVelocity;
    }

    public static float getVanillaBowChargeTime(ItemStack stack) {
        int quickChargeLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
        int accelerateLevel = EnchantmentHelper.func_77506_a((Enchantment)RangedEnchantmentList.ACCELERATE, (ItemStack)stack);
        IWeapon weaponCap = CapabilityHelper.getWeaponCapability(stack);
        if (weaponCap == null) {
            return Math.max(20.0f - (float)(5 * quickChargeLevel), 0.0f);
        }
        float bowChargeTime = weaponCap.getBowChargeTime();
        long lastFiredTime = weaponCap.getLastFiredTime();
        if (accelerateLevel > 0 && lastFiredTime > 0L) {
            return Math.max(bowChargeTime - (float)(5 * quickChargeLevel), 0.0f);
        }
        return Math.max(20.0f - (float)(5 * quickChargeLevel), 0.0f);
    }

    public static void addWeaponTags(AbstractArrowEntity arrowEntity, ItemStack stack) {
        if (stack.func_77973_b() == DeferredItemInit.BONEBOW.get()) {
            arrowEntity.func_184211_a("Bonebow");
        }
        if (stack.func_77973_b() == DeferredItemInit.BOW_OF_LOST_SOULS.get()) {
            arrowEntity.func_184211_a("BowOfLostSouls");
        }
        if (stack.func_77973_b() == DeferredItemInit.ELITE_POWER_BOW.get()) {
            arrowEntity.func_184211_a("ElitePowerBow");
        }
        if (stack.func_77973_b() == DeferredItemInit.GUARDIAN_BOW.get()) {
            arrowEntity.func_184211_a("GuardianBow");
        }
        if (stack.func_77973_b() == DeferredItemInit.HUNTERS_PROMISE.get()) {
            arrowEntity.func_184211_a("HuntersPromise");
        }
        if (stack.func_77973_b() == DeferredItemInit.MASTERS_BOW.get()) {
            arrowEntity.func_184211_a("MastersBow");
        }
        if (stack.func_77973_b() == DeferredItemInit.NOCTURNAL_BOW.get()) {
            arrowEntity.func_184211_a("NocturnalBow");
        }
        if (stack.func_77973_b() == DeferredItemInit.RED_SNAKE.get()) {
            arrowEntity.func_184211_a("RedSnake");
        }
        if (stack.func_77973_b() == DeferredItemInit.SABREWING.get()) {
            arrowEntity.func_184211_a("Sabrewing");
        }
        if (stack.func_77973_b() == DeferredItemInit.THE_GREEN_MENACE.get()) {
            arrowEntity.func_184211_a("TheGreenMenace");
        }
        if (stack.func_77973_b() == DeferredItemInit.THE_PINK_SCOUNDREL.get()) {
            arrowEntity.func_184211_a("ThePinkScoundrel");
        }
        if (stack.func_77973_b() == DeferredItemInit.TWIN_BOW.get()) {
            arrowEntity.func_184211_a("TwinBow");
        }
        if (stack.func_77973_b() == DeferredItemInit.HUNTING_BOW.get()) {
            arrowEntity.func_184211_a("HuntingBow");
        }
        if (stack.func_77973_b() == DeferredItemInit.LONGBOW.get()) {
            arrowEntity.func_184211_a("Longbow");
        }
        if (stack.func_77973_b() == DeferredItemInit.SHORTBOW.get()) {
            arrowEntity.func_184211_a("Shortbow");
        }
        if (stack.func_77973_b() == DeferredItemInit.POWER_BOW.get()) {
            arrowEntity.func_184211_a("PowerBow");
        }
        if (stack.func_77973_b() == DeferredItemInit.SOUL_BOW.get()) {
            arrowEntity.func_184211_a("SoulBow");
        }
        if (stack.func_77973_b() == DeferredItemInit.TRICKBOW.get()) {
            arrowEntity.func_184211_a("Trickbow");
        }
        if (stack.func_77973_b() == DeferredItemInit.SNOW_BOW.get()) {
            arrowEntity.func_184211_a("SnowBow");
        }
        if (stack.func_77973_b() == DeferredItemInit.WINTERS_TOUCH.get()) {
            arrowEntity.func_184211_a("WintersTouch");
        }
        if (stack.func_77973_b() == DeferredItemInit.ANCIENT_BOW.get()) {
            arrowEntity.func_184211_a("AncientBow");
        }
        if (stack.func_77973_b() == DeferredItemInit.LOVE_SPELL_BOW.get()) {
            arrowEntity.func_184211_a("LoveSpellBow");
        }
        if (stack.func_77973_b() == DeferredItemInit.AZURE_SEEKER.get()) {
            arrowEntity.func_184211_a("AzureSeeker");
        }
        if (stack.func_77973_b() == DeferredItemInit.BUTTERFLY_CROSSBOW.get()) {
            arrowEntity.func_184211_a("ButterflyCrossbow");
        }
        if (stack.func_77973_b() == DeferredItemInit.DOOM_CROSSBOW.get()) {
            arrowEntity.func_184211_a("DoomCrossbow");
        }
        if (stack.func_77973_b() == DeferredItemInit.FERAL_SOUL_CROSSBOW.get()) {
            arrowEntity.func_184211_a("FeralSoulCrossbow");
        }
        if (stack.func_77973_b() == DeferredItemInit.FIREBOLT_THROWER.get()) {
            arrowEntity.func_184211_a("FireboltThrower");
        }
        if (stack.func_77973_b() == DeferredItemInit.HARP_CROSSBOW.get()) {
            arrowEntity.func_184211_a("HarpCrossbow");
        }
        if (stack.func_77973_b() == DeferredItemInit.LIGHTNING_HARP_CROSSBOW.get()) {
            arrowEntity.func_184211_a("LightningHarpCrossbow");
        }
        if (stack.func_77973_b() == DeferredItemInit.SLAYER_CROSSBOW.get()) {
            arrowEntity.func_184211_a("SlayerCrossbow");
        }
        if (stack.func_77973_b() == DeferredItemInit.THE_SLICER.get()) {
            arrowEntity.func_184211_a("TheSlicer");
        }
        if (stack.func_77973_b() == DeferredItemInit.VOIDCALLER.get()) {
            arrowEntity.func_184211_a("Voidcaller");
        }
        if (stack.func_77973_b() == DeferredItemInit.DUAL_CROSSBOW.get()) {
            arrowEntity.func_184211_a("DualCrossbow");
        }
        if (stack.func_77973_b() == DeferredItemInit.BABY_CROSSBOW.get()) {
            arrowEntity.func_184211_a("BabyCrossbow");
        }
        if (stack.func_77973_b() == DeferredItemInit.EXPLODING_CROSSBOW.get()) {
            arrowEntity.func_184211_a("ExplodingCrossbow");
        }
        if (stack.func_77973_b() == DeferredItemInit.HEAVY_CROSSBOW.get()) {
            arrowEntity.func_184211_a("HeavyCrossbow");
        }
        if (stack.func_77973_b() == DeferredItemInit.RAPID_CROSSBOW.get()) {
            arrowEntity.func_184211_a("RapidCrossbow");
        }
        if (stack.func_77973_b() == DeferredItemInit.SCATTER_CROSSBOW.get()) {
            arrowEntity.func_184211_a("ScatterCrossbow");
        }
        if (stack.func_77973_b() == DeferredItemInit.SOUL_CROSSBOW.get()) {
            arrowEntity.func_184211_a("SoulCrossbow");
        }
        if (stack.func_77973_b() == DeferredItemInit.IMPLODING_CROSSBOW.get()) {
            arrowEntity.func_184211_a("ImplodingCrossbow");
        }
    }

    public static int getModdedCrossbowChargeTime(ItemStack stack) {
        int chargeTime = stack.func_77973_b() instanceof AbstractDungeonsCrossbowItem ? ((AbstractDungeonsCrossbowItem)stack.func_77973_b()).getCrossbowChargeTime(stack) : 25;
        return chargeTime;
    }

    public static float getModdedBowChargeTime(ItemStack stack) {
        float chargeTime = stack.func_77973_b() instanceof AbstractDungeonsBowItem ? ((AbstractDungeonsBowItem)stack.func_77973_b()).getBowChargeTime(stack) : 20.0f;
        return chargeTime;
    }

    public static float getvVanillaOrModdedCrossbowArrowVelocity(ItemStack stack) {
        float arrowVelocity = stack.func_77973_b() instanceof AbstractDungeonsCrossbowItem ? ((AbstractDungeonsCrossbowItem)stack.func_77973_b()).getProjectileVelocity(stack) : (CrossbowItem.func_220019_a((ItemStack)stack, (Item)Items.field_196152_dE) ? 1.6f : 3.15f);
        return arrowVelocity;
    }

    public static float getVanillaOrModdedBowArrowVelocity(ItemStack stack, int charge) {
        float arrowVelocity = stack.func_77973_b() instanceof AbstractDungeonsBowItem ? ((AbstractDungeonsBowItem)stack.func_77973_b()).getBowArrowVelocity(stack, charge) : RangedAttackHelper.getVanillaArrowVelocity(stack, charge);
        return arrowVelocity;
    }
}

