/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob.utils;

import com.baguchan.enchantwithmob.capability.MobEnchantCapability;
import com.baguchan.enchantwithmob.capability.MobEnchantHandler;
import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.baguchan.enchantwithmob.registry.ModItems;
import com.baguchan.enchantwithmob.registry.ModMobEnchants;
import com.baguchan.enchantwithmob.utils.MobEnchantmentData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MobEnchantUtils {
    public static final String TAG_MOBENCHANT = "MobEnchant";
    public static final String TAG_ENCHANT_LEVEL = "EnchantLevel";
    public static final String TAG_STORED_MOBENCHANTS = "StoredMobEnchants";

    @Nullable
    public static MobEnchant getEnchantFromNBT(@Nullable CompoundNBT tag) {
        if (tag != null && ModMobEnchants.getRegistry().containsKey(ResourceLocation.func_208304_a((String)tag.func_74779_i(TAG_MOBENCHANT)))) {
            return (MobEnchant)ModMobEnchants.getRegistry().getValue(ResourceLocation.func_208304_a((String)tag.func_74779_i(TAG_MOBENCHANT)));
        }
        return null;
    }

    public static int getEnchantLevelFromNBT(@Nullable CompoundNBT tag) {
        if (tag != null) {
            return tag.func_74762_e(TAG_ENCHANT_LEVEL);
        }
        return 0;
    }

    @Nullable
    public static MobEnchant getEnchantFromString(@Nullable String id) {
        if (id != null && ModMobEnchants.getRegistry().containsKey(ResourceLocation.func_208304_a((String)id))) {
            return (MobEnchant)ModMobEnchants.getRegistry().getValue(ResourceLocation.func_208304_a((String)id));
        }
        return null;
    }

    public static boolean hasMobEnchant(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        return compoundnbt != null && compoundnbt.func_74764_b(TAG_STORED_MOBENCHANTS);
    }

    public static ListNBT getEnchantmentListForNBT(CompoundNBT compoundnbt) {
        return compoundnbt != null ? compoundnbt.func_150295_c(TAG_STORED_MOBENCHANTS, 10) : new ListNBT();
    }

    public static Map<MobEnchant, Integer> getEnchantments(ItemStack stack) {
        ListNBT listnbt = MobEnchantUtils.getEnchantmentListForNBT(stack.func_77978_p());
        return MobEnchantUtils.makeMobEnchantListFromListNBT(listnbt);
    }

    public static void setEnchantments(Map<MobEnchant, Integer> enchMap, ItemStack stack) {
        ListNBT listnbt = new ListNBT();
        for (Map.Entry<MobEnchant, Integer> entry : enchMap.entrySet()) {
            MobEnchant enchantment = entry.getKey();
            if (enchantment == null) continue;
            int i = entry.getValue();
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74778_a(TAG_MOBENCHANT, String.valueOf(ModMobEnchants.getRegistry().getKey((IForgeRegistryEntry)enchantment)));
            compoundnbt.func_74777_a(TAG_ENCHANT_LEVEL, (short)i);
            listnbt.add((Object)compoundnbt);
            if (stack.func_77973_b() != ModItems.MOB_ENCHANT_BOOK) continue;
            MobEnchantUtils.addMobEnchantToItemStack(stack, enchantment, i);
        }
        if (listnbt.isEmpty()) {
            stack.func_196083_e(TAG_STORED_MOBENCHANTS);
        }
    }

    private static Map<MobEnchant, Integer> makeMobEnchantListFromListNBT(ListNBT p_226652_0_) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (int i = 0; i < p_226652_0_.size(); ++i) {
            CompoundNBT compoundnbt = p_226652_0_.func_150305_b(i);
            MobEnchant mobEnchant = MobEnchantUtils.getEnchantFromString(compoundnbt.func_74779_i(TAG_MOBENCHANT));
            map.put(mobEnchant, compoundnbt.func_74762_e(TAG_ENCHANT_LEVEL));
        }
        return map;
    }

    public static void addMobEnchantToItemStack(ItemStack itemIn, MobEnchant mobenchant, int level) {
        ListNBT listnbt = MobEnchantUtils.getEnchantmentListForNBT(itemIn.func_77978_p());
        boolean flag = true;
        ResourceLocation resourcelocation = ModMobEnchants.getRegistry().getKey((IForgeRegistryEntry)mobenchant);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            ResourceLocation resourcelocation1 = ResourceLocation.func_208304_a((String)compoundnbt.func_74779_i(TAG_MOBENCHANT));
            if (resourcelocation1 == null || !resourcelocation1.equals((Object)resourcelocation)) continue;
            if (compoundnbt.func_74762_e(TAG_ENCHANT_LEVEL) < level) {
                compoundnbt.func_74768_a(TAG_ENCHANT_LEVEL, level);
            }
            flag = false;
            break;
        }
        if (flag) {
            CompoundNBT compoundnbt1 = new CompoundNBT();
            compoundnbt1.func_74778_a(TAG_MOBENCHANT, String.valueOf(resourcelocation));
            compoundnbt1.func_74768_a(TAG_ENCHANT_LEVEL, level);
            listnbt.add((Object)compoundnbt1);
        }
        itemIn.func_77978_p().func_218657_a(TAG_STORED_MOBENCHANTS, (INBT)listnbt);
    }

    public static void addItemMobEnchantToEntity(ItemStack itemIn, LivingEntity entity, MobEnchantCapability capability) {
        ListNBT listnbt = MobEnchantUtils.getEnchantmentListForNBT(itemIn.func_77978_p());
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob(MobEnchantUtils.getEnchantFromNBT(compoundnbt), entity, capability)) continue;
            capability.addMobEnchant(entity, MobEnchantUtils.getEnchantFromNBT(compoundnbt), MobEnchantUtils.getEnchantLevelFromNBT(compoundnbt));
        }
    }

    public static void removeMobEnchantToEntity(LivingEntity entity, MobEnchantCapability capability) {
        capability.removeAllMobEnchant(entity);
    }

    public static int getExperienceFromMob(MobEnchantCapability cap) {
        int l = 0;
        for (MobEnchantHandler list : cap.getMobEnchants()) {
            MobEnchant enchantment = list.getMobEnchant();
            int integer = list.getEnchantLevel();
            l += enchantment.getMinEnchantability(integer);
        }
        return l;
    }

    public static int getExperienceFromItemStack(ItemStack stack) {
        int l = 0;
        Map<MobEnchant, Integer> map = MobEnchantUtils.getEnchantments(stack);
        for (Map.Entry<MobEnchant, Integer> entry : map.entrySet()) {
            MobEnchant enchantment = entry.getKey();
            Integer integer = entry.getValue();
            l += enchantment.getMinEnchantability(integer);
        }
        return l;
    }

    public static void addRandomEnchantmentToEntity(LivingEntity livingEntity, MobEnchantCapability capability, Random random, int level, boolean allowRare) {
        List<MobEnchantmentData> list = MobEnchantUtils.buildEnchantmentList(random, level, allowRare);
        for (MobEnchantmentData enchantmentdata : list) {
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob(enchantmentdata.enchantment, livingEntity, capability)) continue;
            capability.addMobEnchant(livingEntity, enchantmentdata.enchantment, enchantmentdata.enchantmentLevel);
        }
    }

    public static ItemStack addRandomEnchantmentToItemStack(Random random, ItemStack stack, int level, boolean allowRare) {
        List<MobEnchantmentData> list = MobEnchantUtils.buildEnchantmentList(random, level, allowRare);
        for (MobEnchantmentData enchantmentdata : list) {
            MobEnchantUtils.addMobEnchantToItemStack(stack, enchantmentdata.enchantment, enchantmentdata.enchantmentLevel);
        }
        return stack;
    }

    public static boolean findMobEnchant(List<MobEnchant> list, MobEnchant findMobEnchant) {
        for (MobEnchant mobEnchant : list) {
            if (!((Object)((Object)mobEnchant)).equals((Object)findMobEnchant)) continue;
            return true;
        }
        return false;
    }

    public static boolean findMobEnchantFromHandler(List<MobEnchantHandler> list, MobEnchant findMobEnchant) {
        for (MobEnchantHandler mobEnchant : list) {
            if (mobEnchant == null || !((Object)((Object)mobEnchant.getMobEnchant())).equals((Object)findMobEnchant)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAllowMobEnchantFromMob(@Nullable MobEnchant mobEnchant, LivingEntity livingEntity, MobEnchantCapability capability) {
        for (MobEnchantHandler enchantHandler : capability.getMobEnchants()) {
            if ((mobEnchant == null || mobEnchant.isCompatibleMob(livingEntity)) && (mobEnchant == null || enchantHandler.getMobEnchant() == null || enchantHandler.getMobEnchant().isCompatibleWith(mobEnchant))) continue;
            return false;
        }
        return true;
    }

    public static int getMobEnchantLevelFromHandler(List<MobEnchantHandler> list, MobEnchant findMobEnchant) {
        for (MobEnchantHandler mobEnchant : list) {
            if (mobEnchant == null || !((Object)((Object)mobEnchant.getMobEnchant())).equals((Object)findMobEnchant)) continue;
            return mobEnchant.getEnchantLevel();
        }
        return 0;
    }

    public static List<MobEnchantmentData> buildEnchantmentList(Random randomIn, int level, boolean allowRare) {
        ArrayList list = Lists.newArrayList();
        int i = 1;
        if (i <= 0) {
            return list;
        }
        level = level + 1 + randomIn.nextInt(i / 4 + 1) + randomIn.nextInt(i / 4 + 1);
        float f = (randomIn.nextFloat() + randomIn.nextFloat() - 1.0f) * 0.15f;
        List<MobEnchantmentData> list1 = MobEnchantUtils.makeMobEnchantmentDatas(level = MathHelper.func_76125_a((int)Math.round((float)level + (float)level * f), (int)1, (int)Integer.MAX_VALUE), allowRare);
        if (!list1.isEmpty()) {
            list.add(WeightedRandom.func_76271_a((Random)randomIn, list1));
            while (randomIn.nextInt(50) <= level) {
                MobEnchantUtils.removeIncompatible(list1, (MobEnchantmentData)((Object)Util.func_223378_a((List)list)));
                if (list1.isEmpty()) break;
                list.add(WeightedRandom.func_76271_a((Random)randomIn, list1));
                level /= 2;
            }
        }
        return list;
    }

    public static List<MobEnchantmentData> makeMobEnchantmentDatas(int p_185291_0_, boolean allowRare) {
        ArrayList list = Lists.newArrayList();
        block0: for (MobEnchant enchantment : ModMobEnchants.getRegistry().getValues()) {
            if ((enchantment.getRarity() == MobEnchant.Rarity.RARE || enchantment.getRarity() == MobEnchant.Rarity.VERY_RARE) && !allowRare) continue;
            for (int i = enchantment.getMaxLevel(); i > enchantment.getMinLevel() - 1; --i) {
                if (p_185291_0_ < enchantment.getMinEnchantability(i) || p_185291_0_ > enchantment.getMaxEnchantability(i)) continue;
                list.add(new MobEnchantmentData(enchantment, i));
                continue block0;
            }
        }
        return list;
    }

    private static void removeIncompatible(List<MobEnchantmentData> dataList, MobEnchantmentData data) {
        Iterator<MobEnchantmentData> iterator = dataList.iterator();
        while (iterator.hasNext()) {
            if (data.enchantment.isCompatibleWith(iterator.next().enchantment)) continue;
            iterator.remove();
        }
    }
}

