/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.items;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelLoader;
import wile.engineerstools.detail.ModRenderers;
import wile.engineerstools.items.EtItem;
import wile.engineerstools.libmc.detail.Auxiliaries;
import wile.engineerstools.libmc.detail.Overlay;

public class TrackerItem
extends EtItem {
    private static final ConcurrentHashMap<Integer, Tuple<Integer, Integer>> tracker_angles = new ConcurrentHashMap();

    public TrackerItem(Item.Properties properties) {
        super(properties.func_200917_a(1).setNoRepair().setISTER(TrackerItem::createIster));
    }

    private static Callable<ItemStackTileEntityRenderer> createIster() {
        return ModRenderers.TrackerIster::new;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerModels() {
        ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(new ResourceLocation("engineerstools", "tracker_model"), "inventory"));
        ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(new ResourceLocation("engineerstools", "tracker_pointer_model"), "inventory"));
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (Auxiliaries.Tooltip.helpCondition() || Auxiliaries.Tooltip.extendedTipCondition()) {
            super.func_77624_a(stack, world, tooltip, flag);
            return;
        }
        CompoundNBT nbt = stack.func_179543_a("trackerdata");
        if (nbt == null) {
            return;
        }
        int distance = -1;
        String dimension_name = "";
        String text = "";
        if (nbt.func_74764_b("target")) {
            BlockPos target_pos = BlockPos.func_218283_e((long)nbt.func_74763_f("target"));
            if (nbt.func_74764_b("playerpos")) {
                distance = (int)Math.sqrt(BlockPos.func_218283_e((long)nbt.func_74763_f("playerpos")).func_177951_i((Vector3i)target_pos));
            }
        } else {
            dimension_name = nbt.func_74779_i("dimensionid");
        }
        if (nbt.func_74764_b("location")) {
            BlockPos pos = BlockPos.func_218283_e((long)nbt.func_74763_f("location"));
            text = "[" + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + "]";
            text = Auxiliaries.localizable("item.engineerstools.tracker.tip.target.location", null, text).getString();
        } else if (nbt.func_74764_b("entityname")) {
            text = nbt.func_74779_i("entityname");
            if (text.isEmpty()) {
                return;
            }
            text = Auxiliaries.localizable("item.engineerstools.tracker.tip.target.entity", null, text).getString();
        }
        if (distance >= 0) {
            if (distance > 0) {
                text = text + Auxiliaries.localizable("item.engineerstools.tracker.tip.target.distance", null, distance).getString();
            }
        } else if (!dimension_name.isEmpty()) {
            text = text + Auxiliaries.localizable("item.engineerstools.tracker.tip.dimension." + dimension_name, null, distance).getString();
        }
        tooltip.add((ITextComponent)new StringTextComponent(text));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.func_201670_d()) {
            return ActionResultType.CONSUME;
        }
        if (!this.checkOverwrite(context.func_195996_i(), context.func_195999_j())) {
            return ActionResultType.FAIL;
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74772_a("location", context.func_195995_a().func_218275_a());
        nbt.func_74768_a("dimension", this.dimensionIdentifier(world));
        nbt.func_74778_a("dimensionid", this.dimensionName(world));
        context.func_195996_i().func_77983_a("trackerdata", (INBT)nbt);
        Overlay.show(context.func_195999_j(), (ITextComponent)Auxiliaries.localizable("item.engineerstools.tracker.msg.locationset"));
        return ActionResultType.SUCCESS;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (player.func_130014_f_().func_201670_d()) {
            return ActionResultType.CONSUME;
        }
        if (!this.checkOverwrite(stack, player)) {
            return ActionResultType.FAIL;
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_186854_a("entity", target.func_110124_au());
        nbt.func_74778_a("entityname", target.func_145748_c_().getString());
        stack.func_77983_a("trackerdata", (INBT)nbt);
        Overlay.show(player, (ITextComponent)Auxiliaries.localizable("item.engineerstools.tracker.msg.entityset", null, target.func_145748_c_()));
        return ActionResultType.SUCCESS;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        if (world instanceof ServerWorld) {
            this.serverTick(stack, (ServerWorld)world, (PlayerEntity)entity, slot, selected);
        } else {
            this.clientTick(stack, world, (PlayerEntity)entity, slot, selected);
        }
    }

    private boolean checkOverwrite(ItemStack stack, PlayerEntity player) {
        CompoundNBT nbt = stack.func_179543_a("trackerdata");
        if (nbt == null || nbt.isEmpty()) {
            return true;
        }
        if (player.func_70040_Z().field_72448_b < -0.98) {
            stack.func_77982_d(null);
            Overlay.show(player, (ITextComponent)Auxiliaries.localizable("item.engineerstools.tracker.hint.cleared"));
        } else {
            Overlay.show(player, (ITextComponent)Auxiliaries.localizable("item.engineerstools.tracker.hint.clearfirst"));
        }
        return false;
    }

    public static Optional<Tuple<Integer, Integer>> getUiAngles(ItemStack stack) {
        CompoundNBT nbt = stack.func_179543_a("trackerdata");
        if (nbt == null || !nbt.func_74764_b("id")) {
            return Optional.empty();
        }
        Tuple rot = tracker_angles.getOrDefault(nbt.func_74762_e("id"), null);
        return rot == null ? Optional.empty() : Optional.of(rot);
    }

    private int dimensionIdentifier(World world) {
        return this.dimensionName(world).hashCode();
    }

    private String dimensionName(World world) {
        if (world.func_234923_W_() == World.field_234918_g_) {
            return "overworld";
        }
        if (world.func_234923_W_() == World.field_234919_h_) {
            return "nether";
        }
        if (world.func_234923_W_() == World.field_234920_i_) {
            return "end";
        }
        return "other";
    }

    private void clientTick(ItemStack stack, World world, PlayerEntity player, int slot, boolean selected) {
        CompoundNBT nbt = stack.func_179543_a("trackerdata");
        if (nbt == null || nbt.isEmpty() || !nbt.func_74764_b("id")) {
            return;
        }
        if (!nbt.func_74764_b("target")) {
            tracker_angles.remove(nbt.func_74762_e("id"));
            return;
        }
        BlockPos pos = BlockPos.func_218283_e((long)nbt.func_74763_f("target"));
        Vector3d gdv = new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_178788_d(player.func_213303_ch());
        double dsq = gdv.func_189985_c();
        if (dsq < 0.3) {
            return;
        }
        double xz_distance = new Vector3d(gdv.field_72450_a, 0.0, gdv.field_72449_c).func_72433_c();
        double y_distance = Math.abs(gdv.field_72448_b);
        gdv = gdv.func_72432_b();
        Vector3d ldv = player.func_70040_Z();
        double ry = (Math.atan2(ldv.field_72449_c, ldv.field_72450_a) - Math.atan2(gdv.field_72449_c, gdv.field_72450_a)) * 180.0 / Math.PI;
        double rx = y_distance + 5.0 > xz_distance ? (Math.acos(ldv.field_72448_b) - Math.acos(gdv.field_72448_b)) * 180.0 / Math.PI : 0.0;
        double inc = 10.0;
        if (rx > 180.0) {
            rx -= 360.0;
        }
        if (ry > 180.0) {
            ry -= 360.0;
        }
        if (Math.abs(rx) < 30.0) {
            rx = 0.0;
        }
        nbt.func_74772_a("playerpos", new BlockPos(player.func_213303_ch()).func_218275_a());
        tracker_angles.put(nbt.func_74762_e("id"), (Tuple<Integer, Integer>)new Tuple((Object)((int)rx), (Object)((int)ry)));
    }

    private void serverTick(ItemStack stack, ServerWorld world, PlayerEntity player, int slot, boolean selected) {
        if ((world.func_82737_E() & 7L) != 0L) {
            return;
        }
        if (stack.func_77978_p() == null || stack.func_77978_p().isEmpty()) {
            return;
        }
        boolean changed = false;
        CompoundNBT nbt = stack.func_190925_c("trackerdata");
        if (!nbt.func_74764_b("id")) {
            nbt.func_74768_a("id", world.func_201674_k().nextInt());
            if (tracker_angles.size() > 128) {
                tracker_angles.clear();
            }
        }
        if (nbt.func_74764_b("location")) {
            long pos = nbt.func_74763_f("location");
            long uipos = nbt.func_74763_f("target");
            if ((long)this.dimensionIdentifier((World)world) != nbt.func_74763_f("dimension")) {
                if (nbt.func_74764_b("target")) {
                    nbt.func_82580_o("target");
                    changed = true;
                }
            } else if (pos != uipos) {
                nbt.func_74772_a("target", pos);
                changed = true;
            }
        } else if (nbt.func_74764_b("entity")) {
            Entity target = world.func_217461_a(nbt.func_186857_a("entity"));
            if (target == null || target.func_130014_f_() == null || this.dimensionIdentifier(target.func_130014_f_()) != this.dimensionIdentifier(player.func_130014_f_())) {
                if (nbt.func_74764_b("target")) {
                    nbt.func_82580_o("target");
                    changed = true;
                }
            } else {
                BlockPos uipos = BlockPos.func_218283_e((long)nbt.func_74763_f("target"));
                if (player.func_70068_e(target) > 200.0) {
                    if (uipos.func_218138_a((IPosition)target.func_213303_ch(), false) > 10.0) {
                        nbt.func_74772_a("target", new BlockPos(target.func_213303_ch()).func_218275_a());
                        changed = true;
                    }
                } else if (uipos.func_218138_a((IPosition)target.func_213303_ch(), false) > 2.78) {
                    nbt.func_74772_a("target", new BlockPos(target.func_213303_ch()).func_218275_a());
                    changed = true;
                }
            }
            if (changed && target != null && target.func_130014_f_() != null) {
                String target_dimension = this.dimensionName(target.func_130014_f_());
                if (!nbt.func_74779_i("dimensionid").equals(target_dimension)) {
                    nbt.func_74778_a("dimensionid", target_dimension);
                    changed = true;
                }
            }
        }
        if (changed) {
            stack.func_77983_a("trackerdata", (INBT)nbt);
        }
    }
}

