/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.client.models;

import com.integral.enigmaticlegacy.client.models.DarkArmorModel;
import com.integral.enigmaticlegacy.client.models.GenericArmorModel;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpecialArmorModelRenderer
extends ModelRenderer {
    public static boolean CONFIG_UPDATED = false;
    private GenericArmorModel model;

    public SpecialArmorModelRenderer(GenericArmorModel model, @Nullable List<SpecialArmorModelRenderer> includeIn) {
        super((Model)model);
        model.accept(this);
        this.func_78787_b(model.field_78090_t, model.field_78089_u);
        if (includeIn != null) {
            includeIn.add(this);
        }
        this.model = model;
    }

    public SpecialArmorModelRenderer(GenericArmorModel model, int texOffX, int texOffY) {
        this(model.field_78090_t, model.field_78089_u, texOffX, texOffY);
        model.accept(this);
        this.model = model;
    }

    public SpecialArmorModelRenderer(int textureWidthIn, int textureHeightIn, int textureOffsetXIn, int textureOffsetYIn) {
        super(textureWidthIn, textureHeightIn, textureOffsetXIn, textureOffsetYIn);
        this.func_78787_b(textureWidthIn, textureHeightIn);
        this.setTextureOffset(textureOffsetXIn, textureOffsetYIn);
    }

    public SpecialArmorModelRenderer setTextureOffset(int x, int y) {
        super.func_78784_a(x, y);
        return this;
    }

    public void addBox(float x, float y, float z, float width, float height, float depth, float delta, boolean mirrorIn, float offsetX, float offsetY, float offsetZ) {
        super.func_228303_a_(x + offsetX, y + offsetY, z + offsetZ, width, height, depth, delta, mirrorIn);
    }

    public void addBox(float x, float y, float z, float width, float height, float depth, float delta, boolean mirrorIn, AnchorType anchorType) {
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        float offsetZ = 0.0f;
        if (this.model instanceof DarkArmorModel) {
            offsetX = DarkArmorModel.darkArmorOffsetMap.get(anchorType.name + "_x").floatValue();
            offsetY = DarkArmorModel.darkArmorOffsetMap.get(anchorType.name + "_y").floatValue();
            offsetZ = DarkArmorModel.darkArmorOffsetMap.get(anchorType.name + "_z").floatValue();
        }
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        float deltaZ = 0.0f;
        deltaX = width - (float)((int)width);
        deltaY = height - (float)((int)height);
        deltaZ = depth - (float)((int)depth);
        this.addBox(x + offsetX + (deltaX /= 2.0f), y + offsetY + (deltaY /= 2.0f), z + offsetZ + (deltaZ /= 2.0f), (int)width, (int)height, (int)depth, deltaX + delta, deltaY + delta, deltaZ + delta, mirrorIn);
    }

    public void addBox(float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirrorIn) {
        this.field_78809_i = mirrorIn;
        super.func_228302_a_(x, y, z, width, height, depth, deltaX + 0.01f, deltaY + 0.01f, deltaZ + 0.01f);
    }

    public void setRotationPoint(float rotationPointXIn, float rotationPointYIn, float rotationPointZIn, AnchorType anchorType) {
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        float offsetZ = 0.0f;
        if (this.model instanceof DarkArmorModel) {
            offsetX = DarkArmorModel.darkArmorOffsetMap.get(anchorType.name + "_x").floatValue();
            offsetY = DarkArmorModel.darkArmorOffsetMap.get(anchorType.name + "_y").floatValue();
            offsetZ = DarkArmorModel.darkArmorOffsetMap.get(anchorType.name + "_z").floatValue();
        }
        this.field_78800_c = rotationPointXIn + offsetX;
        this.field_78797_d = rotationPointYIn + offsetY;
        this.field_78798_e = rotationPointZIn + offsetZ;
    }

    public static enum AnchorType {
        HEAD("head"),
        CHEST("chest"),
        ARM_LEFT("arm_left"),
        ARM_RIGHT("arm_right"),
        LEG_LEFT("leg_left"),
        LEG_RIGHT("leg_right");

        public final String name;

        private AnchorType(String paramName) {
            this.name = paramName;
        }
    }
}

