/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.crafting;

import com.google.gson.JsonObject;
import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.crafting.EnigmaticRecipeSerializers;
import com.integral.enigmaticlegacy.helpers.ItemNBTHelper;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BindToPlayerRecipe
extends ShapelessRecipe {
    public BindToPlayerRecipe(ResourceLocation id, String group, ItemStack output, NonNullList<Ingredient> inputs) {
        super(id, group, output, inputs);
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ItemStack gem = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack slotStack = inv.func_70301_a(i);
            if (slotStack.func_190926_b()) continue;
            if (slotStack.func_77973_b() == EnigmaticLegacy.gemOfBinding) {
                if (gem == null) {
                    gem = slotStack;
                    continue;
                }
                return ItemStack.field_190927_a;
            }
            stackList.add(slotStack);
        }
        if (stackList.size() == 1 && ((ItemStack)stackList.get(0)).func_77973_b() instanceof IBound && gem != null && ItemNBTHelper.verifyExistance(gem, "BoundPlayer") && ItemNBTHelper.containsUUID(gem, "BoundUUID")) {
            ItemStack returned = ((ItemStack)stackList.get(0)).func_77946_l();
            ItemNBTHelper.setString(returned, "BoundPlayer", ItemNBTHelper.getString(gem, "BoundPlayer", "Herobrine"));
            ItemNBTHelper.setUUID(returned, "BoundUUID", ItemNBTHelper.getUUID(gem, "BoundUUID", null));
            return returned;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_77569_a(CraftingInventory inv, World world) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ItemStack gem = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack slotStack = inv.func_70301_a(i);
            if (slotStack.func_190926_b()) continue;
            if (slotStack.func_77973_b() == EnigmaticLegacy.gemOfBinding) {
                if (gem == null) {
                    gem = slotStack;
                    continue;
                }
                return false;
            }
            stackList.add(slotStack);
        }
        return stackList.size() == 1 && ((ItemStack)stackList.get(0)).func_77973_b() instanceof IBound && gem != null && ItemNBTHelper.verifyExistance(gem, "BoundPlayer") && ItemNBTHelper.containsUUID(gem, "BoundUUID");
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return EnigmaticRecipeSerializers.BIND_TO_PLAYER;
    }

    public static interface IBound {
        @Nullable
        default public PlayerEntity getBoundPlayer(World world, ItemStack stack) {
            if (ItemNBTHelper.verifyExistance(stack, "BoundPlayer") && ItemNBTHelper.containsUUID(stack, "BoundUUID")) {
                UUID id = ItemNBTHelper.getUUID(stack, "BoundUUID", null);
                return world.func_217371_b(id);
            }
            return null;
        }
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<BindToPlayerRecipe> {
        public BindToPlayerRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new BindToPlayerRecipe(recipeId, "", ItemStack.field_190927_a, (NonNullList<Ingredient>)NonNullList.func_191196_a());
        }

        public BindToPlayerRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new BindToPlayerRecipe(recipeId, "", ItemStack.field_190927_a, (NonNullList<Ingredient>)NonNullList.func_191196_a());
        }

        public void write(PacketBuffer buffer, BindToPlayerRecipe recipe) {
        }
    }
}

