/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.crafting;

import com.google.gson.JsonObject;
import com.integral.enigmaticlegacy.api.items.ITaintable;
import com.integral.enigmaticlegacy.crafting.EnigmaticRecipeSerializers;
import com.integral.enigmaticlegacy.helpers.ItemNBTHelper;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CursedShapedRecipe
extends ShapedRecipe {
    public CursedShapedRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return EnigmaticRecipeSerializers.CURSED_SHAPED;
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        boolean isAllTainted = true;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack checkedItemStack = inv.func_70301_a(i);
            if (!(checkedItemStack.func_77973_b() instanceof ITaintable) || ((ITaintable)checkedItemStack.func_77973_b()).isTainted(checkedItemStack)) continue;
            isAllTainted = false;
        }
        return super.func_77569_a(inv, worldIn) && isAllTainted;
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        return super.func_77572_b(inv);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CursedShapedRecipe> {
        private NonNullList<Ingredient> handleTainted(NonNullList<Ingredient> ingredientList) {
            for (Ingredient ing : ingredientList) {
                for (ItemStack stack : ing.func_193365_a()) {
                    if (!(stack.func_77973_b() instanceof ITaintable)) continue;
                    ItemNBTHelper.setBoolean(stack, "isTainted", true);
                }
            }
            return ingredientList;
        }

        public CursedShapedRecipe read(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe recipe = (ShapedRecipe)field_222157_a.func_199425_a_(recipeId, json);
            return new CursedShapedRecipe(recipe.func_199560_c(), recipe.func_193358_e(), recipe.getRecipeWidth(), recipe.getRecipeHeight(), this.handleTainted((NonNullList<Ingredient>)recipe.func_192400_c()), recipe.func_77571_b());
        }

        public CursedShapedRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ShapedRecipe recipe = (ShapedRecipe)field_222157_a.func_199426_a_(recipeId, buffer);
            return new CursedShapedRecipe(recipe.func_199560_c(), recipe.func_193358_e(), recipe.getRecipeWidth(), recipe.getRecipeHeight(), this.handleTainted((NonNullList<Ingredient>)recipe.func_192400_c()), recipe.func_77571_b());
        }

        public void write(PacketBuffer buffer, CursedShapedRecipe recipe) {
            field_222157_a.func_199427_a_(buffer, (IRecipe)recipe);
        }
    }
}

