/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.entities;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.helpers.PotionHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class EnigmaticPotionEntity
extends ThrowableEntity
implements IRendersAsItem {
    @ObjectHolder(value="enigmaticlegacy:enigmatic_potion_entity")
    public static EntityType<EnigmaticPotionEntity> TYPE;
    private static final DataParameter<ItemStack> ITEM;

    public EnigmaticPotionEntity(EntityType<EnigmaticPotionEntity> type, World world) {
        super(type, world);
    }

    public EnigmaticPotionEntity(World world, LivingEntity entity) {
        super(TYPE, entity, world);
    }

    public EnigmaticPotionEntity(World world, double x, double y, double z) {
        super(TYPE, x, y, z, world);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    public ItemStack func_184543_l() {
        ItemStack itemstack = (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
        if (PotionHelper.isAdvancedPotion(itemstack)) {
            return itemstack;
        }
        return new ItemStack((IItemProvider)Items.field_185155_bH);
    }

    public void setItem(ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM, (Object)stack.func_77946_l());
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack itemstack = this.func_184543_l();
            List<EffectInstance> list = PotionHelper.getEffects(itemstack);
            int i = 2002;
            if (list != null && !list.isEmpty()) {
                if (this.isLingering()) {
                    this.makeAreaOfEffectCloud(itemstack, list);
                } else {
                    this.triggerSplash(list, result.func_216346_c() == RayTraceResult.Type.ENTITY ? ((EntityRayTraceResult)result).func_216348_a() : null);
                }
                for (EffectInstance instance : list) {
                    if (!instance.func_188419_a().func_76403_b()) continue;
                    i = 2007;
                }
            }
            this.field_70170_p.func_217379_c(i, new BlockPos((Vector3i)this.func_226268_ag_()), PotionHelper.getColor(itemstack));
            this.func_70106_y();
        }
    }

    private void triggerSplash(List<EffectInstance> p_213888_1_, @Nullable Entity p_213888_2_) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List list = this.field_70170_p.func_217357_a(LivingEntity.class, axisalignedbb);
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                double d0;
                if (!livingentity.func_184603_cC() || !((d0 = this.func_70068_e((Entity)livingentity)) < 16.0)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                if (livingentity == p_213888_2_) {
                    d1 = 1.0;
                }
                for (EffectInstance effectinstance : p_213888_1_) {
                    Effect effect = effectinstance.func_188419_a();
                    if (effect.func_76403_b()) {
                        effect.func_180793_a((Entity)this, this.func_234616_v_(), livingentity, effectinstance.func_76458_c(), d1);
                        continue;
                    }
                    int i = (int)(d1 * (double)effectinstance.func_76459_b() + 0.5);
                    if (i <= 20) continue;
                    livingentity.func_195064_c(new EffectInstance(effect, i, effectinstance.func_76458_c(), effectinstance.func_82720_e(), effectinstance.func_188418_e()));
                }
            }
        }
    }

    private void makeAreaOfEffectCloud(ItemStack stack, List<EffectInstance> list) {
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        areaeffectcloudentity.func_184481_a((LivingEntity)this.func_234616_v_());
        areaeffectcloudentity.func_184483_a(3.0f);
        areaeffectcloudentity.func_184495_b(-0.5f);
        areaeffectcloudentity.func_184485_d(10);
        areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
        for (EffectInstance effectInstance : list) {
            areaeffectcloudentity.func_184496_a(new EffectInstance(effectInstance.func_188419_a(), effectInstance.func_76459_b() / 4, effectInstance.func_76458_c(), effectInstance.func_82720_e(), effectInstance.func_188418_e()));
        }
        areaeffectcloudentity.func_184482_a(PotionHelper.getColor(stack));
        this.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
    }

    private boolean isLingering() {
        return this.func_184543_l().func_77973_b() == EnigmaticLegacy.ultimatePotionLingering;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Potion"));
        if (itemstack.func_190926_b()) {
            this.func_70106_y();
        } else {
            this.setItem(itemstack);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ItemStack itemstack = this.func_184543_l();
        if (!itemstack.func_190926_b()) {
            compound.func_218657_a("Potion", (INBT)itemstack.func_77955_b(new CompoundNBT()));
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    static {
        ITEM = EntityDataManager.func_187226_a(EnigmaticPotionEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    }
}

