/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.entities;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.integral.enigmaticlegacy.items.SoulCrystal;
import com.integral.enigmaticlegacy.items.StorageCrystal;
import com.integral.enigmaticlegacy.packets.clients.PacketHandleItemPickup;
import com.integral.enigmaticlegacy.packets.clients.PacketRecallParticles;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ObjectHolder;

public class PermanentItemEntity
extends Entity {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(PermanentItemEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private int age;
    private int pickupDelay;
    private int health = 5;
    private UUID thrower;
    private UUID owner;
    @ObjectHolder(value="enigmaticlegacy:permanent_item_entity")
    public static EntityType<PermanentItemEntity> TYPE;
    public float hoverStart = (float)(Math.random() * Math.PI * 2.0);

    public PermanentItemEntity(EntityType<PermanentItemEntity> type, World world) {
        super(type, world);
    }

    public PermanentItemEntity(World worldIn, double x, double y, double z) {
        this(TYPE, worldIn);
        this.func_70107_b(x, y <= 0.0 ? 1.0 : y, z);
        this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
        this.func_184224_h(true);
        this.func_189654_d(true);
    }

    public PermanentItemEntity(World worldIn, double x, double y, double z, ItemStack stack) {
        this(worldIn, x, y, z);
        this.setItem(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private PermanentItemEntity(PermanentItemEntity p_i231561_1_) {
        super(p_i231561_1_.func_200600_R(), p_i231561_1_.field_70170_p);
        this.setItem(p_i231561_1_.getItem().func_77946_l());
        this.func_82149_j(p_i231561_1_);
        this.age = p_i231561_1_.age;
        this.hoverStart = p_i231561_1_.hoverStart;
    }

    @OnlyIn(value=Dist.CLIENT)
    public PermanentItemEntity func_234273_t_() {
        return new PermanentItemEntity(this);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    public void func_70071_h_() {
        if (this.getItem().func_190926_b()) {
            this.func_70106_y();
        } else {
            ItemStack item;
            double d0;
            super.func_70071_h_();
            if (this.pickupDelay > 0 && this.pickupDelay != Short.MAX_VALUE) {
                --this.pickupDelay;
            }
            this.field_70169_q = this.func_226277_ct_();
            this.field_70167_r = this.func_226278_cu_();
            this.field_70166_s = this.func_226281_cx_();
            Vector3d vec3d = this.func_213322_ci();
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
            }
            if (this.field_70170_p.field_72995_K) {
                this.field_70145_X = false;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f), this.func_226281_cx_(), (Math.random() - 0.5) * 2.0, (Math.random() - 0.5) * 2.0, (Math.random() - 0.5) * 2.0);
            }
            ++this.age;
            if (!this.field_70170_p.field_72995_K && (d0 = this.func_213322_ci().func_178788_d(vec3d).func_189985_c()) > 0.01) {
                this.field_70160_al = true;
            }
            if ((item = this.getItem()).func_190926_b()) {
                this.func_70106_y();
            }
            this.field_242273_aw = Short.MAX_VALUE;
        }
    }

    public Entity changeDimension(ServerWorld server, ITeleporter teleporter) {
        return null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K || !this.func_70089_S()) {
            return false;
        }
        if (source.func_151517_h()) {
            EnigmaticLegacy.logger.warn("[WARN] Attacked permanent item entity with absolute DamageSource: " + source);
            this.func_70106_y();
            return true;
        }
        return false;
    }

    public void func_70106_y() {
        EnigmaticLegacy.logger.warn("[WARN] Removing Permanent Item Entity: " + (Object)((Object)this));
        super.func_70106_y();
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74777_a("Health", (short)this.health);
        compound.func_74777_a("Age", (short)this.age);
        compound.func_74777_a("PickupDelay", (short)this.pickupDelay);
        if (this.getThrowerId() != null) {
            compound.func_186854_a("Thrower", this.getThrowerId());
        }
        if (this.getOwnerId() != null) {
            compound.func_186854_a("Owner", this.getOwnerId());
        }
        if (!this.getItem().func_190926_b()) {
            compound.func_218657_a("Item", (INBT)this.getItem().func_77955_b(new CompoundNBT()));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        this.health = compound.func_74765_d("Health");
        this.age = compound.func_74765_d("Age");
        if (compound.func_74764_b("PickupDelay")) {
            this.pickupDelay = compound.func_74765_d("PickupDelay");
        }
        if (compound.func_74764_b("Owner")) {
            this.owner = compound.func_186857_a("Owner");
        }
        if (compound.func_74764_b("Thrower")) {
            this.thrower = compound.func_186857_a("Thrower");
        }
        CompoundNBT compoundnbt = compound.func_74775_l("Item");
        this.setItem(ItemStack.func_199557_a((CompoundNBT)compoundnbt));
        if (this.getItem().func_190926_b()) {
            this.func_70106_y();
        }
    }

    public void func_70100_b_(PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.pickupDelay > 0) {
                return;
            }
            ItemStack itemstack = this.getItem();
            Item item = itemstack.func_77973_b();
            int i = itemstack.func_190916_E();
            ItemStack copy = itemstack.func_77946_l();
            boolean isPlayerOwner = player.func_110124_au().equals(this.getOwnerId());
            boolean allowPickUp = false;
            if (item instanceof StorageCrystal && (isPlayerOwner || !EnigmaticLegacy.enigmaticAmulet.isVesselOwnerOnly())) {
                allowPickUp = true;
            } else if (item instanceof SoulCrystal && isPlayerOwner) {
                allowPickUp = true;
            }
            if (allowPickUp) {
                if (item instanceof StorageCrystal) {
                    ItemStack embeddedSoul;
                    CompoundNBT crystalNBT = ItemNBTHelper.getNBT(itemstack);
                    ItemStack itemStack = embeddedSoul = crystalNBT.func_74764_b("embeddedSoul") ? ItemStack.func_199557_a((CompoundNBT)crystalNBT.func_74775_l("embeddedSoul")) : null;
                    if (!isPlayerOwner && embeddedSoul != null) {
                        return;
                    }
                    EnigmaticLegacy.storageCrystal.retrieveDropsFromCrystal(itemstack, player, embeddedSoul);
                } else if (item instanceof SoulCrystal && !EnigmaticLegacy.soulCrystal.retrieveSoulFromCrystal(player, itemstack)) {
                    return;
                }
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f), this.func_226281_cx_(), 64.0, player.field_70170_p.func_234923_W_())), (Object)new PacketRecallParticles(this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f), this.func_226281_cx_(), 48, false));
                player.func_71001_a((Entity)this, i);
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 64.0, this.field_70170_p.func_234923_W_())), (Object)new PacketHandleItemPickup(player.func_145782_y(), this.func_145782_y()));
                EnigmaticLegacy.logger.info("Player " + player.func_146103_bH().getName() + " picking up: " + (Object)((Object)this));
                this.func_70106_y();
                itemstack.func_190920_e(0);
            } else if (this.pickupDelay == 0 && (this.owner == null || this.owner.equals(player.func_110124_au())) && (i <= 0 || player.field_71071_by.func_70441_a(itemstack))) {
                copy.func_190920_e(copy.func_190916_E() - this.getItem().func_190916_E());
                if (itemstack.func_190926_b()) {
                    player.func_71001_a((Entity)this, i);
                    EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 64.0, this.field_70170_p.func_234923_W_())), (Object)new PacketHandleItemPickup(player.func_145782_y(), this.func_145782_y()));
                    EnigmaticLegacy.logger.info("Player " + player.func_146103_bH().getName() + " picking up: " + (Object)((Object)this));
                    this.func_70106_y();
                    itemstack.func_190920_e(i);
                }
                player.func_71064_a(Stats.field_199089_f.func_199076_b((Object)item), i);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getItemHover(float partialTicks) {
        return ((float)this.getAge() + partialTicks) / 20.0f + this.hoverStart;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public ITextComponent func_200200_C_() {
        ITextComponent itextcomponent = this.func_200201_e();
        return itextcomponent != null ? itextcomponent : new TranslationTextComponent(this.getItem().func_77977_a());
    }

    public boolean func_70075_an() {
        return false;
    }

    public ItemStack getItem() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
    }

    public void setItem(ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM, (Object)stack);
    }

    @Nullable
    public UUID getOwnerId() {
        return this.owner;
    }

    public void setOwnerId(@Nullable UUID ownerId) {
        this.owner = ownerId;
    }

    @Nullable
    public UUID getThrowerId() {
        return this.thrower;
    }

    public void setThrowerId(@Nullable UUID throwerId) {
        this.thrower = throwerId;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAge() {
        return this.age;
    }

    public void setDefaultPickupDelay() {
        this.pickupDelay = 10;
    }

    public void setNoPickupDelay() {
        this.pickupDelay = 0;
    }

    public void setInfinitePickupDelay() {
        this.pickupDelay = Short.MAX_VALUE;
    }

    public void setPickupDelay(int ticks) {
        this.pickupDelay = ticks;
    }

    public boolean cannotPickup() {
        return this.pickupDelay > 0;
    }

    public void makeFakeItem() {
        this.setInfinitePickupDelay();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

