/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.handlers;

import com.integral.enigmaticlegacy.brewing.AbstractBrewingRecipe;
import com.integral.enigmaticlegacy.brewing.ComplexBrewingRecipe;
import com.integral.enigmaticlegacy.brewing.SpecialBrewingRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class AdvancedBrewingRecipeProcessor
implements IComponentProcessor {
    private AbstractBrewingRecipe recipe;

    public static List<IVariable> wrapStackList(ItemStack ... stackList) {
        ArrayList<IVariable> variableList = new ArrayList<IVariable>();
        for (ItemStack catalyst : stackList) {
            variableList.add(IVariable.from((Object)catalyst));
        }
        return variableList;
    }

    public static List<IVariable> wrapIngredientSet(Iterable<Ingredient> ingredientSet) {
        ArrayList<IVariable> variableList = new ArrayList<IVariable>();
        for (Ingredient ingredient : ingredientSet) {
            variableList.addAll(AdvancedBrewingRecipeProcessor.wrapStackList(ingredient.func_193365_a()));
        }
        return variableList;
    }

    public void setup(IVariableProvider variables) {
        ResourceLocation recipeId = new ResourceLocation(variables.get("recipe").asString());
        int index = variables.get("index").asNumber().intValue();
        this.recipe = AbstractBrewingRecipe.recipeMap.containsKey(recipeId) ? AbstractBrewingRecipe.recipeMap.get(recipeId).get(index) : AbstractBrewingRecipe.EMPTY_RECIPE;
    }

    public IVariable process(String key) {
        if (this.recipe instanceof SpecialBrewingRecipe) {
            SpecialBrewingRecipe special = (SpecialBrewingRecipe)this.recipe;
            if (key.startsWith("catalyst")) {
                return IVariable.wrapList(AdvancedBrewingRecipeProcessor.wrapStackList(special.getIngredient().func_193365_a()));
            }
            if (key.startsWith("input")) {
                return IVariable.wrapList(AdvancedBrewingRecipeProcessor.wrapStackList(special.getInput().func_193365_a()));
            }
            if (key.startsWith("output")) {
                return IVariable.from((Object)special.getOutput());
            }
        } else if (this.recipe instanceof ComplexBrewingRecipe) {
            ComplexBrewingRecipe complex = (ComplexBrewingRecipe)this.recipe;
            HashMap<Ingredient, Ingredient> processingMappings = complex.getProcessingMappings();
            if (key.startsWith("catalyst")) {
                return IVariable.wrapList(AdvancedBrewingRecipeProcessor.wrapIngredientSet(processingMappings.values()));
            }
            if (key.startsWith("input")) {
                return IVariable.wrapList(AdvancedBrewingRecipeProcessor.wrapIngredientSet(processingMappings.keySet()));
            }
            if (key.startsWith("output")) {
                return IVariable.from((Object)complex.getOutput());
            }
        }
        return null;
    }
}

