/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.handlers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.items.IItemCurio;
import com.integral.enigmaticlegacy.api.items.ItemizedCurioInstance;
import com.integral.enigmaticlegacy.config.OmniconfigHandler;
import com.integral.enigmaticlegacy.enchantments.CeaselessEnchantment;
import com.integral.enigmaticlegacy.entities.PermanentItemEntity;
import com.integral.enigmaticlegacy.gui.EnderChestInventoryButton;
import com.integral.enigmaticlegacy.handlers.LootFunctionRevelation;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.CrossbowHelper;
import com.integral.enigmaticlegacy.helpers.EnigmaticEnchantmentHelper;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.integral.enigmaticlegacy.helpers.PotionHelper;
import com.integral.enigmaticlegacy.items.AngelBlessing;
import com.integral.enigmaticlegacy.items.BerserkEmblem;
import com.integral.enigmaticlegacy.items.CursedRing;
import com.integral.enigmaticlegacy.items.CursedScroll;
import com.integral.enigmaticlegacy.items.EnigmaticAmulet;
import com.integral.enigmaticlegacy.items.EtheriumArmor;
import com.integral.enigmaticlegacy.items.EyeOfNebula;
import com.integral.enigmaticlegacy.items.ForbiddenAxe;
import com.integral.enigmaticlegacy.items.ForbiddenFruit;
import com.integral.enigmaticlegacy.items.HunterGuide;
import com.integral.enigmaticlegacy.items.MagmaHeart;
import com.integral.enigmaticlegacy.items.MiningCharm;
import com.integral.enigmaticlegacy.items.MonsterCharm;
import com.integral.enigmaticlegacy.items.OceanStone;
import com.integral.enigmaticlegacy.items.RevelationTome;
import com.integral.enigmaticlegacy.items.TheTwist;
import com.integral.enigmaticlegacy.items.VoidPearl;
import com.integral.enigmaticlegacy.items.generic.ItemSpellstoneCurio;
import com.integral.enigmaticlegacy.objects.CooldownMap;
import com.integral.enigmaticlegacy.objects.DamageSourceNemesisCurse;
import com.integral.enigmaticlegacy.objects.DimensionalPosition;
import com.integral.enigmaticlegacy.objects.Perhaps;
import com.integral.enigmaticlegacy.objects.RegisteredMeleeAttack;
import com.integral.enigmaticlegacy.objects.TransientPlayerData;
import com.integral.enigmaticlegacy.objects.Vector3;
import com.integral.enigmaticlegacy.packets.clients.PacketForceArrowRotations;
import com.integral.enigmaticlegacy.packets.clients.PacketPortalParticles;
import com.integral.enigmaticlegacy.packets.clients.PacketRecallParticles;
import com.integral.enigmaticlegacy.packets.clients.PacketSetEntryState;
import com.integral.enigmaticlegacy.packets.clients.PacketSlotUnlocked;
import com.integral.enigmaticlegacy.packets.clients.PacketWitherParticles;
import com.integral.enigmaticlegacy.packets.server.PacketAnvilField;
import com.integral.enigmaticlegacy.packets.server.PacketEnderRingKey;
import com.integral.enigmaticlegacy.triggers.BeheadingTrigger;
import com.integral.enigmaticlegacy.triggers.RevelationTomeBurntTrigger;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.AnvilScreen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinBruteEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ServerRecipeBook;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.functions.EnchantWithLevels;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.SetDamage;
import net.minecraft.loot.functions.SetNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.FoodStats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.enchanting.EnchantmentLevelSetEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Triple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.event.DropRulesEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.client.gui.CuriosScreen;

@Mod.EventBusSubscriber(modid="enigmaticlegacy")
public class EnigmaticEventHandler {
    private static final String NBT_KEY_FIRSTJOIN = "enigmaticlegacy.firstjoin";
    private static final String NBT_KEY_CURSEDGIFT = "enigmaticlegacy.cursedgift";
    private static final String NBT_KEY_ENABLESPELLSTONE = "enigmaticlegacy.spellstones_enabled";
    private static final String NBT_KEY_ENABLERING = "enigmaticlegacy.rings_enabled";
    private static final String NBT_KEY_ENABLESCROLL = "enigmaticlegacy.scrolls_enabled";
    public static final ResourceLocation FIREBAR_LOCATION = new ResourceLocation("enigmaticlegacy", "textures/gui/firebar.png");
    public static final ResourceLocation ICONS_LOCATION = new ResourceLocation("enigmaticlegacy", "textures/gui/generic_icons.png");
    public static final CooldownMap deferredToast = new CooldownMap();
    public static final List<IToast> scheduledToasts = new ArrayList<IToast>();
    public static final HashMap<LivingEntity, Float> knockbackThatBastard = new HashMap();
    public static final Random theySeeMeRollin = new Random();
    public static final Multimap<PlayerEntity, Item> postmortalPossession = ArrayListMultimap.create();
    public static final Multimap<PlayerEntity, GuardianEntity> angeredGuardians = ArrayListMultimap.create();

    @SubscribeEvent
    public void serverStarted(FMLServerStartedEvent event) {
        if (!EnigmaticLegacy.exceptionList.isEmpty()) {
            EnigmaticLegacy.logger.fatal("Some stupid mods once again attempted to add unnamed LootPools to loot tables!");
            for (Triple<LootTable, LootPool, Exception> triple : EnigmaticLegacy.exceptionList) {
                LootTable table = (LootTable)triple.getLeft();
                LootPool pool = (LootPool)triple.getMiddle();
                Exception ex = (Exception)triple.getRight();
                EnigmaticLegacy.logger.fatal("Loot table in question: " + table);
                EnigmaticLegacy.logger.fatal("LootPool in question: " + pool);
                EnigmaticLegacy.logger.fatal("Examine the stacktrace below to see what mod have caused this.");
                ex.printStackTrace();
            }
            if (OmniconfigHandler.crashOnUnnamedPool.getValue()) {
                throw new RuntimeException((Throwable)EnigmaticLegacy.exceptionList.get(0).getRight());
            }
        }
    }

    @SubscribeEvent
    public void onItemUse(LivingEntityUseItemEvent.Stop event) {
        if (event.getItem().func_77973_b() instanceof CrossbowItem && event.getEntityLiving() instanceof PlayerEntity) {
            CrossbowItem crossbow = (CrossbowItem)event.getItem().func_77973_b();
            ItemStack crossbowStack = event.getItem();
            if (!EnigmaticEnchantmentHelper.hasCustomCrossbowEnchantments(crossbowStack)) {
                return;
            }
            event.setCanceled(true);
            int i = crossbow.func_77626_a(crossbowStack) - event.getDuration();
            float f = CrossbowItem.func_220031_a((int)i, (ItemStack)crossbowStack);
            if (f >= 1.0f && !CrossbowItem.func_220012_d((ItemStack)crossbowStack) && CrossbowHelper.hasAmmo(event.getEntityLiving(), crossbowStack)) {
                CrossbowItem.func_220011_a((ItemStack)crossbowStack, (boolean)true);
                SoundCategory soundcategory = event.getEntityLiving() instanceof PlayerEntity ? SoundCategory.PLAYERS : SoundCategory.HOSTILE;
                event.getEntityLiving().field_70170_p.func_184148_a((PlayerEntity)null, event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_(), event.getEntityLiving().func_226281_cx_(), SoundEvents.field_219610_bB, soundcategory, 1.0f, 1.0f / (theySeeMeRollin.nextFloat() * 0.5f + 1.0f) + 0.2f);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClick(PlayerInteractEvent event) {
        if ((event instanceof PlayerInteractEvent.RightClickItem || event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.EntityInteract) && event.getItemStack().func_77973_b() instanceof CrossbowItem) {
            ItemStack itemstack = event.getItemStack();
            if (!EnigmaticEnchantmentHelper.hasCustomCrossbowEnchantments(itemstack)) {
                return;
            }
            event.setCanceled(true);
            if (CrossbowItem.func_220012_d((ItemStack)itemstack)) {
                CrossbowHelper.fireProjectiles(event.getWorld(), (LivingEntity)event.getPlayer(), event.getHand(), itemstack, CrossbowItem.func_220013_l((ItemStack)itemstack), 1.0f);
                CrossbowItem.func_220011_a((ItemStack)itemstack, (boolean)false);
                event.setCancellationResult(ActionResultType.CONSUME);
            } else if (!event.getPlayer().func_213356_f(itemstack).func_190926_b() || CeaselessEnchantment.allowNoArrow.getValue() && EnigmaticEnchantmentHelper.hasCeaselessEnchantment(itemstack)) {
                if (!CrossbowItem.func_220012_d((ItemStack)itemstack)) {
                    ((CrossbowItem)Items.field_222114_py).field_220034_c = false;
                    ((CrossbowItem)Items.field_222114_py).field_220035_d = false;
                    event.getPlayer().func_184598_c(event.getHand());
                }
                event.setCancellationResult(ActionResultType.CONSUME);
            } else {
                event.setCancellationResult(ActionResultType.FAIL);
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    @OnlyIn(value=Dist.CLIENT)
    public void onOverlayRender(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            TransientPlayerData data = TransientPlayerData.get((PlayerEntity)mc.field_71439_g);
            if (data.getFireImmunityTimer() <= 0 || !SuperpositionHandler.hasCurio((LivingEntity)mc.field_71439_g, EnigmaticLegacy.magmaHeart)) {
                return;
            }
            float partialTick = event.getPartialTicks();
            float barFiller = data.getFireImmunityFraction(partialTick);
            MatrixStack matrixStack = event.getMatrixStack();
            int x = event.getWindow().func_198107_o() / 2 - 91;
            int xCorrection = 0;
            int yCorrection = 0;
            boolean renderXP = false;
            if (!renderXP) {
                event.setCanceled(true);
            }
            mc.func_110434_K().func_110577_a(FIREBAR_LOCATION);
            int k = (int)(barFiller * 183.0f);
            int l = event.getWindow().func_198087_p() - 32 + 3;
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(x + xCorrection), (int)(l + yCorrection), (float)0.0f, (float)0.0f, (int)182, (int)5, (int)256, (int)256);
            if (k > 0) {
                AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(x + xCorrection), (int)(l + yCorrection), (float)0.0f, (float)5.0f, (int)k, (int)5, (int)256, (int)256);
            }
            String title = I18n.func_135052_a((String)"gui.enigmaticlegacy.blazing_core_bar_title", (Object[])new Object[0]);
            int i1 = (event.getWindow().func_198107_o() - mc.field_71466_p.func_78256_a(title)) / 2;
            int j1 = event.getWindow().func_198087_p() - 31 - 4;
            int stringXCorrection = 0;
            int stringYCorrection = 0;
            try {
                stringXCorrection = Integer.parseInt(I18n.func_135052_a((String)"gui.enigmaticlegacy.blazing_core_bar_offsetX", (Object[])new Object[0]));
                stringYCorrection = Integer.parseInt(I18n.func_135052_a((String)"gui.enigmaticlegacy.blazing_core_bar_offsetY", (Object[])new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int boundaryColor = 0x590000;
            mc.field_71466_p.func_238421_b_(matrixStack, title, (float)((i1 += xCorrection + stringXCorrection) + 1), (float)(j1 += yCorrection + stringYCorrection), boundaryColor);
            mc.field_71466_p.func_238421_b_(matrixStack, title, (float)(i1 - 1), (float)j1, boundaryColor);
            mc.field_71466_p.func_238421_b_(matrixStack, title, (float)i1, (float)(j1 + 1), boundaryColor);
            mc.field_71466_p.func_238421_b_(matrixStack, title, (float)i1, (float)(j1 - 1), boundaryColor);
            mc.field_71466_p.func_238421_b_(matrixStack, title, (float)i1, (float)j1, 16770638);
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.AIR) {
            if ((SuperpositionHandler.hasCurio((LivingEntity)mc.field_71439_g, EnigmaticLegacy.oceanStone) || SuperpositionHandler.hasCurio((LivingEntity)mc.field_71439_g, EnigmaticLegacy.voidPearl)) && OceanStone.preventOxygenBarRender.getValue()) {
                event.setCanceled(true);
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.FOOD && EnigmaticLegacy.forbiddenFruit.haveConsumedFruit((PlayerEntity)mc.field_71439_g)) {
            if (!ForbiddenFruit.renderHungerBar.getValue()) {
                event.setCanceled(true);
                return;
            }
            if (!ForbiddenFruit.replaceHungerBar.getValue()) {
                return;
            }
            event.setCanceled(true);
            mc.func_110434_K().func_110577_a(ICONS_LOCATION);
            int width = event.getWindow().func_198107_o();
            int height = event.getWindow().func_198087_p();
            ClientPlayerEntity player = mc.field_71439_g;
            RenderSystem.enableBlend();
            int left = width / 2 + 91;
            int top = height - ForgeIngameGui.right_height;
            ForgeIngameGui.right_height += 10;
            boolean unused = false;
            FoodStats stats = mc.field_71439_g.func_71024_bL();
            int level = stats.func_75116_a();
            int barPx = 8;
            int barNum = 10;
            for (int i = 0; i < barNum; ++i) {
                int idx = i * 2 + 1;
                int x = left - i * barPx - 9;
                int y = top;
                int icon = 16;
                boolean background = false;
                if (player.func_71024_bL().func_75115_e() <= 0.0f && mc.field_71456_v.func_73834_c() % (level * 3 + 1) == 0) {
                    y = top + (theySeeMeRollin.nextInt(3) - 1);
                }
                mc.field_71456_v.func_238474_b_(event.getMatrixStack(), x, y, 0, 0, 9, 9);
            }
            RenderSystem.disableBlend();
            mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        }
    }

    @SubscribeEvent
    public void onEnchantmentLevelSet(EnchantmentLevelSetEvent event) {
        BlockPos where = event.getPos();
        boolean shouldBoost = false;
        int radius = 16;
        List players = event.getWorld().func_217357_a(PlayerEntity.class, new AxisAlignedBB(where.func_177982_a(-radius, -radius, -radius), where.func_177982_a(radius, radius, radius)));
        for (PlayerEntity player : players) {
            if (!SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.cursedRing)) continue;
            shouldBoost = true;
        }
        if (shouldBoost) {
            event.setLevel(event.getLevel() + CursedRing.enchantingBonus.getValue());
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onItemBurnt(FurnaceFuelBurnTimeEvent event) {
        ServerPlayerEntity player;
        if (event.getItemStack() != null && event.getItemStack().func_77973_b() instanceof RevelationTome && ServerLifecycleHooks.getCurrentServer() != null && ItemNBTHelper.verifyExistance(event.getItemStack(), "lastHolder") && (player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(ItemNBTHelper.getUUID(event.getItemStack(), "lastHolder", MathHelper.func_188210_a()))) != null) {
            RevelationTomeBurntTrigger.INSTANCE.trigger(player);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onInventoryGuiInit(GuiScreenEvent.InitGuiEvent.Post evt) {
        Screen screen = evt.getGui();
        if (screen instanceof InventoryScreen || screen instanceof CreativeScreen || screen instanceof CuriosScreen) {
            ContainerScreen gui = (ContainerScreen)screen;
            boolean isCreative = screen instanceof CreativeScreen;
            Tuple<Integer, Integer> offsets = EnderChestInventoryButton.getOffsets(isCreative);
            int x = (Integer)offsets.func_76341_a();
            int y = (Integer)offsets.func_76340_b();
            evt.addWidget((Widget)new EnderChestInventoryButton(gui, gui.getGuiLeft() + x, gui.field_230709_l_ / 2 - 22 + y, 20, 18, 0, 0, 19, new ResourceLocation("enigmaticlegacy:textures/gui/ender_chest_button.png"), button -> EnigmaticLegacy.packetInstance.send(PacketDistributor.SERVER.noArg(), (Object)new PacketEnderRingKey(true))));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onFogRender(EntityViewRenderEvent.FogDensity event) {
        if (event.getInfo().func_216771_k().func_206884_a((ITag)FluidTags.field_206960_b) && SuperpositionHandler.hasCurio((LivingEntity)Minecraft.func_71410_x().field_71439_g, EnigmaticLegacy.magmaHeart)) {
            event.setCanceled(true);
            event.setDensity((float)MagmaHeart.lavafogDensity.getValue());
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onEntityTick(TickEvent.ClientTickEvent event) {
        TickEvent.Phase cfr_ignored_0 = event.phase;
        if (event.phase == TickEvent.Phase.END) {
            try {
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                if (player == null && OmniconfigWrapper.onRemoteServer) {
                    for (OmniconfigWrapper wrapper : OmniconfigWrapper.wrapperRegistry.values()) {
                        EnigmaticLegacy.logger.info("Dismissing values of " + wrapper.config.getConfigFile().getName() + " in favor of local config...");
                        for (Omniconfig.GenericParameter param : wrapper.retrieveInvocationList()) {
                            if (!param.isSynchronized()) continue;
                            String oldValue = param.valueToString();
                            param.invoke(wrapper.config);
                            EnigmaticLegacy.logger.info("Value of '" + param.getId() + "' was restored to '" + param.valueToString() + "'; former server-forced value: " + oldValue);
                        }
                    }
                    OmniconfigWrapper.onRemoteServer = false;
                }
                deferredToast.tick((LivingEntity)player);
                if (deferredToast.getCooldown((LivingEntity)player) == 1) {
                    Minecraft.func_71410_x().func_193033_an().func_192988_a(scheduledToasts.get(0));
                    scheduledToasts.remove(0);
                    if (scheduledToasts.size() > 0) {
                        deferredToast.put(player, 5);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLooting(LootingLevelEvent event) {
        if (event.getDamageSource() != null && event.getDamageSource().func_76346_g() instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)event.getDamageSource().func_76346_g();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void miningStuff(PlayerEvent.BreakSpeed event) {
        float originalSpeed;
        float correctedSpeed = originalSpeed = event.getOriginalSpeed();
        float miningBoost = 1.0f;
        if (SuperpositionHandler.hasCurio((LivingEntity)event.getPlayer(), EnigmaticLegacy.miningCharm)) {
            miningBoost += MiningCharm.breakSpeedBonus.getValue().asModifier();
        }
        if (SuperpositionHandler.hasCurio((LivingEntity)event.getPlayer(), EnigmaticLegacy.cursedScroll)) {
            miningBoost += CursedScroll.miningBoost.getValue().asModifier() * (float)SuperpositionHandler.getCurseAmount(event.getPlayer());
        }
        if (EnigmaticLegacy.enigmaticAmulet.ifHasColor(event.getPlayer(), EnigmaticAmulet.AmuletColor.GREEN)) {
            miningBoost += 0.25f;
        }
        if (!event.getPlayer().func_233570_aj_() && (SuperpositionHandler.hasCurio((LivingEntity)event.getPlayer(), EnigmaticLegacy.heavenScroll) || SuperpositionHandler.hasCurio((LivingEntity)event.getPlayer(), EnigmaticLegacy.fabulousScroll) || SuperpositionHandler.hasCurio((LivingEntity)event.getPlayer(), EnigmaticLegacy.enigmaticItem))) {
            correctedSpeed *= 5.0f;
        }
        if (event.getPlayer().func_208600_a((ITag)FluidTags.field_206959_a) && !EnchantmentHelper.func_185287_i((LivingEntity)event.getPlayer()) && SuperpositionHandler.hasCurio((LivingEntity)event.getPlayer(), EnigmaticLegacy.oceanStone)) {
            correctedSpeed *= 5.0f;
        }
        correctedSpeed *= miningBoost;
        event.setNewSpeed(event.getNewSpeed() + (correctedSpeed -= event.getOriginalSpeed()));
    }

    @SubscribeEvent
    public void onHarvestCheck(PlayerEvent.HarvestCheck event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity) || event.canHarvest() || SuperpositionHandler.hasCurio(event.getEntityLiving(), EnigmaticLegacy.cursedRing)) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onLivingKnockback(LivingKnockBackEvent event) {
        if (knockbackThatBastard.containsKey(event.getEntityLiving())) {
            float knockbackPower = knockbackThatBastard.get(event.getEntityLiving()).floatValue();
            event.setStrength(event.getStrength() * knockbackPower);
            knockbackThatBastard.remove(event.getEntityLiving());
        }
        if (event.getEntityLiving() instanceof PlayerEntity && SuperpositionHandler.hasCurio(event.getEntityLiving(), EnigmaticLegacy.cursedRing)) {
            event.setStrength(event.getStrength() * CursedRing.knockbackDebuff.getValue().asModifier());
        }
    }

    @SubscribeEvent
    public void onPlayerTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (Float.isNaN(player.func_110143_aJ())) {
                player.func_70606_j(0.0f);
            }
            if (Float.isNaN(player.func_110139_bj())) {
                player.func_110149_m(0.0f);
            }
            if (EnigmaticLegacy.forbiddenFruit.haveConsumedFruit(player)) {
                FoodStats foodStats = player.func_71024_bL();
                foodStats.func_75114_a(20);
                foodStats.field_75125_b = 0.0f;
                if (player.func_70644_a(Effects.field_76438_s)) {
                    player.func_195063_d(Effects.field_76438_s);
                }
            }
            if (player.func_70608_bn() && player.func_71060_bI() > 90 && SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.cursedRing)) {
                player.field_71076_b = 90;
            }
            if (player.func_70027_ad() && SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.cursedRing)) {
                player.func_241209_g_(player.func_223314_ad() + 2);
            }
            if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.magmaHeart) && !player.func_70651_bq().isEmpty()) {
                ArrayList effects = new ArrayList();
                effects.addAll(player.func_70651_bq());
                for (EffectInstance effect : effects) {
                    if (effect.func_188419_a().equals(Effects.field_76426_n)) {
                        if (player.field_70173_aa % 2 != 0 || effect.field_76460_b <= 0) continue;
                        ++effect.field_76460_b;
                        continue;
                    }
                    effect.func_76455_a((LivingEntity)player, () -> {});
                }
            }
            if (player instanceof ServerPlayerEntity) {
                if (SuperpositionHandler.hasSpellstoneCooldown(player)) {
                    SuperpositionHandler.tickSpellstoneCooldown(player, 1);
                }
                TransientPlayerData data = TransientPlayerData.get(player);
                data.setFireImmunityTimer(data.getFireImmunityTimer() - (player.func_70027_ad() ? 100 : 200));
                if (data.needsSync) {
                    data.syncToPlayer();
                    data.needsSync = false;
                }
                EnigmaticLegacy.enigmaticItem.handleEnigmaticFlight(player);
            }
        }
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack stack = (ItemStack)evt.getObject();
        if (stack.func_77973_b() instanceof IItemCurio) {
            final ItemizedCurioInstance itemizedCurio = new ItemizedCurioInstance((IItemCurio)stack.func_77973_b(), stack);
            evt.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){
                LazyOptional<ICurio> curio = LazyOptional.of(() -> itemizedCurio);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, this.curio);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onConfirmedDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.enigmaticAmulet) || SuperpositionHandler.hasItem((PlayerEntity)player, EnigmaticLegacy.enigmaticAmulet)) {
                postmortalPossession.put((Object)player, (Object)EnigmaticLegacy.enigmaticAmulet);
            }
            if (SuperpositionHandler.hasItem((PlayerEntity)player, EnigmaticLegacy.cursedStone)) {
                postmortalPossession.put((Object)player, (Object)EnigmaticLegacy.cursedStone);
                for (List list : player.field_71071_by.field_184440_g) {
                    for (ItemStack itemstack : list) {
                        if (itemstack.func_190926_b() || itemstack.func_77973_b() != EnigmaticLegacy.cursedStone) continue;
                        itemstack.func_190920_e(0);
                    }
                }
            }
            if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.escapeScroll)) {
                postmortalPossession.put((Object)player, (Object)EnigmaticLegacy.escapeScroll);
                if (!player.field_70170_p.field_72995_K) {
                    ItemStack tomeStack = SuperpositionHandler.getCurioStack((LivingEntity)player, EnigmaticLegacy.escapeScroll);
                    PermanentItemEntity droppedTomeStack = new PermanentItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + (double)(player.func_213302_cg() / 2.0f), player.func_226281_cx_(), tomeStack.func_77946_l());
                    droppedTomeStack.setPickupDelay(10);
                    player.field_70170_p.func_217376_c((Entity)droppedTomeStack);
                    tomeStack.func_190918_g(1);
                }
            }
        }
    }

    @SubscribeEvent
    public void onCurioDrops(DropRulesEvent event) {
        BlockPos deathPos;
        ServerPlayerEntity player;
        if (event.getEntityLiving() instanceof ServerPlayerEntity && this.hadUnholyStone((PlayerEntity)(player = (ServerPlayerEntity)event.getEntityLiving())) && player.field_70170_p.func_234923_W_() == EnigmaticLegacy.proxy.getNetherKey() && this.isThereLava(player.field_70170_p, deathPos = player.func_233580_cy_())) {
            BlockPos nextAbove;
            BlockPos surfacePos = deathPos;
            while (this.isThereLava(player.field_70170_p, nextAbove = surfacePos.func_177982_a(0, 1, 0))) {
                surfacePos = nextAbove;
            }
            boolean confirmLavaPool = true;
            for (int i = -3; i <= 2; ++i) {
                int fi = i;
                boolean checkArea = BlockPos.func_218281_b((BlockPos)surfacePos.func_177982_a(-3, i, -3), (BlockPos)surfacePos.func_177982_a(3, i, 3)).map(blockPos -> {
                    if (fi <= 0) {
                        return this.isThereLava(player.field_70170_p, (BlockPos)blockPos);
                    }
                    return player.field_70170_p.func_175623_d(blockPos) || this.isThereLava(player.field_70170_p, (BlockPos)blockPos);
                }).reduce((prevResult, nextElement) -> prevResult != false && nextElement != false).orElse(false);
                confirmLavaPool = confirmLavaPool && checkArea;
            }
            if (confirmLavaPool) {
                event.addOverride(stack -> stack != null && stack.func_77973_b() == EnigmaticLegacy.cursedRing, ICurio.DropRule.DESTROY);
                EnigmaticLegacy.soulCrystal.setLostCrystals((PlayerEntity)player, EnigmaticLegacy.soulCrystal.getLostCrystals((PlayerEntity)player) + 1);
                SuperpositionHandler.destroyCurio((LivingEntity)player, EnigmaticLegacy.cursedRing);
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187849_gA, SoundCategory.PLAYERS, 1.0f, 0.5f);
            }
        }
    }

    private boolean isThereLava(World world, BlockPos pos) {
        FluidState fluidState = world.func_180495_p(pos).func_204520_s();
        return fluidState != null && fluidState.func_206884_a((ITag)FluidTags.field_206960_b) && fluidState.func_206889_d();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity & !event.getEntityLiving().field_70170_p.field_72995_K) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.enigmaticItem) || player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)EnigmaticLegacy.enigmaticItem)) || event.getSource() instanceof DamageSourceNemesisCurse) {
                event.setCanceled(true);
                player.func_70606_j(1.0f);
            } else if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.voidPearl) && Math.random() <= VoidPearl.undeadProbability.getValue().asMultiplier(false)) {
                event.setCanceled(true);
                player.func_70606_j(1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onLivingHeal(LivingHealEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (event.getAmount() <= 1.0f && EnigmaticLegacy.forbiddenFruit.haveConsumedFruit(player)) {
                event.setAmount(event.getAmount() * ForbiddenFruit.regenerationSubtraction.getValue().asModifierInverted());
            }
            if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.cursedScroll)) {
                event.setAmount(event.getAmount() + event.getAmount() * (CursedScroll.regenBoost.getValue().asModifier() * (float)SuperpositionHandler.getCurseAmount(player)));
            }
        }
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        EntityRayTraceResult result;
        if (event.getRayTraceResult() instanceof EntityRayTraceResult && (result = (EntityRayTraceResult)event.getRayTraceResult()).func_216348_a() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)result.func_216348_a();
            if (!player.field_70170_p.field_72995_K) {
                boolean trigger = false;
                double chance = 0.0;
                if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.angelBlessing)) {
                    trigger = true;
                    chance += (double)AngelBlessing.deflectChance.getValue().asModifier(false);
                }
                if (EnigmaticLegacy.enigmaticAmulet.ifHasColor(player, EnigmaticAmulet.AmuletColor.VIOLET)) {
                    trigger = true;
                    chance += 0.15;
                }
                if (trigger && Math.random() <= chance) {
                    event.setCanceled(true);
                    Entity arrow = event.getEntity();
                    arrow.func_213317_d(arrow.func_213322_ci().func_186678_a(-1.0));
                    arrow.field_70126_B = arrow.field_70177_z + 180.0f;
                    arrow.field_70177_z += 180.0f;
                    if (arrow instanceof AbstractArrowEntity && !(arrow instanceof TridentEntity)) {
                        ((AbstractArrowEntity)arrow).func_212361_a((Entity)player);
                    } else if (arrow instanceof DamagingProjectileEntity) {
                        ((DamagingProjectileEntity)arrow).func_212361_a((Entity)player);
                        ((DamagingProjectileEntity)arrow).field_70232_b = -((DamagingProjectileEntity)arrow).field_70232_b;
                        ((DamagingProjectileEntity)arrow).field_70233_c = -((DamagingProjectileEntity)arrow).field_70233_c;
                        ((DamagingProjectileEntity)arrow).field_70230_d = -((DamagingProjectileEntity)arrow).field_70230_d;
                    }
                    EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 64.0, player.field_70170_p.func_234923_W_())), (Object)new PacketForceArrowRotations(arrow.func_145782_y(), arrow.field_70177_z, arrow.field_70125_A, arrow.func_213322_ci().field_72450_a, arrow.func_213322_ci().field_72448_b, arrow.func_213322_ci().field_72449_c, arrow.func_226277_ct_(), arrow.func_226278_cu_(), arrow.func_226281_cx_()));
                    player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), EnigmaticLegacy.DEFLECT, SoundCategory.PLAYERS, 1.0f, 0.95f + (float)(Math.random() * 0.1));
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        PlayerEntity player;
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityLiving() instanceof PlayerEntity) {
            TransientPlayerData data;
            List<ItemStack> advancedCurios;
            player = (PlayerEntity)event.getEntityLiving();
            if ((event.getSource().func_76364_f() instanceof DamagingProjectileEntity || event.getSource().func_76364_f() instanceof AbstractArrowEntity) && EnigmaticLegacy.etheriumChestplate.hasShield(player)) {
                event.setCanceled(true);
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), EnigmaticLegacy.SHIELD_TRIGGER, SoundCategory.PLAYERS, 1.0f, 0.9f + (float)(Math.random() * 0.1));
            }
            if (event.getSource().field_76373_n == DamageSource.field_76379_h.field_76373_n && EnigmaticLegacy.enigmaticAmulet.ifHasColor(player, EnigmaticAmulet.AmuletColor.MAGENTA) && event.getAmount() <= 2.0f) {
                event.setCanceled(true);
            }
            if ((advancedCurios = SuperpositionHandler.getAdvancedCurios((LivingEntity)player)).size() > 0) {
                for (ItemStack advancedCurioStack : advancedCurios) {
                    ItemSpellstoneCurio advancedCurio = (ItemSpellstoneCurio)advancedCurioStack.func_77973_b();
                    if (!advancedCurio.immunityList.contains(event.getSource().field_76373_n)) continue;
                    event.setCanceled(true);
                }
            }
            if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.eyeOfNebula) && !event.isCanceled() && EyeOfNebula.dodgeProbability.getValue().roll() && player.field_70172_ad <= 10 && event.getSource().func_76346_g() instanceof LivingEntity) {
                for (int counter = 0; counter <= 32 && !SuperpositionHandler.validTeleportRandomly((Entity)player, player.field_70170_p, (int)EyeOfNebula.dodgeRange.getValue()); ++counter) {
                }
                player.field_70172_ad = 20;
                event.setCanceled(true);
            }
            if (!player.field_71075_bZ.field_75102_a && player.func_70660_b(Effects.field_76426_n) == null && SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.magmaHeart) && !event.isCanceled() && event.getSource().field_76373_n.equals(DamageSource.field_76371_c.field_76373_n) && (data = TransientPlayerData.get(player)).getFireImmunityTimer() < data.getFireImmunityTimerCap()) {
                if (data.getFireImmunityTimer() < data.getFireImmunityTimerCap() - data.getFireDiff()) {
                    event.setCanceled(true);
                }
                if (data.getFireImmunityTimer() == 0 && !player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187659_cY, SoundCategory.PLAYERS, 1.0f, 0.5f + theySeeMeRollin.nextFloat() * 0.5f);
                    EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 32.0, player.field_70170_p.func_234923_W_())), (Object)new PacketWitherParticles(player.func_226277_ct_(), player.func_226283_e_(0.25), player.func_226281_cx_(), 8, false, 1));
                }
                data.setFireImmunityTimer(data.getFireImmunityTimer() + 200);
            }
        } else if (event.getSource().func_76364_f() instanceof PlayerEntity) {
            player = (PlayerEntity)event.getSource().func_76364_f();
            if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == EnigmaticLegacy.extradimensionalEye && ItemNBTHelper.verifyExistance(player.func_184614_ca(), "BoundDimension") && ItemNBTHelper.getString(player.func_184614_ca(), "BoundDimension", "minecraft:overworld").equals(event.getEntityLiving().field_70170_p.func_234923_W_().func_240901_a_().toString())) {
                event.setCanceled(true);
                ItemStack stack = player.func_184614_ca();
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_(), event.getEntityLiving().func_226281_cx_(), 128.0, event.getEntityLiving().field_70170_p.func_234923_W_())), (Object)new PacketPortalParticles(event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_() + (double)(event.getEntityLiving().func_213302_cg() / 2.0f), event.getEntityLiving().func_226281_cx_(), 96, 1.5, false));
                event.getEntityLiving().field_70170_p.func_184133_a(null, event.getEntityLiving().func_233580_cy_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                event.getEntityLiving().func_70634_a(ItemNBTHelper.getDouble(stack, "BoundX", 0.0), ItemNBTHelper.getDouble(stack, "BoundY", 0.0), ItemNBTHelper.getDouble(stack, "BoundZ", 0.0));
                event.getEntityLiving().field_70170_p.func_184133_a(null, event.getEntityLiving().func_233580_cy_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_(), event.getEntityLiving().func_226281_cx_(), 128.0, event.getEntityLiving().field_70170_p.func_234923_W_())), (Object)new PacketRecallParticles(event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_() + (double)(event.getEntityLiving().func_213302_cg() / 2.0f), event.getEntityLiving().func_226281_cx_(), 48, false));
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
            }
            if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == EnigmaticLegacy.theTwist && SuperpositionHandler.isTheCursedOne(player)) {
                float knockbackPower = TheTwist.knockbackBonus.getValue().asModifier(true);
                knockbackThatBastard.put(event.getEntityLiving(), Float.valueOf(event.getEntityLiving() instanceof PhantomEntity ? knockbackPower * 1.5f : knockbackPower));
            }
        }
        if (event.getEntityLiving() instanceof AnimalEntity && event.getSource().func_76346_g() instanceof PlayerEntity && SuperpositionHandler.hasItem(player = (PlayerEntity)event.getSource().func_76346_g(), EnigmaticLegacy.animalGuide)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityDamaged(LivingDamageEvent event) {
        PlayerEntity player;
        if (event.getSource().func_76364_f() instanceof PlayerEntity && !event.getSource().func_76364_f().field_70170_p.field_72995_K && EnigmaticLegacy.enigmaticAmulet.ifHasColor(player = (PlayerEntity)event.getSource().func_76364_f(), EnigmaticAmulet.AmuletColor.BLACK)) {
            player.func_70691_i(event.getAmount() * 0.1f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityAttacked(AttackEntityEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            RegisteredMeleeAttack.registerAttack(event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        LivingEntity owner;
        TameableEntity pet;
        PlayerEntity player;
        Object immediateSource;
        if (event.getSource().func_76346_g() instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
            immediateSource = event.getSource().func_76364_f();
            if (immediateSource instanceof TridentEntity || immediateSource instanceof LivingEntity) {
                ItemStack mainhandStack = ItemStack.field_190927_a;
                if (immediateSource instanceof TridentEntity) {
                    if (((TridentEntity)immediateSource).field_203054_h != null) {
                        mainhandStack = ((TridentEntity)immediateSource).field_203054_h;
                    }
                } else if (((LivingEntity)immediateSource).func_184614_ca() != null) {
                    mainhandStack = ((LivingEntity)immediateSource).func_184614_ca();
                }
                int torrentLevel = 0;
                int wrathLevel = 0;
                torrentLevel = EnchantmentHelper.func_77506_a((Enchantment)EnigmaticLegacy.torrentEnchantment, (ItemStack)mainhandStack);
                if (torrentLevel > 0) {
                    event.setAmount(event.getAmount() + EnigmaticLegacy.torrentEnchantment.bonusDamageByCreature(attacker, event.getEntityLiving(), torrentLevel));
                }
                if ((wrathLevel = EnchantmentHelper.func_77506_a((Enchantment)EnigmaticLegacy.wrathEnchantment, (ItemStack)mainhandStack)) > 0) {
                    event.setAmount(event.getAmount() + EnigmaticLegacy.wrathEnchantment.bonusDamageByCreature(attacker, event.getEntityLiving(), wrathLevel));
                }
            }
        }
        if (event.getSource().func_76364_f() instanceof AbstractArrowEntity) {
            AbstractArrowEntity arrow = (AbstractArrowEntity)event.getSource().func_76364_f();
            for (String tag : arrow.func_184216_O()) {
                if (!tag.startsWith("enigmaticlegacy:sharpshot:")) continue;
                event.setAmount((float)(6 + 3 * Integer.parseInt(tag.replace("enigmaticlegacy:sharpshot:", ""))));
                break;
            }
        } else if (event.getSource().func_76364_f() instanceof PlayerEntity) {
            player = (PlayerEntity)event.getSource().func_76364_f();
            if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.voidPearl)) {
                event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_82731_v, VoidPearl.witheringTime.getValue(), VoidPearl.witheringLevel.getValue(), false, true));
            }
            if (player.func_184614_ca() != null) {
                ItemStack mainhandStack = player.func_184614_ca();
                if (mainhandStack.func_77973_b() == EnigmaticLegacy.theTwist) {
                    if (SuperpositionHandler.isTheCursedOne(player)) {
                        if (!event.getEntityLiving().func_184222_aU() || event.getEntityLiving() instanceof PlayerEntity) {
                            event.setAmount(event.getAmount() * TheTwist.bossDamageBonus.getValue().asModifier(true));
                        }
                    } else {
                        event.setCanceled(true);
                    }
                }
                int slayerLevel = 0;
                slayerLevel = EnchantmentHelper.func_77506_a((Enchantment)EnigmaticLegacy.slayerEnchantment, (ItemStack)mainhandStack);
                if (slayerLevel > 0) {
                    event.setAmount(event.getAmount() + EnigmaticLegacy.slayerEnchantment.bonusDamageByCreature((LivingEntity)player, event.getEntityLiving(), slayerLevel));
                    if (event.getEntityLiving() instanceof MonsterEntity) {
                        int i = 20 + player.func_70681_au().nextInt(10 * slayerLevel);
                        event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76421_d, i, 3));
                    }
                }
                if (EnigmaticEnchantmentHelper.hasNemesisCurseEnchantment(mainhandStack)) {
                    float supposedDamage = event.getAmount() * 0.35f;
                    player.func_70097_a((DamageSource)new DamageSourceNemesisCurse((Entity)event.getEntityLiving()), supposedDamage);
                }
            }
        }
        if (event.getEntityLiving() instanceof PlayerEntity) {
            LivingEntity attacker;
            player = (PlayerEntity)event.getEntityLiving();
            List<ItemStack> advancedCurios = SuperpositionHandler.getAdvancedCurios((LivingEntity)player);
            if (advancedCurios.size() > 0) {
                for (ItemStack advancedCurioStack : advancedCurios) {
                    CreatureEntity trueSource;
                    ItemSpellstoneCurio advancedCurio = (ItemSpellstoneCurio)advancedCurioStack.func_77973_b();
                    CreatureEntity creatureEntity = trueSource = event.getSource().func_76346_g() instanceof CreatureEntity ? (CreatureEntity)event.getSource().func_76346_g() : null;
                    if (event.getSource().field_76373_n.startsWith("explosion") && advancedCurio == EnigmaticLegacy.golemHeart && SuperpositionHandler.hasAnyArmor((LivingEntity)player)) continue;
                    if (advancedCurio == EnigmaticLegacy.magmaHeart && trueSource != null && (trueSource.func_70668_bt() == CreatureAttribute.field_203100_e || trueSource instanceof DrownedEntity)) {
                        event.setAmount(event.getAmount() * 2.0f);
                    } else if (advancedCurio == EnigmaticLegacy.eyeOfNebula && player.func_70090_H()) {
                        event.setAmount(event.getAmount() * 2.0f);
                    } else if (advancedCurio == EnigmaticLegacy.oceanStone && trueSource != null && (trueSource.func_70668_bt() == CreatureAttribute.field_203100_e || trueSource instanceof DrownedEntity)) {
                        event.setAmount(event.getAmount() * OceanStone.underwaterCreaturesResistance.getValue().asModifierInverted());
                    }
                    if (!advancedCurio.resistanceList.containsKey(event.getSource().field_76373_n)) continue;
                    event.setAmount(event.getAmount() * advancedCurio.resistanceList.get(event.getSource().field_76373_n).get().floatValue());
                }
            }
            if (event.getSource().field_76373_n == DamageSource.field_76379_h.field_76373_n && EnigmaticLegacy.enigmaticAmulet.ifHasColor(player, EnigmaticAmulet.AmuletColor.MAGENTA)) {
                event.setAmount(event.getAmount() - 2.0f);
            }
            if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.magmaHeart) && event.getSource().func_76346_g() instanceof LivingEntity && EnigmaticLegacy.magmaHeart.nemesisList.contains(event.getSource().field_76373_n) && !(attacker = (LivingEntity)event.getSource().func_76346_g()).func_230279_az_()) {
                attacker.func_70097_a((DamageSource)new EntityDamageSource(DamageSource.field_76370_b.field_76373_n, (Entity)player), (float)MagmaHeart.damageFeedback.getValue());
                attacker.func_70015_d(MagmaHeart.ignitionFeedback.getValue());
            }
            if (EnigmaticLegacy.etheriumChestplate.hasShield(player)) {
                if (event.getSource().func_76364_f() instanceof LivingEntity) {
                    attacker = (LivingEntity)event.getSource().func_76346_g();
                    Vector3 vec = Vector3.fromEntityCenter((Entity)player).subtract(Vector3.fromEntityCenter(event.getSource().func_76346_g())).normalize();
                    attacker.func_233627_a_(0.75f, vec.x, vec.z);
                    player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), EnigmaticLegacy.SHIELD_TRIGGER, SoundCategory.PLAYERS, 1.0f, 0.9f + (float)(Math.random() * 0.1));
                    player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), EnigmaticLegacy.SHIELD_TRIGGER, SoundCategory.PLAYERS, 1.0f, 0.9f + (float)(Math.random() * 0.1));
                }
                event.setAmount(event.getAmount() * EtheriumArmor.shieldReduction.getValue().asModifierInverted());
            }
            if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.berserkEmblem)) {
                event.setAmount(event.getAmount() * (1.0f - SuperpositionHandler.getMissingHealthPool(player) * (float)BerserkEmblem.damageResistance.getValue()));
            }
            if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.cursedRing)) {
                event.setAmount(event.getAmount() * CursedRing.painMultiplier.getValue().asModifier());
            }
        } else if (event.getEntityLiving() instanceof MonsterEntity) {
            MonsterEntity monster = (MonsterEntity)event.getEntityLiving();
            if (event.getSource().func_76346_g() instanceof PlayerEntity) {
                PlayerEntity player2 = (PlayerEntity)event.getSource().func_76346_g();
                if (SuperpositionHandler.hasCurio((LivingEntity)player2, EnigmaticLegacy.monsterCharm)) {
                    if (monster.func_70662_br()) {
                        event.setAmount(event.getAmount() * MonsterCharm.undeadDamageBonus.getValue().asModifier(true));
                    } else if (!(!monster.func_213398_dR() && !(monster instanceof CreeperEntity) || monster instanceof EndermanEntity || monster instanceof ZombifiedPiglinEntity || monster instanceof BlazeEntity || monster instanceof GuardianEntity || monster instanceof ElderGuardianEntity || !monster.func_184222_aU())) {
                        event.setAmount(event.getAmount() * MonsterCharm.hostileDamageBonus.getValue().asModifier(true));
                    }
                }
                if (SuperpositionHandler.isTheCursedOne(player2) && (event.getSource().func_76364_f() != player2 || player2.func_184614_ca().func_77973_b() != EnigmaticLegacy.theTwist)) {
                    event.setAmount(event.getAmount() * CursedRing.monsterDamageDebuff.getValue().asModifierInverted());
                }
            }
        }
        if (event.getSource().func_76346_g() instanceof PlayerEntity) {
            player = (PlayerEntity)event.getSource().func_76346_g();
            immediateSource = event.getSource().func_76364_f();
            float damageBoost = 0.0f;
            if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.berserkEmblem)) {
                damageBoost += event.getAmount() * (SuperpositionHandler.getMissingHealthPool(player) * (float)BerserkEmblem.attackDamage.getValue());
            }
            if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.cursedScroll)) {
                damageBoost += event.getAmount() * (CursedScroll.damageBoost.getValue().asModifier() * (float)SuperpositionHandler.getCurseAmount(player));
            }
            event.setAmount(event.getAmount() + damageBoost);
        }
        if (event.getEntityLiving() instanceof TameableEntity && (pet = (TameableEntity)event.getEntityLiving()).func_70909_n() && (owner = pet.func_70902_q()) instanceof PlayerEntity && SuperpositionHandler.hasItem((PlayerEntity)owner, EnigmaticLegacy.hunterGuide) && owner.field_70170_p == pet.field_70170_p && owner.func_70032_d((Entity)pet) <= (float)HunterGuide.effectiveDistance.getValue()) {
            event.setCanceled(true);
            owner.func_70097_a(event.getSource(), SuperpositionHandler.hasItem((PlayerEntity)owner, EnigmaticLegacy.animalGuide) ? event.getAmount() * HunterGuide.synergyDamageReduction.getValue().asModifierInverted() : event.getAmount());
        }
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone evt) {
        PlayerEntity newPlayer = evt.getPlayer();
        PlayerEntity player = evt.getOriginal();
        EnigmaticLegacy.soulCrystal.updatePlayerSoulMap(newPlayer);
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            EnigmaticLegacy.soulCrystal.updatePlayerSoulMap((PlayerEntity)player);
            TransientPlayerData.get((PlayerEntity)player).syncToPlayer();
        }
        if (entity instanceof CreatureEntity && ((CreatureEntity)entity).func_70668_bt() == CreatureAttribute.field_223224_c_) {
            ((CreatureEntity)entity).field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)entity, PlayerEntity.class, targetEntity -> targetEntity instanceof PlayerEntity && SuperpositionHandler.hasAntiInsectAcknowledgement((PlayerEntity)targetEntity), 6.0f, 1.0, 1.3, EntityPredicates.field_188444_d::test));
        }
        if (entity instanceof PiglinEntity) {
            // empty if block
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onExperienceDrop(LivingExperienceDropEvent event) {
        PlayerEntity player = event.getAttackingPlayer();
        int bonusExp = 0;
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            if (this.hadEnigmaticAmulet((PlayerEntity)event.getEntityLiving()) && !event.getEntityLiving().field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
                event.setCanceled(true);
            }
        } else if (event.getEntityLiving() instanceof MonsterEntity && player != null && SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.monsterCharm)) {
            bonusExp = (int)((float)bonusExp + (float)event.getOriginalExperience() * (EnigmaticLegacy.monsterCharm.bonusXPModifier - 1.0f));
        }
        if (player != null && SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.cursedRing)) {
            bonusExp = (int)((double)bonusExp + (double)event.getOriginalExperience() * CursedRing.experienceBonus.getValue().asMultiplier());
        }
        event.setDroppedExperience(event.getDroppedExperience() + bonusExp);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDrops(LivingDropsEvent event) {
        ItemStack weap;
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            ItemStack soulCrystal;
            DimensionalPosition dimPoint;
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            boolean droppedCrystal = false;
            boolean hadEscapeScroll = this.hadEscapeScroll((PlayerEntity)player);
            DimensionalPosition dimensionalPosition = dimPoint = hadEscapeScroll ? SuperpositionHandler.getRespawnPoint(player) : new DimensionalPosition(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.field_70170_p);
            if (hadEscapeScroll) {
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 128.0, player.field_70170_p.func_234923_W_())), (Object)new PacketPortalParticles(player.func_226277_ct_(), player.func_226278_cu_() + (double)(player.func_213302_cg() / 2.0f), player.func_226281_cx_(), 100, 1.25, false));
                for (ItemEntity dropIt : event.getDrops()) {
                    ItemEntity alternativeDrop = new ItemEntity(dimPoint.world, dimPoint.posX, dimPoint.posY, dimPoint.posZ, dropIt.func_92059_d());
                    alternativeDrop.func_70634_a(dimPoint.posX, dimPoint.posY, dimPoint.posZ);
                    alternativeDrop.func_213293_j(theySeeMeRollin.nextDouble() - 0.5, theySeeMeRollin.nextDouble() - 0.5, theySeeMeRollin.nextDouble() - 0.5);
                    dimPoint.world.func_217376_c((Entity)alternativeDrop);
                    dropIt.func_92058_a(ItemStack.field_190927_a);
                }
                event.getDrops().clear();
                dimPoint.world.func_184133_a(null, new BlockPos(dimPoint.posX, dimPoint.posY, dimPoint.posZ), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(dimPoint.posX, dimPoint.posY, dimPoint.posZ, 128.0, dimPoint.world.func_234923_W_())), (Object)new PacketRecallParticles(dimPoint.posX, dimPoint.posY, dimPoint.posZ, 48, false));
            }
            if (this.hadEnigmaticAmulet((PlayerEntity)player) && !event.getDrops().isEmpty() && EnigmaticLegacy.enigmaticAmulet.isVesselEnabled()) {
                soulCrystal = SuperpositionHandler.shouldPlayerDropSoulCrystal((PlayerEntity)player) ? EnigmaticLegacy.soulCrystal.createCrystalFrom((PlayerEntity)player) : null;
                ItemStack storageCrystal = EnigmaticLegacy.storageCrystal.storeDropsOnCrystal(event.getDrops(), (PlayerEntity)player, soulCrystal);
                PermanentItemEntity droppedStorageCrystal = new PermanentItemEntity(dimPoint.world, dimPoint.getPosX(), dimPoint.getPosY() + 1.5, dimPoint.getPosZ(), storageCrystal);
                droppedStorageCrystal.setOwnerId(player.func_110124_au());
                dimPoint.world.func_217376_c((Entity)droppedStorageCrystal);
                EnigmaticLegacy.logger.info("Summoned Extradimensional Storage Crystal for " + player.func_146103_bH().getName() + " at X: " + dimPoint.getPosX() + ", Y: " + dimPoint.getPosY() + ", Z: " + dimPoint.getPosZ());
                event.getDrops().clear();
                if (soulCrystal != null) {
                    droppedCrystal = true;
                }
            } else if (SuperpositionHandler.shouldPlayerDropSoulCrystal((PlayerEntity)player)) {
                soulCrystal = EnigmaticLegacy.soulCrystal.createCrystalFrom((PlayerEntity)player);
                PermanentItemEntity droppedSoulCrystal = new PermanentItemEntity(dimPoint.world, dimPoint.getPosX(), dimPoint.getPosY() + 1.5, dimPoint.getPosZ(), soulCrystal);
                droppedSoulCrystal.setOwnerId(player.func_110124_au());
                dimPoint.world.func_217376_c((Entity)droppedSoulCrystal);
                EnigmaticLegacy.logger.info("Teared Soul Crystal from " + player.func_146103_bH().getName() + " at X: " + dimPoint.getPosX() + ", Y: " + dimPoint.getPosY() + ", Z: " + dimPoint.getPosZ());
                droppedCrystal = true;
            }
            ResourceLocation soulLossAdvancement = new ResourceLocation("enigmaticlegacy", "book/soul_loss");
            if (droppedCrystal) {
                SuperpositionHandler.grantAdvancement(player, soulLossAdvancement);
            } else if (!droppedCrystal && SuperpositionHandler.hasAdvancement(player, soulLossAdvancement)) {
                SuperpositionHandler.revokeAdvancement(player, soulLossAdvancement);
            }
            postmortalPossession.removeAll((Object)player);
            return;
        }
        if (event.getEntityLiving().getClass() == SkeletonEntity.class && event.isRecentlyHit() && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof PlayerEntity) {
            weap = ((PlayerEntity)event.getSource().func_76346_g()).func_184614_ca();
            if (weap != null && weap.func_77973_b() == EnigmaticLegacy.forbiddenAxe && !SuperpositionHandler.ifDroplistContainsItem(event.getDrops(), Items.field_196182_dv) && this.theySeeMeRollin(event.getLootingLevel())) {
                this.addDrop(event, new ItemStack((IItemProvider)Items.field_196182_dv, 1));
                if (event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
                    BeheadingTrigger.INSTANCE.trigger((ServerPlayerEntity)event.getSource().func_76346_g());
                }
            }
        } else if (event.getEntityLiving().getClass() == WitherSkeletonEntity.class && event.isRecentlyHit() && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof PlayerEntity) {
            weap = ((PlayerEntity)event.getSource().func_76346_g()).func_184614_ca();
            if (weap != null && weap.func_77973_b() == EnigmaticLegacy.forbiddenAxe) {
                if (!SuperpositionHandler.ifDroplistContainsItem(event.getDrops(), Items.field_196183_dw) && this.theySeeMeRollin(event.getLootingLevel())) {
                    this.addDrop(event, new ItemStack((IItemProvider)Items.field_196183_dw, 1));
                }
                if (event.getSource().func_76346_g() instanceof ServerPlayerEntity && SuperpositionHandler.ifDroplistContainsItem(event.getDrops(), Items.field_196183_dw)) {
                    BeheadingTrigger.INSTANCE.trigger((ServerPlayerEntity)event.getSource().func_76346_g());
                }
            }
        } else if (event.getEntityLiving().getClass() == ZombieEntity.class && event.isRecentlyHit() && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof PlayerEntity) {
            weap = ((PlayerEntity)event.getSource().func_76346_g()).func_184614_ca();
            if (weap != null && weap.func_77973_b() == EnigmaticLegacy.forbiddenAxe && !SuperpositionHandler.ifDroplistContainsItem(event.getDrops(), Items.field_196186_dz) && this.theySeeMeRollin(event.getLootingLevel())) {
                this.addDrop(event, new ItemStack((IItemProvider)Items.field_196186_dz, 1));
                if (event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
                    BeheadingTrigger.INSTANCE.trigger((ServerPlayerEntity)event.getSource().func_76346_g());
                }
            }
        } else if (event.getEntityLiving().getClass() == CreeperEntity.class && event.isRecentlyHit() && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof PlayerEntity) {
            weap = ((PlayerEntity)event.getSource().func_76346_g()).func_184614_ca();
            if (weap != null && weap.func_77973_b() == EnigmaticLegacy.forbiddenAxe && !SuperpositionHandler.ifDroplistContainsItem(event.getDrops(), Items.field_196185_dy) && this.theySeeMeRollin(event.getLootingLevel())) {
                this.addDrop(event, new ItemStack((IItemProvider)Items.field_196185_dy, 1));
                if (event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
                    BeheadingTrigger.INSTANCE.trigger((ServerPlayerEntity)event.getSource().func_76346_g());
                }
            }
        } else if (event.getEntityLiving().getClass() == EnderDragonEntity.class && event.isRecentlyHit() && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof PlayerEntity && (weap = ((PlayerEntity)event.getSource().func_76346_g()).func_184614_ca()) != null && weap.func_77973_b() == EnigmaticLegacy.forbiddenAxe && !SuperpositionHandler.ifDroplistContainsItem(event.getDrops(), Items.field_196151_dA) && this.theySeeMeRollin(event.getLootingLevel())) {
            this.addDrop(event, new ItemStack((IItemProvider)Items.field_196151_dA, 1));
            if (event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
                BeheadingTrigger.INSTANCE.trigger((ServerPlayerEntity)event.getSource().func_76346_g());
            }
        }
        if (event.isRecentlyHit() && event.getSource() != null && event.getSource().func_76346_g() instanceof PlayerEntity && SuperpositionHandler.isTheCursedOne((PlayerEntity)event.getSource().func_76346_g())) {
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            LivingEntity killed = event.getEntityLiving();
            if (SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.avariceScroll)) {
                this.addDropWithChance(event, new ItemStack((IItemProvider)Items.field_151166_bC, 1), 15);
            }
            if (killed.getClass() == ShulkerEntity.class) {
                this.addDropWithChance(event, new ItemStack((IItemProvider)EnigmaticLegacy.astralDust, 1), 20);
            } else if (killed.getClass() == SkeletonEntity.class || killed.getClass() == StrayEntity.class) {
                this.addDrop(event, this.getRandomSizeStack(Items.field_151032_g, 3, 15));
            } else if (killed.getClass() == ZombieEntity.class || killed.getClass() == HuskEntity.class) {
                this.addDropWithChance(event, this.getRandomSizeStack(Items.field_151123_aH, 1, 3), 25);
            } else if (killed.getClass() == SpiderEntity.class || killed.getClass() == CaveSpiderEntity.class) {
                this.addDrop(event, this.getRandomSizeStack(Items.field_151007_F, 2, 12));
            } else if (killed.getClass() == GuardianEntity.class) {
                this.addDropWithChance(event, new ItemStack((IItemProvider)Items.field_205157_eZ, 1), 15);
                this.addDrop(event, this.getRandomSizeStack(Items.field_179563_cD, 2, 5));
            } else if (killed.getClass() == ElderGuardianEntity.class) {
                this.addDrop(event, this.getRandomSizeStack(Items.field_179563_cD, 4, 16));
                this.addDrop(event, this.getRandomSizeStack(Items.field_179562_cC, 7, 28));
                this.addOneOf(event, new ItemStack((IItemProvider)EnigmaticLegacy.guardianHeart, 1), new ItemStack((IItemProvider)Items.field_205158_fa, 1), new ItemStack((IItemProvider)Items.field_196100_at, 1), new ItemStack((IItemProvider)Items.field_151061_bv, 1), EnchantmentHelper.func_77504_a((Random)theySeeMeRollin, (ItemStack)new ItemStack((IItemProvider)Items.field_203184_eO, 1), (int)(25 + theySeeMeRollin.nextInt(15)), (boolean)true));
            } else if (killed.getClass() == EndermanEntity.class) {
                this.addDropWithChance(event, this.getRandomSizeStack(Items.field_151061_bv, 1, 2), 40);
            } else if (killed.getClass() == BlazeEntity.class) {
                this.addDrop(event, this.getRandomSizeStack(Items.field_151065_br, 0, 5));
            } else if (killed.getClass() == ZombifiedPiglinEntity.class) {
                this.addDropWithChance(event, this.getRandomSizeStack(Items.field_151043_k, 1, 3), 40);
                this.addDropWithChance(event, this.getRandomSizeStack(Items.field_151114_aO, 1, 7), 30);
            } else if (killed.getClass() == WitchEntity.class) {
                this.addDropWithChance(event, new ItemStack((IItemProvider)Items.field_151073_bk, 1), 30);
                this.addDrop(event, this.getRandomSizeStack(Items.field_204840_eX, 1, 3));
            } else if (killed.getClass() == WitchEntity.class) {
                this.addDropWithChance(event, new ItemStack((IItemProvider)Items.field_151073_bk, 1), 30);
                this.addDropWithChance(event, this.getRandomSizeStack(Items.field_204840_eX, 1, 3), 50);
            } else if (killed.getClass() == PillagerEntity.class || killed.getClass() == VindicatorEntity.class) {
                this.addDrop(event, this.getRandomSizeStack(Items.field_151166_bC, 0, 4));
            } else if (killed.getClass() == VillagerEntity.class) {
                this.addDrop(event, this.getRandomSizeStack(Items.field_151166_bC, 2, 6));
            } else if (killed.getClass() == CreeperEntity.class) {
                this.addDrop(event, this.getRandomSizeStack(Items.field_151016_H, 4, 12));
            } else if (killed.getClass() == PiglinBruteEntity.class) {
                this.addDropWithChance(event, new ItemStack((IItemProvider)Items.field_234760_kn_, 1), 20);
            } else if (killed.getClass() == EvokerEntity.class) {
                this.addDrop(event, new ItemStack((IItemProvider)Items.field_190929_cY, 1));
                this.addDrop(event, this.getRandomSizeStack(Items.field_151166_bC, 5, 20));
                this.addDropWithChance(event, new ItemStack((IItemProvider)Items.field_196100_at, 1), 10);
                this.addDropWithChance(event, this.getRandomSizeStack(Items.field_151079_bi, 1, 3), 30);
                this.addDropWithChance(event, this.getRandomSizeStack(Items.field_151072_bj, 2, 4), 30);
                this.addDropWithChance(event, this.getRandomSizeStack(Items.field_151062_by, 4, 10), 50);
            } else if (killed.getClass() == WitherSkeletonEntity.class) {
                this.addDrop(event, this.getRandomSizeStack(Items.field_151065_br, 0, 3));
                this.addDropWithChance(event, new ItemStack((IItemProvider)Items.field_151073_bk, 1), 20);
                this.addDropWithChance(event, new ItemStack((IItemProvider)Items.field_234760_kn_, 1), 7);
            } else if (killed.getClass() == GhastEntity.class) {
                this.addDrop(event, this.getRandomSizeStack(Items.field_204840_eX, 1, 4));
            } else if (killed.getClass() == DrownedEntity.class) {
                this.addDropWithChance(event, this.getRandomSizeStack(Items.field_196128_bn, 1, 3), 30);
            } else if (killed.getClass() == VexEntity.class) {
                this.addDrop(event, this.getRandomSizeStack(Items.field_151114_aO, 0, 2));
                this.addDropWithChance(event, new ItemStack((IItemProvider)Items.field_204840_eX, 1), 30);
            } else if (killed.getClass() != PhantomEntity.class) {
                if (killed.getClass() == PiglinEntity.class) {
                    this.addDropWithChance(event, this.getRandomSizeStack(Items.field_151043_k, 2, 4), 50);
                } else if (killed.getClass() == RavagerEntity.class) {
                    this.addDrop(event, this.getRandomSizeStack(Items.field_151166_bC, 3, 10));
                    this.addDrop(event, this.getRandomSizeStack(Items.field_151116_aA, 2, 7));
                    this.addDropWithChance(event, this.getRandomSizeStack(Items.field_151045_i, 0, 4), 50);
                } else if (killed.getClass() != SilverfishEntity.class) {
                    if (killed.getClass() == MagmaCubeEntity.class) {
                        this.addDrop(event, this.getRandomSizeStack(Items.field_151065_br, 0, 1));
                    } else if (killed.getClass() == ChickenEntity.class) {
                        this.addDropWithChance(event, new ItemStack((IItemProvider)Items.field_151110_aK, 1), 50);
                    } else if (killed.getClass() == WitherEntity.class) {
                        this.addDrop(event, this.getRandomSizeStack(EnigmaticLegacy.evilEssence, 1, 4));
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLootTablesLoaded(LootTableLoadEvent event) {
        LootPool special;
        LootPool epic;
        LootTable modified;
        LootPool poolSpellstones;
        LootPool endLiterature;
        if (!OmniconfigHandler.customDungeonLootEnabled.getValue()) {
            return;
        }
        ArrayList<ResourceLocation> underwaterRuins = new ArrayList<ResourceLocation>();
        underwaterRuins.add(LootTables.field_204115_q);
        underwaterRuins.add(LootTables.field_204114_p);
        LootPool overworldLiterature = !OmniconfigHandler.isItemEnabled((Object)EnigmaticLegacy.overworldRevelationTome) ? null : SuperpositionHandler.constructLootPool("overworldLiterature", -7.0f, 2.0f, new LootEntry.Builder[]{SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.overworldRevelationTome, 100).func_212841_b_((ILootFunction.IBuilder)LootFunctionRevelation.of((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f), (IRandomRange)RandomValueRange.func_215837_a((float)50.0f, (float)500.0f)))});
        LootPool netherLiterature = !OmniconfigHandler.isItemEnabled((Object)EnigmaticLegacy.netherRevelationTome) ? null : SuperpositionHandler.constructLootPool("netherLiterature", -7.0f, 2.0f, new LootEntry.Builder[]{SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.netherRevelationTome, 100).func_212841_b_((ILootFunction.IBuilder)LootFunctionRevelation.of((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f), (IRandomRange)RandomValueRange.func_215837_a((float)100.0f, (float)700.0f)))});
        LootPool lootPool = endLiterature = !OmniconfigHandler.isItemEnabled((Object)EnigmaticLegacy.endRevelationTome) ? null : SuperpositionHandler.constructLootPool("endLiterature", -7.0f, 2.0f, new LootEntry.Builder[]{SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.endRevelationTome, 100).func_212841_b_((ILootFunction.IBuilder)LootFunctionRevelation.of((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f), (IRandomRange)RandomValueRange.func_215837_a((float)200.0f, (float)1000.0f)))});
        if (SuperpositionHandler.getMergedAir$EarthenDungeons().contains(event.getName())) {
            poolSpellstones = SuperpositionHandler.constructLootPool("spellstones", -12.0f, 1.0f, new LootEntry.Builder[]{SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.golemHeart, 35), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.angelBlessing, 65)});
            modified = event.getTable();
            modified.addPool(poolSpellstones);
            event.setTable(modified);
        } else if (SuperpositionHandler.getMergedEnder$EarthenDungeons().contains(event.getName())) {
            poolSpellstones = SuperpositionHandler.constructLootPool("spellstones", -10.0f, 1.0f, new LootEntry.Builder[]{SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.eyeOfNebula, 35), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.golemHeart, 65)});
            modified = event.getTable();
            modified.addPool(poolSpellstones);
            event.setTable(modified);
        } else if (SuperpositionHandler.getAirDungeons().contains(event.getName())) {
            poolSpellstones = SuperpositionHandler.constructLootPool("spellstones", -10.0f, 1.0f, new LootEntry.Builder[]{SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.angelBlessing, 100)});
            modified = event.getTable();
            modified.addPool(poolSpellstones);
            event.setTable(modified);
        } else if (SuperpositionHandler.getEarthenDungeons().contains(event.getName())) {
            poolSpellstones = SuperpositionHandler.constructLootPool("spellstones", -20.0f, 1.0f, new LootEntry.Builder[]{SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.golemHeart, 100)});
            modified = event.getTable();
            modified.addPool(poolSpellstones);
            event.setTable(modified);
        } else if (SuperpositionHandler.getNetherDungeons().contains(event.getName())) {
            poolSpellstones = SuperpositionHandler.constructLootPool("spellstones", -24.0f, 1.0f, new LootEntry.Builder[]{SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.magmaHeart, 100)});
            modified = event.getTable();
            modified.addPool(poolSpellstones);
            event.setTable(modified);
        } else if (SuperpositionHandler.getWaterDungeons().contains(event.getName())) {
            poolSpellstones = SuperpositionHandler.constructLootPool("spellstones", -20.0f, 1.0f, new LootEntry.Builder[]{SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.oceanStone, 100)});
            modified = event.getTable();
            modified.addPool(poolSpellstones);
            event.setTable(modified);
        } else if (SuperpositionHandler.getEnderDungeons().contains(event.getName())) {
            poolSpellstones = SuperpositionHandler.constructLootPool("spellstones", -12.0f, 1.0f, new LootEntry.Builder[]{SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.eyeOfNebula, 90), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.voidPearl, 10)});
            modified = event.getTable();
            modified.addPool(poolSpellstones);
            event.setTable(modified);
        }
        if (SuperpositionHandler.getOverworldDungeons().contains(event.getName())) {
            epic = SuperpositionHandler.constructLootPool("epic", 1.0f, 2.0f, new LootEntry.Builder[]{SuperpositionHandler.itemEntryBuilderED(Items.field_151035_b, 10, 20.0f, 30.0f, 1.0f, 0.8f), SuperpositionHandler.itemEntryBuilderED(Items.field_151036_c, 10, 20.0f, 30.0f, 1.0f, 0.8f), SuperpositionHandler.itemEntryBuilderED(Items.field_151040_l, 10, 20.0f, 30.0f, 1.0f, 0.8f), SuperpositionHandler.itemEntryBuilderED(Items.field_151037_a, 10, 20.0f, 30.0f, 1.0f, 0.8f), SuperpositionHandler.itemEntryBuilderED(Items.field_151031_f, 10, 20.0f, 30.0f, 1.0f, 0.8f), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.ironRing, 20), ItemLootEntry.func_216168_a((IItemProvider)EnigmaticLegacy.commonPotionBase).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)PotionHelper.createAdvancedPotion(EnigmaticLegacy.commonPotionBase, EnigmaticLegacy.HASTE).func_77978_p())), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.magnetRing, 8), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.unholyGrail, 4), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.loreInscriber, 5), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151113_aN).func_216086_a(10), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151111_aL).func_216086_a(10), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151166_bC).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151123_aH).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)10.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151116_aA).func_216086_a(35).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)8.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151158_bO).func_216086_a(25).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)4.0f, (float)16.0f))), SuperpositionHandler.getWaterDungeons().contains(event.getName()) || event.getName().equals((Object)LootTables.field_215813_K) ? null : SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.earthHeart, 7)});
            modified = event.getTable();
            modified.addPool(epic);
            if (event.getName() != LootTables.field_204772_t && overworldLiterature != null) {
                modified.addPool(overworldLiterature);
            }
            event.setTable(modified);
        } else if (SuperpositionHandler.getNetherDungeons().contains(event.getName())) {
            ItemStack fireResistancePotion = new ItemStack((IItemProvider)Items.field_151068_bn);
            fireResistancePotion = PotionUtils.func_185188_a((ItemStack)fireResistancePotion, (Potion)Potions.field_185242_n);
            LootPool epic2 = SuperpositionHandler.constructLootPool("epic", 1.0f, 2.0f, new LootEntry.Builder[]{SuperpositionHandler.itemEntryBuilderED(Items.field_151005_D, 10, 25.0f, 30.0f, 1.0f, 1.0f), SuperpositionHandler.itemEntryBuilderED(Items.field_151006_E, 10, 25.0f, 30.0f, 1.0f, 1.0f), SuperpositionHandler.itemEntryBuilderED(Items.field_151010_B, 10, 25.0f, 30.0f, 1.0f, 1.0f), SuperpositionHandler.itemEntryBuilderED(Items.field_151011_C, 10, 25.0f, 30.0f, 1.0f, 1.0f), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.oblivionStone, 8), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151166_bC).func_216086_a(30).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)7.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_221690_bg).func_216086_a(25).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151073_bk).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151129_at).func_216086_a(30), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151068_bn).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)fireResistancePotion.func_77978_p())), SuperpositionHandler.getBastionChests().contains(event.getName()) ? ItemLootEntry.func_216168_a((IItemProvider)EnigmaticLegacy.forbiddenFruit).func_216086_a(4) : null});
            LootTable modified2 = event.getTable();
            if (!event.getName().equals((Object)LootTables.field_237380_L_)) {
                modified2.addPool(epic2);
            } else {
                LootPool scroll = SuperpositionHandler.constructLootPool("darkest_scroll", 0.0f, 1.0f, new LootEntry.Builder[]{ItemLootEntry.func_216168_a((IItemProvider)EnigmaticLegacy.darkestScroll).func_216086_a(100).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)1.0f)))});
                modified2.addPool(scroll);
            }
            if (netherLiterature != null) {
                modified2.addPool(netherLiterature);
            }
            event.setTable(modified2);
        } else if (event.getName().equals((Object)LootTables.field_186421_c)) {
            epic = SuperpositionHandler.constructLootPool("epic", 1.0f, 2.0f, new LootEntry.Builder[]{ItemLootEntry.func_216168_a((IItemProvider)Items.field_151079_bi).func_216086_a(40).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)5.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151061_bv).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151060_bw).func_216086_a(30).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_151150_bK).func_216086_a(30).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_204840_eX).func_216086_a(25).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)7.0f))), ItemLootEntry.func_216168_a((IItemProvider)Items.field_221824_dv).func_216086_a(10), ItemLootEntry.func_216168_a((IItemProvider)Items.field_222070_lD).func_216086_a(15), ItemLootEntry.func_216168_a((IItemProvider)Items.field_185158_cP).func_216086_a(7), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.loreInscriber, 10), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.recallPotion, 15), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.mendingMixture, 40), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.astralDust, 85, 1.0f, 4.0f), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.etheriumOre, 60, 1.0f, 2.0f), SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.extradimensionalEye, 20)});
            modified = event.getTable();
            modified.addPool(epic);
            if (endLiterature != null) {
                modified.addPool(endLiterature);
            }
            event.setTable(modified);
        }
        if (SuperpositionHandler.getLibraries().contains(event.getName())) {
            special = SuperpositionHandler.constructLootPool("el_special", 2.0f, 3.0f, new LootEntry.Builder[]{ItemLootEntry.func_216168_a((IItemProvider)EnigmaticLegacy.thiccScroll).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)6.0f))), ItemLootEntry.func_216168_a((IItemProvider)EnigmaticLegacy.loreFragment).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)))});
            modified = event.getTable();
            modified.addPool(special);
            if (OmniconfigHandler.isItemEnabled((Object)EnigmaticLegacy.overworldRevelationTome)) {
                LootPool literature = SuperpositionHandler.constructLootPool("literature", -4.0f, 3.0f, new LootEntry.Builder[]{SuperpositionHandler.createOptionalLootEntry(EnigmaticLegacy.overworldRevelationTome, 100).func_212841_b_((ILootFunction.IBuilder)LootFunctionRevelation.of((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f), (IRandomRange)RandomValueRange.func_215837_a((float)50.0f, (float)500.0f)))});
                modified.addPool(literature);
            }
            event.setTable(modified);
        }
        if (event.getName().equals((Object)LootTables.field_204115_q) || event.getName().equals((Object)LootTables.field_204114_p)) {
            special = SuperpositionHandler.constructLootPool("el_special", -5.0f, 1.0f, new LootEntry.Builder[]{ItemLootEntry.func_216168_a((IItemProvider)Items.field_203184_eO).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.5f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)EnchantWithLevels.func_215895_a((IRandomRange)RandomValueRange.func_215837_a((float)15.0f, (float)40.0f)).func_216059_e())});
            modified = event.getTable();
            modified.addPool(special);
            event.setTable(modified);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        if (!OmniconfigWrapper.syncAllToPlayer((ServerPlayerEntity)event.getPlayer())) {
            OmniconfigWrapper.onRemoteServer = false;
            EnigmaticLegacy.logger.info("Logging in to local integrated server; no synchronization is required.");
        }
        try {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            if (OmniconfigHandler.isItemEnabled(EnigmaticLegacy.enigmaticAmulet) && !SuperpositionHandler.hasPersistentTag((PlayerEntity)player, NBT_KEY_FIRSTJOIN)) {
                ItemStack enigmaticAmulet = new ItemStack((IItemProvider)EnigmaticLegacy.enigmaticAmulet);
                EnigmaticLegacy.enigmaticAmulet.setInscription(enigmaticAmulet, player.func_146103_bH().getName());
                if (!EnigmaticAmulet.seededColorGen.getValue()) {
                    EnigmaticLegacy.enigmaticAmulet.setRandomColor(enigmaticAmulet);
                } else {
                    EnigmaticLegacy.enigmaticAmulet.setSeededColor(enigmaticAmulet);
                }
                if (player.field_71071_by.func_70301_a(8).func_190926_b()) {
                    player.field_71071_by.func_70299_a(8, enigmaticAmulet);
                } else if (!player.field_71071_by.func_70441_a(enigmaticAmulet)) {
                    ItemEntity dropAmulet = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), enigmaticAmulet);
                    player.field_70170_p.func_217376_c((Entity)dropAmulet);
                }
                SuperpositionHandler.setPersistentBoolean((PlayerEntity)player, NBT_KEY_FIRSTJOIN, true);
            }
            if (OmniconfigHandler.isItemEnabled(EnigmaticLegacy.cursedRing) && !SuperpositionHandler.hasPersistentTag((PlayerEntity)player, NBT_KEY_CURSEDGIFT)) {
                ItemStack cursedRingStack = new ItemStack((IItemProvider)EnigmaticLegacy.cursedRing);
                if (!CursedRing.ultraHardcore.getValue()) {
                    if (player.field_71071_by.func_70301_a(7).func_190926_b()) {
                        player.field_71071_by.func_70299_a(7, cursedRingStack);
                    } else if (!player.field_71071_by.func_70441_a(cursedRingStack)) {
                        ItemEntity dropRing = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), cursedRingStack);
                        player.field_70170_p.func_217376_c((Entity)dropRing);
                    }
                } else {
                    CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
                        if (!player.field_70170_p.field_72995_K) {
                            Map curios = handler.getCurios();
                            for (Map.Entry entry : curios.entrySet()) {
                                IDynamicStackHandler stackHandler = ((ICurioStacksHandler)entry.getValue()).getStacks();
                                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                                    ItemStack present = stackHandler.getStackInSlot(i);
                                    Set tags = CuriosApi.getCuriosHelper().getCurioTags((Item)EnigmaticLegacy.cursedRing);
                                    String id = (String)entry.getKey();
                                    if (!present.func_190926_b() || !tags.contains(id) && !tags.contains("curio") || !EnigmaticLegacy.cursedRing.canEquip(id, (LivingEntity)player, cursedRingStack)) continue;
                                    stackHandler.setStackInSlot(i, cursedRingStack);
                                    EnigmaticLegacy.cursedRing.playRightClickEquipSound((LivingEntity)player, cursedRingStack);
                                }
                            }
                        }
                    });
                }
                SuperpositionHandler.setPersistentBoolean((PlayerEntity)player, NBT_KEY_CURSEDGIFT, true);
            }
            if (SuperpositionHandler.hasAdvancement(player, new ResourceLocation("enigmaticlegacy", "main/discover_spellstone"))) {
                CuriosApi.getSlotHelper().unlockSlotType("spellstone", (LivingEntity)event.getPlayer());
                SuperpositionHandler.setPersistentBoolean((PlayerEntity)player, NBT_KEY_ENABLESPELLSTONE, true);
            }
            if (SuperpositionHandler.hasAdvancement(player, new ResourceLocation("enigmaticlegacy", "main/discover_scroll"))) {
                CuriosApi.getSlotHelper().unlockSlotType("scroll", (LivingEntity)event.getPlayer());
                SuperpositionHandler.setPersistentBoolean((PlayerEntity)player, NBT_KEY_ENABLESCROLL, true);
            }
            ServerRecipeBook book = player.func_192037_E();
            if (OmniconfigHandler.retriggerRecipeUnlocks.getValue()) {
                for (IRecipe theRecipe : player.field_70170_p.func_199532_z().func_199510_b()) {
                    if (!book.func_193830_f(theRecipe)) continue;
                    CriteriaTriggers.field_192126_f.func_192225_a(player, theRecipe);
                }
            }
        }
        catch (Exception ex) {
            EnigmaticLegacy.logger.error("Failed to check player's advancements upon joining the world!");
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onAdvancement(AdvancementEvent event) {
        String id = event.getAdvancement().func_192067_g().toString();
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity && id.startsWith("enigmaticlegacy:book/")) {
            EnigmaticLegacy.packetInstance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new PacketSetEntryState(false, id.replace("book/", "")));
        }
        if (id.equals("enigmaticlegacy:main/discover_spellstone")) {
            EnigmaticLegacy.packetInstance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new PacketSlotUnlocked("spellstone"));
            CuriosApi.getSlotHelper().unlockSlotType("spellstone", (LivingEntity)player);
            SuperpositionHandler.setPersistentBoolean(player, NBT_KEY_ENABLESPELLSTONE, true);
        } else if (id.equals("enigmaticlegacy:main/discover_scroll")) {
            EnigmaticLegacy.packetInstance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new PacketSlotUnlocked("scroll"));
            CuriosApi.getSlotHelper().unlockSlotType("scroll", (LivingEntity)player);
            SuperpositionHandler.setPersistentBoolean(player, NBT_KEY_ENABLESCROLL, true);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!(player.field_70170_p.field_72995_K || event.isEndConquered() || player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c))) {
            if (SuperpositionHandler.hasPersistentTag(player, NBT_KEY_ENABLESCROLL)) {
                CuriosApi.getSlotHelper().unlockSlotType("scroll", (LivingEntity)event.getPlayer());
            }
            if (SuperpositionHandler.hasPersistentTag(player, NBT_KEY_ENABLESPELLSTONE)) {
                CuriosApi.getSlotHelper().unlockSlotType("spellstone", (LivingEntity)event.getPlayer());
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onAnvilOpen(GuiScreenEvent.InitGuiEvent event) {
        if (event.getGui() instanceof AnvilScreen) {
            AnvilScreen screen = (AnvilScreen)event.getGui();
            EnigmaticLegacy.packetInstance.send(PacketDistributor.SERVER.noArg(), (Object)new PacketAnvilField(""));
            try {
                for (Field f : screen.getClass().getDeclaredFields()) {
                    f.setAccessible(true);
                    if (!(f.get(screen) instanceof TextFieldWidget)) continue;
                    TextFieldWidget widget = (TextFieldWidget)f.get(screen);
                    widget.func_146203_f(64);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        if (event.getLeft().func_190916_E() == 1 && event.getRight().func_77973_b().equals((Object)EnigmaticLegacy.loreFragment) && event.getRight().func_179543_a("display") != null) {
            event.setCost(4);
            event.setMaterialCost(1);
            event.setOutput(ItemLoreHelper.mergeDisplayData(event.getRight(), event.getLeft().func_77946_l()));
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.getPlayer() != null && !event.getPlayer().field_70170_p.field_72995_K) {
            if (event.getInventory().func_213901_a((Item)EnigmaticLegacy.enchantmentTransposer) == 1 && event.getCrafting().func_77973_b() == Items.field_151134_bR) {
                event.getPlayer().field_70170_p.func_184133_a(null, event.getPlayer().func_233580_cy_(), SoundEvents.field_190021_aL, SoundCategory.PLAYERS, 1.0f, (float)((double)0.9f + Math.random() * (double)0.1f));
            } else if (event.getCrafting().func_77973_b() == EnigmaticLegacy.cursedStone) {
                event.getPlayer().field_70170_p.func_184133_a(null, event.getPlayer().func_233580_cy_(), SoundEvents.field_206938_K, SoundCategory.PLAYERS, 1.0f, (float)((double)0.9f + Math.random() * (double)0.1f));
            }
        }
    }

    @SubscribeEvent
    public void onAttackTargetSet(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getTarget();
            if (event.getEntityLiving() instanceof MobEntity) {
                MobEntity insect = (MobEntity)event.getEntityLiving();
                if (insect.func_70668_bt() == CreatureAttribute.field_223224_c_ && SuperpositionHandler.hasAntiInsectAcknowledgement(player)) {
                    insect.func_70624_b(null);
                }
                if (insect instanceof GuardianEntity && insect.getClass() != ElderGuardianEntity.class && SuperpositionHandler.hasItem(player, EnigmaticLegacy.guardianHeart) && SuperpositionHandler.isTheCursedOne(player)) {
                    boolean isBlacklisted = angeredGuardians.containsEntry((Object)player, (Object)insect);
                    if (insect.func_70643_av() != player && !isBlacklisted) {
                        insect.func_70624_b(null);
                    } else if (!isBlacklisted) {
                        angeredGuardians.put((Object)player, (Object)((GuardianEntity)insect));
                    }
                }
            }
        }
    }

    public void addDrop(LivingDropsEvent event, ItemStack drop) {
        ItemEntity entityitem = new ItemEntity(event.getEntityLiving().field_70170_p, event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_(), event.getEntityLiving().func_226281_cx_(), drop);
        entityitem.func_174867_a(10);
        event.getDrops().add(entityitem);
    }

    public void addDropWithChance(LivingDropsEvent event, ItemStack drop, int chance) {
        if (theySeeMeRollin.nextInt(100) < chance) {
            this.addDrop(event, drop);
        }
    }

    public ItemStack getRandomSizeStack(Item item, int minAmount, int maxAmount) {
        return new ItemStack((IItemProvider)item, minAmount + theySeeMeRollin.nextInt(maxAmount - minAmount + 1));
    }

    public void addOneOf(LivingDropsEvent event, ItemStack ... itemStacks) {
        int chosenStack = theySeeMeRollin.nextInt(itemStacks.length);
        this.addDrop(event, itemStacks[chosenStack]);
    }

    private boolean theySeeMeRollin(int lootingLevel) {
        int chance = Math.min(ForbiddenAxe.beheadingBase.getValue().asPercentage() + ForbiddenAxe.beheadingBonus.getValue().asPercentage() * lootingLevel, 100);
        return new Perhaps(chance).roll();
    }

    private boolean hadEnigmaticAmulet(PlayerEntity player) {
        return postmortalPossession.containsKey((Object)player) ? postmortalPossession.containsEntry((Object)player, (Object)EnigmaticLegacy.enigmaticAmulet) : false;
    }

    private boolean hadEscapeScroll(PlayerEntity player) {
        return postmortalPossession.containsKey((Object)player) ? postmortalPossession.containsEntry((Object)player, (Object)EnigmaticLegacy.escapeScroll) : false;
    }

    private boolean hadUnholyStone(PlayerEntity player) {
        return postmortalPossession.containsKey((Object)player) ? postmortalPossession.containsEntry((Object)player, (Object)EnigmaticLegacy.cursedStone) : false;
    }
}

