/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.handlers;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.packets.clients.PacketUpdateNotification;
import com.integral.omniconfig.Configuration;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.net.URL;
import java.util.Scanner;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class EnigmaticUpdateHandler {
    public static Omniconfig.BooleanParameter notificationsEnabled;
    private static String currentVersion;
    private static String newestVersion;
    public static TranslationTextComponent updateStatus;
    public static boolean show;
    static boolean worked;

    @SubscribeConfig(receiveClient=true)
    public static void onConfig(OmniconfigWrapper builder) {
        if (builder.config.getSidedType() == Configuration.SidedConfigType.CLIENT) {
            notificationsEnabled = builder.comment("Whether or not Enigmatic Legacy should show notification in chat when new mod update is available.").getBoolean("UpdateHandlerEnabled", true);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            EnigmaticLegacy.packetInstance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new PacketUpdateNotification());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleShowup(ClientPlayerEntity player) {
        if (!show) {
            return;
        }
        if (notificationsEnabled.getValue()) {
            player.func_145747_a((ITextComponent)updateStatus, player.func_110124_au());
        }
        show = false;
    }

    public static void init() {
        EnigmaticUpdateHandler.getNewestVersion();
        if (newestVersion != null) {
            if (newestVersion.equalsIgnoreCase(currentVersion)) {
                show = false;
            } else if (!newestVersion.equalsIgnoreCase(currentVersion)) {
                show = true;
                StringTextComponent newVerArg = new StringTextComponent(newestVersion);
                newVerArg.func_240699_a_(TextFormatting.GOLD);
                updateStatus = new TranslationTextComponent("status.enigmaticlegacy.outdated", new Object[]{newVerArg});
                updateStatus.func_240699_a_(TextFormatting.DARK_PURPLE);
            }
        } else {
            show = true;
            updateStatus = new TranslationTextComponent("status.enigmaticlegacy.noconnection");
            updateStatus.func_240699_a_(TextFormatting.RED);
        }
    }

    private static void getNewestVersion() {
        try {
            URL url = new URL("https://raw.githubusercontent.com/Extegral/Enigmatic-Legacy/1.16.X/version.txt");
            Scanner s = new Scanner(url.openStream());
            newestVersion = s.nextLine();
            s.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        currentVersion = "2.11.4 Release";
        updateStatus = null;
        show = false;
        worked = false;
    }
}

