/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.handlers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.generic.ConfigurableItem;
import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.api.items.ISpellstone;
import com.integral.enigmaticlegacy.config.OmniconfigHandler;
import com.integral.enigmaticlegacy.handlers.RealSmoothTeleporter;
import com.integral.enigmaticlegacy.helpers.AdvancedSpawnLocationHelper;
import com.integral.enigmaticlegacy.items.TheAcknowledgment;
import com.integral.enigmaticlegacy.items.generic.ItemSpellstoneCurio;
import com.integral.enigmaticlegacy.objects.DimensionalPosition;
import com.integral.enigmaticlegacy.objects.TransientPlayerData;
import com.integral.enigmaticlegacy.objects.Vector3;
import com.integral.enigmaticlegacy.packets.clients.PacketPortalParticles;
import com.integral.enigmaticlegacy.packets.clients.PacketRecallParticles;
import com.integral.omniconfig.Configuration;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.functions.EnchantWithLevels;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.SetDamage;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class SuperpositionHandler {
    public static final Random random = new Random();
    public static final char[] alphabet = "abcdefghijklmnopqrstuvwxyz".toUpperCase().toCharArray();

    public static boolean hasAdvancedCurios(LivingEntity entity) {
        return SuperpositionHandler.getAdvancedCurios(entity).size() > 0;
    }

    public static List<ItemStack> getAdvancedCurios(LivingEntity entity) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ICuriosItemHandler handler = (ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler(entity).orElse(null);
        if (handler != null) {
            handler.getCurios().values().forEach(stacksHandler -> {
                IDynamicStackHandler soloStackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                    if (soloStackHandler.getStackInSlot(i) == null || !(soloStackHandler.getStackInSlot(i).func_77973_b() instanceof ItemSpellstoneCurio)) continue;
                    stackList.add(soloStackHandler.getStackInSlot(i));
                }
            });
        }
        return stackList;
    }

    public static boolean isSlotLocked(String id, LivingEntity livingEntity) {
        ICuriosItemHandler handler = (ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).orElse(null);
        if (handler != null) {
            return handler.getLockedSlots().contains(id);
        }
        return true;
    }

    public static boolean hasSpellstone(LivingEntity entity) {
        return SuperpositionHandler.getSpellstone(entity) != null;
    }

    @Nullable
    public static ItemStack getSpellstone(LivingEntity entity) {
        ArrayList spellstoneStack = new ArrayList();
        CuriosApi.getCuriosHelper().getCuriosHandler(entity).ifPresent(handler -> {
            IDynamicStackHandler soloStackHandler;
            ICurioStacksHandler stacksHandler = (ICurioStacksHandler)handler.getCurios().get("spellstone");
            if (stacksHandler != null && (soloStackHandler = stacksHandler.getStacks()) != null) {
                for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                    if (soloStackHandler.getStackInSlot(i) == null || !(soloStackHandler.getStackInSlot(i).func_77973_b() instanceof ISpellstone)) continue;
                    spellstoneStack.add(soloStackHandler.getStackInSlot(i));
                    break;
                }
            }
        });
        return spellstoneStack.isEmpty() ? null : (ItemStack)spellstoneStack.get(0);
    }

    public static boolean hasCurio(LivingEntity entity, Item curio) {
        Optional data = CuriosApi.getCuriosHelper().findEquippedCurio(curio, entity);
        return data.isPresent();
    }

    @Nullable
    public static ItemStack getCurioStack(LivingEntity entity, Item curio) {
        Optional data = CuriosApi.getCuriosHelper().findEquippedCurio(curio, entity);
        if (data.isPresent()) {
            return (ItemStack)((ImmutableTriple)data.get()).getRight();
        }
        return null;
    }

    public static void destroyCurio(LivingEntity entity, Item curio) {
        CuriosApi.getCuriosHelper().getEquippedCurios(entity).ifPresent(handler -> {
            for (int i = 0; i < handler.getSlots() - 1; ++i) {
                if (handler.getStackInSlot(i) == null || handler.getStackInSlot(i).func_77973_b() != curio) continue;
                handler.setStackInSlot(i, ItemStack.field_190927_a);
            }
        });
    }

    public static void registerCurioType(String identifier, int slots, boolean isEnabled, boolean isHidden, @Nullable ResourceLocation icon) {
        SlotTypeMessage.Builder message = new SlotTypeMessage.Builder(identifier);
        message.size(slots);
        if (!isEnabled) {
            message.lock();
        }
        if (isHidden) {
            message.hide();
        }
        if (icon != null) {
            message.icon(icon);
        }
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> message.build());
    }

    public static SoundEvent registerSound(String soundName) {
        ResourceLocation location = new ResourceLocation("enigmaticlegacy", soundName);
        SoundEvent event = new SoundEvent(location);
        event.setRegistryName(location);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)event);
        return event;
    }

    public static AxisAlignedBB getBoundingBoxAroundEntity(Entity entity, double radius) {
        return new AxisAlignedBB(entity.func_226277_ct_() - radius, entity.func_226278_cu_() - radius, entity.func_226281_cx_() - radius, entity.func_226277_ct_() + radius, entity.func_226278_cu_() + radius, entity.func_226281_cx_() + radius);
    }

    public static void setEntityMotionFromVector(Entity entity, Vector3 originalPosVector, float modifier) {
        Vector3 entityVector = Vector3.fromEntityCenter(entity);
        Vector3 finalVector = originalPosVector.subtract(entityVector);
        if (finalVector.mag() > 1.0) {
            finalVector = finalVector.normalize();
        }
        entity.func_213293_j(finalVector.x * (double)modifier, finalVector.y * (double)modifier, finalVector.z * (double)modifier);
    }

    @Nullable
    public static LivingEntity getObservedEntity(PlayerEntity player, World world, float range, int maxDist) {
        LivingEntity newTarget = null;
        Vector3 target = Vector3.fromEntityCenter((Entity)player);
        List entities = new ArrayList();
        for (int distance = 1; entities.size() == 0 && distance < maxDist; ++distance) {
            target = target.add(new Vector3(player.func_70040_Z()).multiply(distance)).add(0.0, 0.5, 0.0);
            entities = player.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(target.x - (double)range, target.y - (double)range, target.z - (double)range, target.x + (double)range, target.y + (double)range, target.z + (double)range));
            if (!entities.contains(player)) continue;
            entities.remove(player);
        }
        if (entities.size() > 0) {
            newTarget = (LivingEntity)entities.get(0);
        }
        return newTarget;
    }

    @Nullable
    public static <T extends LivingEntity> T getClosestEntity(List<? extends T> entities, Predicate<LivingEntity> predicate, double x, double y, double z) {
        double d0 = -1.0;
        LivingEntity t = null;
        for (LivingEntity t1 : entities) {
            if (!predicate.test(t1)) continue;
            double d1 = t1.func_70092_e(x, y, z);
            if (d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            t = t1;
        }
        return (T)t;
    }

    public static boolean doesObserveEntity(PlayerEntity player, LivingEntity entity) {
        Vector3d vector3d = player.func_70676_i(1.0f).func_72432_b();
        Vector3d vector3d1 = new Vector3d(entity.func_226277_ct_() - player.func_226277_ct_(), entity.func_226280_cw_() - player.func_226280_cw_(), entity.func_226281_cx_() - player.func_226281_cx_());
        double d0 = vector3d1.func_72433_c();
        double d1 = vector3d.func_72430_b(vector3d1 = vector3d1.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? player.func_70685_l((Entity)entity) : false;
    }

    public static int getSpellstoneCooldown(PlayerEntity player) {
        return TransientPlayerData.get(player).getSpellstoneCooldown();
    }

    public static void setSpellstoneCooldown(PlayerEntity playerIn, int value) {
        TransientPlayerData.get(playerIn).setSpellstoneCooldown(value);
    }

    public static void tickSpellstoneCooldown(PlayerEntity player, int decrementedTicks) {
        TransientPlayerData data = TransientPlayerData.get(player);
        data.spellstoneCooldown = data.getSpellstoneCooldown() - decrementedTicks;
    }

    public static boolean hasSpellstoneCooldown(PlayerEntity player) {
        return TransientPlayerData.get(player).getSpellstoneCooldown() > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void lookAt(double px, double py, double pz, ClientPlayerEntity me) {
        double dirx = me.func_226277_ct_() - px;
        double diry = me.func_226278_cu_() - py;
        double dirz = me.func_226281_cx_() - pz;
        double len = Math.sqrt(dirx * dirx + diry * diry + dirz * dirz);
        double pitch = Math.asin(diry /= len);
        double yaw = Math.atan2(dirz /= len, dirx /= len);
        pitch = pitch * 180.0 / Math.PI;
        yaw = yaw * 180.0 / Math.PI;
        me.field_70125_A = (float)pitch;
        me.field_70177_z = (float)(yaw += 90.0);
    }

    public static boolean validTeleport(Entity entity, double x_init, double y_init, double z_init, World world, int checkAxis) {
        int x = (int)x_init;
        int y = (int)y_init;
        int z = (int)z_init;
        BlockState block = world.func_180495_p(new BlockPos(x, y - 1, z));
        if (world.func_175623_d(new BlockPos(x, y - 1, z)) & block.func_200132_m()) {
            for (int counter = 0; counter <= checkAxis; ++counter) {
                if (!(!world.func_175623_d(new BlockPos(x, y + counter - 1, z)) & world.func_180495_p(new BlockPos(x, y + counter - 1, z)).func_200132_m() & world.func_175623_d(new BlockPos(x, y + counter, z)) & world.func_175623_d(new BlockPos(x, y + counter + 1, z)))) continue;
                world.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_187534_aX, SoundCategory.HOSTILE, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 128.0, entity.field_70170_p.func_234923_W_())), (Object)new PacketPortalParticles(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_(), 72, 1.0, false));
                if (entity instanceof ServerPlayerEntity) {
                    ServerPlayerEntity player = (ServerPlayerEntity)entity;
                    player.func_70634_a((double)x + 0.5, (double)(y + counter), (double)z + 0.5);
                } else {
                    ((LivingEntity)entity).func_70634_a((double)x + 0.5, (double)(y + counter), (double)z + 0.5);
                }
                world.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_187534_aX, SoundCategory.HOSTILE, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 128.0, entity.field_70170_p.func_234923_W_())), (Object)new PacketRecallParticles(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_(), 48, false));
                return true;
            }
        } else {
            for (int counter = 0; counter <= checkAxis; ++counter) {
                if (!(!world.func_175623_d(new BlockPos(x, y - counter - 1, z)) & world.func_180495_p(new BlockPos(x, y - counter - 1, z)).func_200132_m() & world.func_175623_d(new BlockPos(x, y - counter, z)) & world.func_175623_d(new BlockPos(x, y - counter + 1, z)))) continue;
                world.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_187534_aX, SoundCategory.HOSTILE, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 128.0, entity.field_70170_p.func_234923_W_())), (Object)new PacketRecallParticles(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_(), 48, false));
                if (entity instanceof ServerPlayerEntity) {
                    ServerPlayerEntity player = (ServerPlayerEntity)entity;
                    player.func_70634_a((double)x + 0.5, (double)(y - counter), (double)z + 0.5);
                } else {
                    ((LivingEntity)entity).func_70634_a((double)x + 0.5, (double)(y - counter), (double)z + 0.5);
                }
                world.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_187534_aX, SoundCategory.HOSTILE, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 128.0, entity.field_70170_p.func_234923_W_())), (Object)new PacketRecallParticles(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_(), 48, false));
                return true;
            }
        }
        return false;
    }

    public static boolean validTeleportRandomly(Entity entity, World world, int radius) {
        int d = radius * 2;
        double x = entity.func_226277_ct_() + (Math.random() - 0.5) * (double)d;
        double y = entity.func_226278_cu_() + (Math.random() - 0.5) * (double)d;
        double z = entity.func_226281_cx_() + (Math.random() - 0.5) * (double)d;
        return SuperpositionHandler.validTeleport(entity, x, y, z, world, radius);
    }

    public static LootPool constructLootPool(String poolName, float minRolls, float maxRolls, LootEntry.Builder<?> ... entries) {
        LootPool.Builder poolBuilder = LootPool.func_216096_a();
        poolBuilder.name(poolName);
        poolBuilder.func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)minRolls, (float)maxRolls));
        for (LootEntry.Builder<?> entry : entries) {
            if (entry == null) continue;
            poolBuilder.func_216045_a(entry);
        }
        LootPool constructedPool = poolBuilder.func_216044_b();
        return constructedPool;
    }

    @Nullable
    public static StandaloneLootEntry.Builder<?> createOptionalLootEntry(Item item, int weight, float minCount, float maxCount) {
        if (!OmniconfigHandler.isItemEnabled(item)) {
            return null;
        }
        return ItemLootEntry.func_216168_a((IItemProvider)item).func_216086_a(weight).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)minCount, (float)maxCount)));
    }

    @Nullable
    public static StandaloneLootEntry.Builder<?> createOptionalLootEntry(Item item, int weight) {
        if (!OmniconfigHandler.isItemEnabled(item)) {
            return null;
        }
        return ItemLootEntry.func_216168_a((IItemProvider)item).func_216086_a(weight);
    }

    public static StandaloneLootEntry.Builder<?> itemEntryBuilderED(Item item, int weight, float enchantLevelMin, float enchantLevelMax, float damageMin, float damageMax) {
        StandaloneLootEntry.Builder builder = ItemLootEntry.func_216168_a((IItemProvider)item);
        builder.func_216086_a(weight);
        builder.func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)damageMax, (float)damageMin)));
        builder.func_212841_b_((ILootFunction.IBuilder)EnchantWithLevels.func_215895_a((IRandomRange)RandomValueRange.func_215837_a((float)enchantLevelMin, (float)enchantLevelMax)).func_216059_e());
        return builder;
    }

    public static List<ResourceLocation> getEarthenDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_186422_d);
        lootChestList.add(LootTables.field_186424_f);
        lootChestList.add(LootTables.field_215816_g);
        return lootChestList;
    }

    public static List<ResourceLocation> getWaterDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_204115_q);
        lootChestList.add(LootTables.field_204114_p);
        lootChestList.add(LootTables.field_204773_u);
        lootChestList.add(LootTables.field_204312_r);
        return lootChestList;
    }

    public static List<ResourceLocation> getLibraries() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_186426_h);
        lootChestList.add(LootTables.field_204771_s);
        return lootChestList;
    }

    public static List<ResourceLocation> getBastionChests() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_237380_L_);
        lootChestList.add(LootTables.field_237381_M_);
        lootChestList.add(LootTables.field_237382_N_);
        lootChestList.add(LootTables.field_237383_O_);
        return lootChestList;
    }

    public static List<ResourceLocation> getNetherDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_186425_g);
        lootChestList.add(LootTables.field_237380_L_);
        lootChestList.add(LootTables.field_237381_M_);
        lootChestList.add(LootTables.field_237382_N_);
        lootChestList.add(LootTables.field_237383_O_);
        lootChestList.add(LootTables.field_237384_P_);
        return lootChestList;
    }

    public static List<ResourceLocation> getAirDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_215824_o);
        return lootChestList;
    }

    public static List<ResourceLocation> getEnderDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_186421_c);
        return lootChestList;
    }

    public static List<ResourceLocation> getMergedAir$EarthenDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_186429_k);
        lootChestList.add(LootTables.field_186430_l);
        return lootChestList;
    }

    public static List<ResourceLocation> getMergedEnder$EarthenDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_186428_j);
        lootChestList.add(LootTables.field_186427_i);
        return lootChestList;
    }

    public static List<ResourceLocation> getOverworldDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_186422_d);
        lootChestList.add(LootTables.field_186424_f);
        lootChestList.add(LootTables.field_186427_i);
        lootChestList.add(LootTables.field_186428_j);
        lootChestList.add(LootTables.field_186429_k);
        lootChestList.add(LootTables.field_186430_l);
        lootChestList.add(LootTables.field_186431_m);
        lootChestList.add(LootTables.field_191192_o);
        lootChestList.add(LootTables.field_204114_p);
        lootChestList.add(LootTables.field_204115_q);
        lootChestList.add(LootTables.field_204772_t);
        lootChestList.add(LootTables.field_215813_K);
        return lootChestList;
    }

    public static List<ResourceLocation> getVillageChests() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(LootTables.field_215814_e);
        lootChestList.add(LootTables.field_215815_f);
        lootChestList.add(LootTables.field_215816_g);
        lootChestList.add(LootTables.field_215817_h);
        lootChestList.add(LootTables.field_215818_i);
        lootChestList.add(LootTables.field_215819_j);
        lootChestList.add(LootTables.field_215820_k);
        lootChestList.add(LootTables.field_215821_l);
        lootChestList.add(LootTables.field_215822_m);
        lootChestList.add(LootTables.field_215823_n);
        lootChestList.add(LootTables.field_215824_o);
        lootChestList.add(LootTables.field_215825_p);
        lootChestList.add(LootTables.field_215826_q);
        lootChestList.add(LootTables.field_215827_r);
        lootChestList.add(LootTables.field_215828_s);
        lootChestList.add(LootTables.field_215829_t);
        return lootChestList;
    }

    public static INBT getPersistentTag(PlayerEntity player, String tag, INBT expectedValue) {
        CompoundNBT persistent;
        CompoundNBT data = player.getPersistentData();
        if (!data.func_74764_b("PlayerPersisted")) {
            persistent = new CompoundNBT();
            data.func_218657_a("PlayerPersisted", (INBT)persistent);
        } else {
            persistent = data.func_74775_l("PlayerPersisted");
        }
        if (persistent.func_74764_b(tag)) {
            return persistent.func_74781_a(tag);
        }
        persistent.func_218657_a(tag, expectedValue);
        return expectedValue;
    }

    public static void setPersistentTag(PlayerEntity player, String tag, INBT value) {
        CompoundNBT persistent;
        CompoundNBT data = player.getPersistentData();
        if (!data.func_74764_b("PlayerPersisted")) {
            persistent = new CompoundNBT();
            data.func_218657_a("PlayerPersisted", (INBT)persistent);
        } else {
            persistent = data.func_74775_l("PlayerPersisted");
        }
        persistent.func_218657_a(tag, value);
    }

    public static void setPersistentBoolean(PlayerEntity player, String tag, boolean value) {
        SuperpositionHandler.setPersistentTag(player, tag, (INBT)ByteNBT.func_229672_a_((boolean)value));
    }

    public static boolean getPersistentBoolean(PlayerEntity player, String tag, boolean expectedValue) {
        INBT theTag = SuperpositionHandler.getPersistentTag(player, tag, (INBT)ByteNBT.func_229672_a_((boolean)expectedValue));
        return theTag instanceof ByteNBT ? ((ByteNBT)theTag).func_150290_f() != 0 : expectedValue;
    }

    public static void setPersistentInteger(PlayerEntity player, String tag, int value) {
        SuperpositionHandler.setPersistentTag(player, tag, (INBT)IntNBT.func_229692_a_((int)value));
    }

    public static int getPersistentInteger(PlayerEntity player, String tag, int expectedValue) {
        INBT theTag = SuperpositionHandler.getPersistentTag(player, tag, (INBT)IntNBT.func_229692_a_((int)expectedValue));
        return theTag instanceof IntNBT ? ((IntNBT)theTag).func_150287_d() : expectedValue;
    }

    public static boolean hasPersistentTag(PlayerEntity player, String tag) {
        CompoundNBT persistent;
        CompoundNBT data = player.getPersistentData();
        if (!data.func_74764_b("PlayerPersisted")) {
            persistent = new CompoundNBT();
            data.func_218657_a("PlayerPersisted", (INBT)persistent);
        } else {
            persistent = data.func_74775_l("PlayerPersisted");
        }
        return persistent.func_74764_b(tag);
    }

    public static boolean hasAdvancement(@Nonnull ServerPlayerEntity player, @Nonnull ResourceLocation location) {
        try {
            if (player.func_192039_O().func_192747_a(player.field_71133_b.func_191949_aK().func_192778_a(location)).func_192105_a()) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public static void grantAdvancement(@Nonnull ServerPlayerEntity player, @Nonnull ResourceLocation location) {
        Advancement adv = player.field_71133_b.func_191949_aK().func_192778_a(location);
        for (String criterion : player.func_192039_O().func_192747_a(adv).func_192107_d()) {
            player.func_192039_O().func_192750_a(adv, criterion);
        }
    }

    public static void revokeAdvancement(@Nonnull ServerPlayerEntity player, @Nonnull ResourceLocation location) {
        Advancement adv = player.field_71133_b.func_191949_aK().func_192778_a(location);
        for (String criterion : player.func_192039_O().func_192747_a(adv).func_192102_e()) {
            player.func_192039_O().func_192744_b(adv, criterion);
        }
    }

    public static String generateRandomWorldNumber() {
        String number = "";
        while (number.length() < 4) {
            number = number.concat("" + random.nextInt(10));
        }
        number = number.concat("-");
        while (number.length() < 7) {
            number = number.concat("" + alphabet[random.nextInt(alphabet.length)]);
        }
        while (number.length() < 9) {
            number = number.concat("" + random.nextInt(10));
        }
        return number;
    }

    public static PlayerEntity getPlayerByName(World world, String name) {
        PlayerEntity player = null;
        for (PlayerEntity checkedPlayer : world.func_217369_A()) {
            if (!checkedPlayer.func_145748_c_().getString().equals(name)) continue;
            player = checkedPlayer;
        }
        return player;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addPotionTooltip(List<EffectInstance> list, ItemStack itemIn, List<ITextComponent> lores, float durationFactor) {
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            lores.add((ITextComponent)new TranslationTextComponent("effect.none").func_240699_a_(TextFormatting.GRAY));
        } else {
            for (EffectInstance effectinstance : list) {
                TranslationTextComponent iformattabletextcomponent = new TranslationTextComponent(effectinstance.func_76453_d());
                Effect effect = effectinstance.func_188419_a();
                Map map = effect.func_111186_k();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), effect.func_111183_a(effectinstance.func_76458_c(), attributemodifier), attributemodifier.func_220375_c());
                        list1.add(new Pair(entry.getKey(), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.func_76458_c() > 0) {
                    iformattabletextcomponent.func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("potion.potency." + effectinstance.func_76458_c()));
                }
                if (effectinstance.func_76459_b() > 20) {
                    iformattabletextcomponent.func_240702_b_(" (").func_240702_b_(EffectUtils.func_188410_a((EffectInstance)effectinstance, (float)durationFactor)).func_240702_b_(")");
                }
                lores.add((ITextComponent)iformattabletextcomponent.func_240699_a_(effect.func_220303_e().func_220306_a()));
            }
        }
        if (!list1.isEmpty()) {
            lores.add(StringTextComponent.field_240750_d_);
            lores.add((ITextComponent)new TranslationTextComponent("potion.whenDrank").func_240699_a_(TextFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.func_111164_d();
                double d1 = attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                if (d0 > 0.0) {
                    lores.add((ITextComponent)new TranslationTextComponent("attribute.modifier.plus." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent(((Attribute)pair.getFirst()).func_233754_c_())}).func_240699_a_(TextFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add((ITextComponent)new TranslationTextComponent("attribute.modifier.take." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TranslationTextComponent(((Attribute)pair.getFirst()).func_233754_c_())}).func_240699_a_(TextFormatting.DARK_RED));
            }
        }
    }

    public static boolean canPickStack(PlayerEntity player, ItemStack stack) {
        if (player.field_71071_by.func_70447_i() >= 0) {
            return true;
        }
        ArrayList allInventories = new ArrayList();
        allInventories.addAll(player.field_71071_by.field_70462_a);
        allInventories.addAll(player.field_71071_by.field_184439_c);
        for (ItemStack invStack : allInventories) {
            if (!SuperpositionHandler.canMergeStacks(invStack, stack, player.field_71071_by.func_70297_j_())) continue;
            return true;
        }
        return false;
    }

    public static boolean canMergeStacks(ItemStack stack1, ItemStack stack2, int invStackLimit) {
        return !stack1.func_190926_b() && SuperpositionHandler.stackEqualExact(stack1, stack2) && stack1.func_77985_e() && stack1.func_190916_E() < stack1.func_77976_d() && stack1.func_190916_E() < invStackLimit;
    }

    public static boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getParticleMultiplier() {
        if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == ParticleStatus.MINIMAL) {
            return 0.35f;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == ParticleStatus.DECREASED) {
            return 0.65f;
        }
        return 1.0f;
    }

    public static boolean isInBeaconRange(PlayerEntity player) {
        ArrayList<BeaconTileEntity> list = new ArrayList<BeaconTileEntity>();
        boolean inRange = false;
        for (TileEntity tile : player.field_70170_p.field_147482_g) {
            if (!(tile instanceof BeaconTileEntity)) continue;
            list.add((BeaconTileEntity)tile);
        }
        if (list.size() > 0) {
            for (BeaconTileEntity beacon : list) {
                if (beacon.func_191979_s() <= 0) continue;
                try {
                    if (beacon.field_174909_f.isEmpty()) {
                        continue;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                int range = (beacon.func_191979_s() + 1) * 10;
                double distance = Math.sqrt(beacon.func_174877_v().func_218140_a(player.func_226277_ct_(), (double)beacon.func_174877_v().func_177956_o(), player.func_226281_cx_(), true));
                if (!(distance <= (double)range)) continue;
                inRange = true;
            }
        }
        return inRange;
    }

    public static boolean hasItem(PlayerEntity player, Item item) {
        return player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)item));
    }

    public static boolean ifDroplistContainsItem(Collection<ItemEntity> drops, Item item) {
        for (ItemEntity drop : drops) {
            if (drop.func_92059_d() == null || drop.func_92059_d().func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldPlayerDropSoulCrystal(PlayerEntity player) {
        int dropMode = OmniconfigHandler.soulCrystalsMode.getValue();
        int maxCrystalLoss = OmniconfigHandler.maxSoulCrystalLoss.getValue();
        boolean hasCursedRing = SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.cursedRing);
        boolean canDropMore = EnigmaticLegacy.soulCrystal.getLostCrystals(player) < maxCrystalLoss;
        boolean keepInventory = player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c);
        if (dropMode == 0) {
            return hasCursedRing && canDropMore;
        }
        if (dropMode == 1) {
            return (hasCursedRing || keepInventory) && canDropMore;
        }
        if (dropMode == 2) {
            return canDropMore;
        }
        return false;
    }

    public static ServerWorld getWorld(RegistryKey<World> key) {
        return ServerLifecycleHooks.getCurrentServer().func_71218_a(key);
    }

    public static ServerWorld getOverworld() {
        return SuperpositionHandler.getWorld(EnigmaticLegacy.proxy.getOverworldKey());
    }

    public static ServerWorld getNether() {
        return SuperpositionHandler.getWorld(EnigmaticLegacy.proxy.getNetherKey());
    }

    public static ServerWorld getEnd() {
        return SuperpositionHandler.getWorld(EnigmaticLegacy.proxy.getEndKey());
    }

    public static ServerWorld backToSpawn(ServerPlayerEntity serverPlayer) {
        ServerWorld destinationWorld;
        RegistryKey<World> respawnDimension = AdvancedSpawnLocationHelper.getPlayerRespawnDimension(serverPlayer);
        ServerWorld respawnWorld = SuperpositionHandler.getWorld(respawnDimension);
        serverPlayer.field_70170_p.func_184133_a(null, serverPlayer.func_233580_cy_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
        EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(serverPlayer.func_226277_ct_(), serverPlayer.func_226278_cu_(), serverPlayer.func_226281_cx_(), 128.0, serverPlayer.field_70170_p.func_234923_W_())), (Object)new PacketPortalParticles(serverPlayer.func_226277_ct_(), serverPlayer.func_226278_cu_() + (double)(serverPlayer.func_213302_cg() / 2.0f), serverPlayer.func_226281_cx_(), 100, 1.25, false));
        Optional<Vector3d> vec = AdvancedSpawnLocationHelper.getValidSpawn(respawnWorld, serverPlayer);
        ServerWorld serverWorld = destinationWorld = vec.isPresent() ? respawnWorld : serverPlayer.field_71133_b.func_241755_D_();
        if (!serverPlayer.func_71121_q().equals(destinationWorld)) {
            serverPlayer.changeDimension(destinationWorld, (ITeleporter)new RealSmoothTeleporter());
        }
        Optional<Object> vec2 = !respawnWorld.equals(destinationWorld) ? AdvancedSpawnLocationHelper.getValidSpawn(destinationWorld, serverPlayer) : Optional.empty();
        if (vec.isPresent()) {
            Vector3d trueVec = vec.get();
            serverPlayer.func_70634_a(trueVec.field_72450_a, trueVec.field_72448_b, trueVec.field_72449_c);
        } else if (vec2.isPresent()) {
            Vector3d trueVec = (Vector3d)vec2.get();
            serverPlayer.func_70634_a(trueVec.field_72450_a, trueVec.field_72448_b, trueVec.field_72449_c);
        } else {
            AdvancedSpawnLocationHelper.fuckBackToSpawn(serverPlayer.func_71121_q(), serverPlayer);
        }
        serverPlayer.field_70170_p.func_184133_a(null, serverPlayer.func_233580_cy_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
        EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(serverPlayer.func_226277_ct_(), serverPlayer.func_226278_cu_(), serverPlayer.func_226281_cx_(), 128.0, serverPlayer.field_70170_p.func_234923_W_())), (Object)new PacketRecallParticles(serverPlayer.func_226277_ct_(), serverPlayer.func_226278_cu_() + (double)(serverPlayer.func_213302_cg() / 2.0f), serverPlayer.func_226281_cx_(), 48, false));
        return destinationWorld;
    }

    public static DimensionalPosition getRespawnPoint(ServerPlayerEntity serverPlayer) {
        Vector3d trueVec;
        RegistryKey<World> respawnDimension = AdvancedSpawnLocationHelper.getPlayerRespawnDimension(serverPlayer);
        ServerWorld respawnWorld = SuperpositionHandler.getWorld(respawnDimension);
        Optional<Vector3d> currentDimensionRespawnCoords = AdvancedSpawnLocationHelper.getValidSpawn(respawnWorld, serverPlayer);
        ServerWorld destinationWorld = currentDimensionRespawnCoords.isPresent() ? respawnWorld : serverPlayer.field_71133_b.func_241755_D_();
        Optional<Object> destinationDimensionRespawnCoords = !respawnWorld.equals(destinationWorld) ? AdvancedSpawnLocationHelper.getValidSpawn(destinationWorld, serverPlayer) : Optional.empty();
        if (currentDimensionRespawnCoords.isPresent()) {
            trueVec = currentDimensionRespawnCoords.get();
        } else if (destinationDimensionRespawnCoords.isPresent()) {
            trueVec = (Vector3d)destinationDimensionRespawnCoords.get();
        } else {
            trueVec = new Vector3d((double)destinationWorld.func_241135_u_().func_177958_n() + 0.5, (double)destinationWorld.func_241135_u_().func_177956_o() + 0.5, (double)destinationWorld.func_241135_u_().func_177952_p() + 0.5);
            while (!destinationWorld.func_180495_p(new BlockPos(trueVec)).isAir((IBlockReader)destinationWorld, new BlockPos(trueVec)) && trueVec.field_72448_b < 255.0) {
                trueVec = trueVec.func_72441_c(0.0, 1.0, 0.0);
            }
        }
        return new DimensionalPosition(trueVec.field_72450_a, trueVec.field_72448_b, trueVec.field_72449_c, (World)destinationWorld);
    }

    public static void removeAttributeMap(PlayerEntity player, Multimap<Attribute, AttributeModifier> attributes) {
        AttributeModifierManager map = player.func_233645_dx_();
        map.func_233785_a_(attributes);
    }

    public static void applyAttributeMap(PlayerEntity player, Multimap<Attribute, AttributeModifier> attributes) {
        AttributeModifierManager map = player.func_233645_dx_();
        map.func_233793_b_(attributes);
    }

    public static boolean isTheCursedOne(PlayerEntity player) {
        return SuperpositionHandler.hasCurio((LivingEntity)player, EnigmaticLegacy.cursedRing);
    }

    public static float getMissingHealthPool(PlayerEntity player) {
        return (player.func_110138_aP() - player.func_110143_aJ()) / player.func_110138_aP();
    }

    public static int getCurseAmount(ItemStack stack) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        int totalCurses = 0;
        for (Enchantment enchantment : enchantments.keySet()) {
            if (!enchantment.func_190936_d() || (Integer)enchantments.get(enchantment) <= 0) continue;
            ++totalCurses;
        }
        if (stack.func_77973_b() == EnigmaticLegacy.cursedRing) {
            totalCurses += 7;
        }
        return totalCurses;
    }

    public static int getCurseAmount(PlayerEntity player) {
        int count = 0;
        for (ItemStack theStack : SuperpositionHandler.getFullEquipment(player)) {
            if (theStack == null) continue;
            count += SuperpositionHandler.getCurseAmount(theStack);
        }
        return count;
    }

    public static List<ItemStack> getFullEquipment(PlayerEntity player) {
        ArrayList equipmentStacks = Lists.newArrayList();
        equipmentStacks.add(player.func_184614_ca());
        equipmentStacks.add(player.func_184592_cb());
        equipmentStacks.addAll(player.field_71071_by.field_70460_b);
        if (CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).orElse(null);
            Map curios = handler.getCurios();
            for (Map.Entry entry : curios.entrySet()) {
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    equipmentStacks.add(stack);
                }
            }
        }
        return equipmentStacks;
    }

    public static double sinFunction(double lowerBound, double upperBound, double value) {
        double range = upperBound - lowerBound;
        double coef = value / range;
        coef *= 90.0;
        coef = Math.toRadians(coef);
        double func = Math.pow(Math.sin(coef), -1.0);
        return Math.pow(Math.sin(coef), -1.0);
    }

    public static double parabolicFunction(double lowerBound, double upperBound, double value) {
        double range = upperBound - lowerBound;
        double coef = value / range;
        double func = Math.pow(coef, 2.0);
        return func;
    }

    public static double flippedParabolicFunction(double lowerBound, double upperBound, double value) {
        double range = upperBound - lowerBound;
        double coef = value / range;
        double func = Math.pow(coef - 1.0, 2.0);
        return 1.0 - func;
    }

    public static boolean hasAnyArmor(LivingEntity entity) {
        int armorAmount = 0;
        for (ItemStack stack : entity.func_184193_aE()) {
            if (stack.func_190926_b()) continue;
            ++armorAmount;
        }
        return armorAmount != 0;
    }

    public static boolean areWeDedicatedServer() {
        return FMLEnvironment.dist == Dist.DEDICATED_SERVER;
    }

    public static boolean areWeRemoteServer(PlayerEntity player) {
        if (SuperpositionHandler.areWeDedicatedServer()) {
            return true;
        }
        return player.func_184102_h() != null && !player.func_184102_h().func_213199_b(player.func_146103_bH());
    }

    public static void executeOnServer(Consumer<MinecraftServer> action) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            action.accept(ServerLifecycleHooks.getCurrentServer());
        }
    }

    public static List<ModFileScanData.AnnotationData> retainAnnotations(String modid, Class<?> annotationClass) {
        ModFileScanData modFileInfo = ModList.get().getModFileById(modid).getFile().getScanResult();
        ArrayList<ModFileScanData.AnnotationData> list = new ArrayList<ModFileScanData.AnnotationData>();
        for (ModFileScanData.AnnotationData annotation : modFileInfo.getAnnotations()) {
            if (!annotation.getAnnotationType().getClassName().equals(annotationClass.getName())) continue;
            list.add(annotation);
        }
        return list;
    }

    public static List<ModFileScanData.AnnotationData> retainConfigurableItemAnnotations(String modid) {
        return SuperpositionHandler.retainAnnotations(modid, ConfigurableItem.class);
    }

    public static List<ModFileScanData.AnnotationData> retainConfigHolderAnnotations(String modid) {
        return SuperpositionHandler.retainAnnotations(modid, SubscribeConfig.class);
    }

    public static void dispatchWrapperToHolders(String modid, OmniconfigWrapper wrapper) {
        for (ModFileScanData.AnnotationData annotationData : SuperpositionHandler.retainConfigHolderAnnotations(modid)) {
            try {
                Class<?> retainerClass = Class.forName(annotationData.getClassType().getClassName());
                String methodName = annotationData.getMemberName().split("\\(")[0];
                boolean receiveClient = annotationData.getAnnotationData().get("receiveClient") != null ? (Boolean)annotationData.getAnnotationData().get("receiveClient") : false;
                Method method = retainerClass.getDeclaredMethod(methodName, OmniconfigWrapper.class);
                if (wrapper.config.getSidedType() == Configuration.SidedConfigType.CLIENT && !receiveClient) continue;
                method.invoke(null, wrapper);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static Multimap<String, Field> retainAccessibilityGeneratorMap(String modid) {
        HashMultimap accessibilityGeneratorMap = HashMultimap.create();
        for (ModFileScanData.AnnotationData annotationData : SuperpositionHandler.retainConfigurableItemAnnotations(modid)) {
            try {
                Class<?> retainerClass = Class.forName(annotationData.getClassType().getClassName());
                String itemName = (String)annotationData.getAnnotationData().get("value");
                String fieldName = annotationData.getMemberName();
                Field field = retainerClass.getDeclaredField(fieldName);
                if (itemName.isEmpty()) continue;
                accessibilityGeneratorMap.put((Object)itemName, (Object)field);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return accessibilityGeneratorMap;
    }

    public static boolean hasAntiInsectAcknowledgement(PlayerEntity player) {
        ArrayList heldItems = Lists.newArrayList((Object[])new ItemStack[]{player.func_184614_ca(), player.func_184592_cb()});
        for (ItemStack held : heldItems) {
            if (held == null || !(held.func_77973_b() instanceof TheAcknowledgment) || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180312_n, (ItemStack)held) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isStaringAt(PlayerEntity player, LivingEntity living) {
        Vector3d vector3d = player.func_70676_i(1.0f).func_72432_b();
        Vector3d vector3d1 = new Vector3d(living.func_226277_ct_() - player.func_226277_ct_(), living.func_226280_cw_() - player.func_226280_cw_(), living.func_226281_cx_() - player.func_226281_cx_());
        double d0 = vector3d1.func_72433_c();
        double d1 = vector3d.func_72430_b(vector3d1 = vector3d1.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? player.func_70685_l((Entity)living) : false;
    }

    public static double getRandomNegative() {
        return (Math.random() - 0.5) * 2.0;
    }

    public static String minimizeNumber(double num) {
        int intg = (int)num;
        if (num - (double)intg == 0.0) {
            return "" + intg;
        }
        return "" + num;
    }

    public static ItemStack mergeEnchantments(ItemStack input, ItemStack mergeFrom, boolean overmerge, boolean onlyTreasure) {
        ItemStack returnedStack = input.func_77946_l();
        Map inputEnchants = EnchantmentHelper.func_82781_a((ItemStack)returnedStack);
        Map mergedEnchants = EnchantmentHelper.func_82781_a((ItemStack)mergeFrom);
        for (Enchantment mergedEnchant : mergedEnchants.keySet()) {
            if (mergedEnchant == null) continue;
            int inputEnchantLevel = inputEnchants.getOrDefault(mergedEnchant, 0);
            int mergedEnchantLevel = (Integer)mergedEnchants.get(mergedEnchant);
            if (!overmerge) {
                mergedEnchantLevel = inputEnchantLevel == mergedEnchantLevel ? (mergedEnchantLevel + 1 > mergedEnchant.func_77325_b() ? mergedEnchant.func_77325_b() : mergedEnchantLevel + 1) : Math.max(mergedEnchantLevel, inputEnchantLevel);
            } else {
                mergedEnchantLevel = inputEnchantLevel > 0 ? Math.max(mergedEnchantLevel, inputEnchantLevel) + 1 : Math.max(mergedEnchantLevel, inputEnchantLevel);
                mergedEnchantLevel = Math.min(mergedEnchantLevel, 10);
            }
            boolean compatible = mergedEnchant.func_92089_a(input);
            if (input.func_77973_b() instanceof EnchantedBookItem) {
                compatible = true;
            }
            for (Enchantment originalEnchant : inputEnchants.keySet()) {
                if (originalEnchant == mergedEnchant || mergedEnchant.func_191560_c(originalEnchant)) continue;
                compatible = false;
            }
            if (!compatible || onlyTreasure && !mergedEnchant.func_185261_e() && !mergedEnchant.func_190936_d()) continue;
            inputEnchants.put(mergedEnchant, mergedEnchantLevel);
        }
        EnchantmentHelper.func_82782_a((Map)inputEnchants, (ItemStack)returnedStack);
        return returnedStack;
    }
}

