/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.helpers;

import com.google.common.collect.Sets;
import com.integral.enigmaticlegacy.items.generic.ItemBase;
import com.integral.enigmaticlegacy.objects.Vector3;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AOEMiningHelper {
    public static final Random random = new Random();

    public static void attemptBreakNeighbors(World world, BlockPos pos, PlayerEntity player, Set<Block> effectiveOn, Set<Material> effectiveMaterials, boolean checkHarvestLevel) {
        BlockRayTraceResult trace = AOEMiningHelper.calcRayTrace(world, player, RayTraceContext.FluidMode.ANY);
        if (trace.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockTrace = trace;
            Direction face = blockTrace.func_216354_b();
            int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca());
            int silkLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca());
            for (int a = -1; a <= 1; ++a) {
                for (int b = -1; b <= 1; ++b) {
                    if (a == 0 && b == 0) continue;
                    BlockPos target = null;
                    if (face == Direction.UP || face == Direction.DOWN) {
                        target = pos.func_177982_a(a, 0, b);
                    }
                    if (face == Direction.NORTH || face == Direction.SOUTH) {
                        target = pos.func_177982_a(a, b, 0);
                    }
                    if (face == Direction.EAST || face == Direction.WEST) {
                        target = pos.func_177982_a(0, a, b);
                    }
                    AOEMiningHelper.attemptBreak(world, target, player, effectiveOn, effectiveMaterials, fortuneLevel, silkLevel, checkHarvestLevel, null, (objPos, objState) -> {});
                }
            }
        }
    }

    public static void attemptBreak(World world, BlockPos pos, PlayerEntity player, Set<Block> effectiveOn, Set<Material> effectiveMaterials, int fortuneLevel, int silkLevel, boolean checkHarvestLevel, ItemStack tool, BiConsumer<BlockPos, BlockState> toolDamageConsumer) {
        BlockState state = world.func_180495_p(pos);
        TileEntity iCertainlyHopeYouHaveATileEntityLicense = world.func_175625_s(pos);
        boolean validHarvest = !checkHarvestLevel || player.func_184614_ca().func_150998_b(state);
        boolean isEffective = effectiveOn.contains(state.func_177230_c()) || effectiveMaterials.contains(state.func_185904_a());
        boolean witherImmune = BlockTags.field_219755_X.func_230235_a_((Object)state.func_177230_c());
        if (validHarvest && isEffective && !witherImmune) {
            world.func_175655_b(pos, false);
            Block.func_220054_a((BlockState)state, (World)world, (BlockPos)pos, (TileEntity)iCertainlyHopeYouHaveATileEntityLicense, (Entity)player, (ItemStack)player.func_184614_ca());
            toolDamageConsumer.accept(pos, state);
            int exp = state.getExpDrop((IWorldReader)world, pos, fortuneLevel, silkLevel);
            if (exp > 0 && world instanceof ServerWorld) {
                state.func_177230_c().func_180637_b((ServerWorld)world, pos, exp);
            }
        }
    }

    public static BlockRayTraceResult calcRayTrace(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        return ItemBase.rayTrace(worldIn, player, fluidMode);
    }

    public static Vector3 calcRayTrace(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode, double distance) {
        float f7;
        float f5;
        double d0;
        float f4;
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vector3d vector3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f6 = f3 * (f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180))));
        Vector3d vector3d1 = vector3d.func_72441_c((double)f6 * (d0 = distance), (double)(f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)))) * d0, (double)(f7 = f2 * f4) * d0);
        BlockRayTraceResult result = worldIn.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            return new Vector3(result.func_216347_e());
        }
        Vector3 vec = new Vector3(player.func_70040_Z()).multiply(64.0).add(new Vector3(player.func_213303_ch()));
        return vec;
    }

    public static void harvestPlane(World world, PlayerEntity player, Direction dir, BlockPos pos, Set<Material> effectiveMaterials, int radius, boolean harvestLevelCheck, @Nullable BlockPos excludedBlock, ItemStack tool, BiConsumer<BlockPos, BlockState> toolDamageConsumer) {
        int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca());
        int silkLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca());
        int supRad = (radius - 1) / 2;
        for (int a = -supRad; a <= supRad; ++a) {
            for (int b = -supRad; b <= supRad; ++b) {
                BlockPos target = null;
                if (dir == Direction.UP || dir == Direction.DOWN) {
                    target = pos.func_177982_a(a, 0, b);
                }
                if (dir == Direction.NORTH || dir == Direction.SOUTH) {
                    target = pos.func_177982_a(a, b, 0);
                }
                if (dir == Direction.EAST || dir == Direction.WEST) {
                    target = pos.func_177982_a(0, a, b);
                }
                if (excludedBlock != null && target != null && target.equals((Object)excludedBlock)) continue;
                AOEMiningHelper.attemptBreak(world, target, player, Sets.newHashSet(), effectiveMaterials, fortuneLevel, silkLevel, harvestLevelCheck, tool, toolDamageConsumer);
            }
        }
    }

    public static void harvestCube(World world, PlayerEntity player, Direction dir, BlockPos centralPos, Set<Material> effectiveMaterials, int planeRadius, int depth, boolean harvestLevelCheck, @Nullable BlockPos excludedBlock, ItemStack tool, BiConsumer<BlockPos, BlockState> toolDamageConsumer) {
        for (int a = 0; a < depth; ++a) {
            int x = 0;
            int y = 0;
            int z = 0;
            if (dir == Direction.UP) {
                y -= a;
            }
            if (dir == Direction.DOWN) {
                y += a;
            }
            if (dir == Direction.SOUTH) {
                z -= a;
            }
            if (dir == Direction.NORTH) {
                z += a;
            }
            if (dir == Direction.EAST) {
                x -= a;
            }
            if (dir == Direction.WEST) {
                x += a;
            }
            AOEMiningHelper.harvestPlane(world, player, dir, new BlockPos((Vector3i)centralPos).func_177982_a(x, y, z), effectiveMaterials, planeRadius, harvestLevelCheck, excludedBlock, tool, toolDamageConsumer);
        }
    }
}

