/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.helpers;

import com.integral.enigmaticlegacy.enchantments.CeaselessEnchantment;
import com.integral.enigmaticlegacy.helpers.EnigmaticEnchantmentHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class CrossbowHelper {
    public static final String sharpshooterTagPrefix = "enigmaticlegacy:sharpshot:";

    public static boolean tryCharge(LivingEntity living, ItemStack crossbow, ItemStack ammo, boolean bonusCycles, boolean isCreative) {
        ItemStack itemstack;
        boolean creativeUsingArrows;
        if (ammo.func_190926_b()) {
            return false;
        }
        boolean bl = creativeUsingArrows = isCreative && ammo.func_77973_b() instanceof ArrowItem;
        if (!(creativeUsingArrows || isCreative || bonusCycles)) {
            itemstack = ammo.func_77979_a(1);
            if (ammo.func_190926_b() && living instanceof PlayerEntity) {
                ((PlayerEntity)living).field_71071_by.func_184437_d(ammo);
            }
        } else {
            itemstack = ammo.func_77946_l();
        }
        CrossbowItem.func_220029_b((ItemStack)crossbow, (ItemStack)itemstack);
        return true;
    }

    public static boolean hasAmmo(LivingEntity entityIn, ItemStack weaponStack) {
        int requestedAmmo = 1;
        boolean isCreative = entityIn instanceof PlayerEntity && ((PlayerEntity)entityIn).field_71075_bZ.field_75098_d;
        ItemStack itemstack = entityIn.func_213356_f(weaponStack);
        ItemStack itemstack1 = itemstack.func_77946_l();
        for (int k = 0; k < requestedAmmo; ++k) {
            if (k > 0) {
                itemstack = itemstack1.func_77946_l();
            }
            if (itemstack.func_190926_b() && (isCreative || EnigmaticEnchantmentHelper.hasCeaselessEnchantment(weaponStack) && CeaselessEnchantment.allowNoArrow.getValue())) {
                itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
                itemstack1 = itemstack.func_77946_l();
            }
            if (CrossbowHelper.tryCharge(entityIn, weaponStack, itemstack.func_77973_b().getClass() == ArrowItem.class && EnigmaticEnchantmentHelper.hasCeaselessEnchantment(weaponStack) ? itemstack.func_77946_l() : itemstack, k > 0, isCreative)) continue;
            return false;
        }
        return true;
    }

    public static void fireProjectiles(World worldIn, LivingEntity shooter, Hand handIn, ItemStack stack, float velocityIn, float inaccuracyIn) {
        List list = CrossbowItem.func_220018_j((ItemStack)stack);
        float[] afloat = CrossbowItem.func_220028_a((Random)shooter.func_70681_au());
        for (int i = 0; i < list.size(); ++i) {
            boolean flag;
            ItemStack itemstack = (ItemStack)list.get(i);
            boolean bl = flag = shooter instanceof PlayerEntity && ((PlayerEntity)shooter).field_71075_bZ.field_75098_d;
            if (itemstack.func_190926_b()) continue;
            if (i == 0) {
                CrossbowHelper.fireProjectile(worldIn, shooter, handIn, stack, itemstack, afloat[i], flag, velocityIn, inaccuracyIn, 0.0f);
                continue;
            }
            if (i == 1) {
                CrossbowHelper.fireProjectile(worldIn, shooter, handIn, stack, itemstack, afloat[i], flag, velocityIn, inaccuracyIn, -10.0f);
                continue;
            }
            if (i != 2) continue;
            CrossbowHelper.fireProjectile(worldIn, shooter, handIn, stack, itemstack, afloat[i], flag, velocityIn, inaccuracyIn, 10.0f);
        }
        CrossbowItem.func_220015_a((World)worldIn, (LivingEntity)shooter, (ItemStack)stack);
    }

    private static void fireProjectile(World worldIn, LivingEntity shooter, Hand handIn, ItemStack crossbow, ItemStack projectile, float soundPitch, boolean isCreativeMode, float velocity, float inaccuracy, float projectileAngle) {
        if (!worldIn.field_72995_K) {
            AbstractArrowEntity projectileentity;
            boolean flag;
            boolean bl = flag = projectile.func_77973_b() == Items.field_196152_dE;
            if (flag) {
                projectileentity = new FireworkRocketEntity(worldIn, projectile, (Entity)shooter, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.15f, shooter.func_226281_cx_(), true);
            } else {
                projectileentity = CrossbowItem.func_220024_a((World)worldIn, (LivingEntity)shooter, (ItemStack)crossbow, (ItemStack)projectile);
                if (isCreativeMode || projectileAngle != 0.0f || EnigmaticEnchantmentHelper.hasCeaselessEnchantment(crossbow)) {
                    projectileentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                }
                if (EnigmaticEnchantmentHelper.hasSharpshooterEnchantment(crossbow)) {
                    projectileentity.func_184211_a(sharpshooterTagPrefix + EnigmaticEnchantmentHelper.getSharpshooterLevel(crossbow));
                }
            }
            if (shooter instanceof ICrossbowUser) {
                ICrossbowUser icrossbowuser = (ICrossbowUser)shooter;
                icrossbowuser.func_230284_a_(icrossbowuser.func_70638_az(), crossbow, (ProjectileEntity)projectileentity, projectileAngle);
            } else {
                Vector3d vector3d1 = shooter.func_213286_i(1.0f);
                Quaternion quaternion = new Quaternion(new Vector3f(vector3d1), projectileAngle, true);
                Vector3d vector3d = shooter.func_70676_i(1.0f);
                Vector3f vector3f = new Vector3f(vector3d);
                vector3f.func_214905_a(quaternion);
                projectileentity.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), velocity, inaccuracy);
            }
            crossbow.func_222118_a(flag ? 3 : 1, shooter, p_220017_1_ -> p_220017_1_.func_213334_d(handIn));
            worldIn.func_217376_c((Entity)projectileentity);
            worldIn.func_184148_a((PlayerEntity)null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, soundPitch);
        }
    }
}

