/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.entities.UltimateWitherSkullEntity;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemSpellstoneCurio;
import com.integral.enigmaticlegacy.objects.Vector3;
import com.integral.enigmaticlegacy.packets.clients.PacketPlayerMotion;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class AngelBlessing
extends ItemSpellstoneCurio {
    public static Omniconfig.IntParameter spellstoneCooldown;
    public static Omniconfig.DoubleParameter accelerationModifier;
    public static Omniconfig.DoubleParameter accelerationModifierElytra;
    public static Omniconfig.PerhapsParameter deflectChance;
    protected double range = 4.0;

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("AngelBlessing");
        spellstoneCooldown = builder.comment("Active ability cooldown for Angel's Blessing. Measured in ticks. 20 ticks equal to 1 second.").getInt("Cooldown", 40);
        accelerationModifier = builder.comment("Acceleration modifier for active ability of Angel's Blessing. The greater it is, the more momentum you will gain.").max(256.0).getDouble("AccelerationModifier", 1.0);
        accelerationModifierElytra = builder.comment("Separate acceleration modifier for active ability of Angel's Blessing when player is flying with Elytra.").max(256.0).getDouble("AccelerationModifierElytra", 0.6);
        deflectChance = builder.comment("Chance to deflect projectile when having Angel's Blessing equipped. Measured in percents.").max(100.0).getPerhaps("DeflectChance", 50);
        builder.popPrefix();
    }

    public AngelBlessing() {
        super(ItemSpellstoneCurio.getDefaultProperties().func_208103_a(Rarity.RARE));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "angel_blessing"));
        this.immunityList.add(DamageSource.field_76379_h.field_76373_n);
        this.immunityList.add(DamageSource.field_188406_j.field_76373_n);
        this.resistanceList.put(DamageSource.field_82727_n.field_76373_n, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageSource.field_76380_i.field_76373_n, () -> Float.valueOf(2.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessing1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessing2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessingCooldown", TextFormatting.GOLD, Float.valueOf((float)spellstoneCooldown.getValue() / 20.0f));
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessing3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessing4");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessing5", TextFormatting.GOLD, deflectChance.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessing6");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.angelBlessing7");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", TextFormatting.LIGHT_PURPLE, ((ITextComponent)KeyBinding.func_193626_b((String)"key.spellstoneAbility").get()).getString().toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void triggerActiveAbility(World world, ServerPlayerEntity player, ItemStack stack) {
        if (SuperpositionHandler.hasSpellstoneCooldown((PlayerEntity)player)) {
            return;
        }
        Vector3 accelerationVec = new Vector3(player.func_70040_Z());
        Vector3 motionVec = new Vector3(player.func_213322_ci());
        if (player.func_184613_cA()) {
            accelerationVec = accelerationVec.multiply(accelerationModifierElytra.getValue());
            accelerationVec = accelerationVec.multiply(1.0 / (Math.max(0.15, motionVec.mag()) * 2.25));
        } else {
            accelerationVec = accelerationVec.multiply(accelerationModifier.getValue());
        }
        Vector3 finalMotion = new Vector3(motionVec.x + accelerationVec.x, motionVec.y + accelerationVec.y, motionVec.z + accelerationVec.z);
        EnigmaticLegacy.packetInstance.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketPlayerMotion(finalMotion.x, finalMotion.y, finalMotion.z));
        player.func_213293_j(finalMotion.x, finalMotion.y, finalMotion.z);
        world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187528_aR, SoundCategory.PLAYERS, 1.0f, (float)((double)0.6f + Math.random() * 0.1));
        SuperpositionHandler.setSpellstoneCooldown((PlayerEntity)player, spellstoneCooldown.getValue());
    }

    @Override
    public void curioTick(String identifier, int index, LivingEntity living, ItemStack stack) {
    }

    public void redirect(LivingEntity bearer, Entity redirected) {
        if (redirected instanceof UltimateWitherSkullEntity || redirected instanceof WitherSkullEntity) {
            return;
        }
        Vector3 entityPos = Vector3.fromEntityCenter(redirected);
        Vector3 bearerPos = Vector3.fromEntityCenter((Entity)bearer);
        Vector3 redirection = entityPos.subtract(bearerPos);
        redirection = redirection.normalize();
        if (redirected instanceof AbstractArrowEntity && ((AbstractArrowEntity)redirected).func_234616_v_() == bearer) {
            if (redirected instanceof TridentEntity) {
                TridentEntity trident = (TridentEntity)redirected;
                if (trident.field_203052_f > 0) {
                    return;
                }
            }
            redirected.func_213293_j(redirected.func_213322_ci().field_72450_a * 1.75, redirected.func_213322_ci().field_72448_b * 1.75, redirected.func_213322_ci().field_72449_c * 1.75);
        } else {
            redirected.func_213293_j(redirection.x, redirection.y, redirection.z);
        }
        if (redirected instanceof DamagingProjectileEntity) {
            DamagingProjectileEntity redirectedProjectile = (DamagingProjectileEntity)redirected;
            redirectedProjectile.field_70232_b = redirection.x / 4.0;
            redirectedProjectile.field_70233_c = redirection.y / 4.0;
            redirectedProjectile.field_70230_d = redirection.z / 4.0;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canRender(String identifier, int index, LivingEntity living, ItemStack stack) {
        return false;
    }
}

