/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.api.items.ICursed;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BerserkEmblem
extends ItemBaseCurio
implements ICursed {
    public static Omniconfig.DoubleParameter attackDamage;
    public static Omniconfig.DoubleParameter attackSpeed;
    public static Omniconfig.DoubleParameter movementSpeed;
    public static Omniconfig.DoubleParameter damageResistance;

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("BerserkEmblem");
        attackDamage = builder.comment("Damage increase provided by Emblem of Bloodstained Valor for each missing percent of health. Measured as percentage.").getDouble("DamageBoost", 1.0);
        attackSpeed = builder.comment("Attack speed increase provided by Emblem of Bloodstained Valor for each missing percent of health. Measured as percentage.").getDouble("AttackSpeedBoost", 1.0);
        movementSpeed = builder.comment("Movement speed increase provided by Emblem of Bloodstained Valor for each missing percent of health. Measured as percentage.").getDouble("SpeedBoost", 0.5);
        damageResistance = builder.comment("Damage resistance provided by Emblem of Bloodstained Valor for each missing percent of health. Measured as percentage.").getDouble("ResistanceBoost", 0.5);
        builder.popPrefix();
    }

    public BerserkEmblem() {
        super(ItemBaseCurio.getDefaultProperties().func_208103_a(Rarity.EPIC));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "berserk_emblem"));
    }

    private Multimap<Attribute, AttributeModifier> createAttributeMap(PlayerEntity player) {
        HashMultimap attributesDefault = HashMultimap.create();
        float missingHealthPool = SuperpositionHandler.getMissingHealthPool(player);
        attributesDefault.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(UUID.fromString("ec62548c-5b26-401e-83fd-693e4aafa532"), "enigmaticlegacy:attack_speed_modifier", (double)missingHealthPool * attackSpeed.getValue(), AttributeModifier.Operation.MULTIPLY_BASE));
        attributesDefault.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(UUID.fromString("f4ece564-d2c0-40d2-a96a-dc68b493137c"), "enigmaticlegacy:speed_modifier", (double)missingHealthPool * movementSpeed.getValue(), AttributeModifier.Operation.MULTIPLY_BASE));
        return attributesDefault;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.berserk_emblem1", TextFormatting.GOLD, BerserkEmblem.minimizeNumber(attackDamage.getValue()) + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.berserk_emblem2", TextFormatting.GOLD, BerserkEmblem.minimizeNumber(attackSpeed.getValue()) + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.berserk_emblem3", TextFormatting.GOLD, BerserkEmblem.minimizeNumber(movementSpeed.getValue()) + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.berserk_emblem4", TextFormatting.GOLD, BerserkEmblem.minimizeNumber(damageResistance.getValue()) + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.berserk_emblem5");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.berserk_emblem6");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        if (Minecraft.func_71410_x().field_71439_g != null && SuperpositionHandler.getCurioStack((LivingEntity)Minecraft.func_71410_x().field_71439_g, this) == stack) {
            float missingPool = SuperpositionHandler.getMissingHealthPool((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
            int percentage = (int)(missingPool * 100.0f);
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.berserk_emblem7");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.berserk_emblem8", TextFormatting.GOLD, BerserkEmblem.minimizeNumber(attackDamage.getValue() * (double)percentage) + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.berserk_emblem9", TextFormatting.GOLD, BerserkEmblem.minimizeNumber(attackSpeed.getValue() * (double)percentage) + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.berserk_emblem10", TextFormatting.GOLD, BerserkEmblem.minimizeNumber(movementSpeed.getValue() * (double)percentage) + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.berserk_emblem11", TextFormatting.GOLD, BerserkEmblem.minimizeNumber(damageResistance.getValue() * (double)percentage) + "%");
        }
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        ItemLoreHelper.indicateCursedOnesOnly(list);
    }

    @Override
    public void curioTick(String identifier, int index, LivingEntity living, ItemStack stack) {
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            living.func_233645_dx_().func_233793_b_(this.createAttributeMap(player));
        }
    }

    @Override
    public void onUnequip(String identifier, int index, LivingEntity living, ItemStack stack) {
        if (living instanceof PlayerEntity) {
            living.func_233645_dx_().func_233785_a_(this.createAttributeMap((PlayerEntity)living));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canRender(String identifier, int index, LivingEntity living, ItemStack stack) {
        return false;
    }

    @Override
    public boolean canEquip(String identifier, LivingEntity living, ItemStack stack) {
        return super.canEquip(identifier, living, stack) && living instanceof PlayerEntity && SuperpositionHandler.isTheCursedOne((PlayerEntity)living);
    }
}

