/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.integral.omniconfig.Configuration;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnderRing
extends ItemBaseCurio {
    public static Omniconfig.BooleanParameter inventoryButtonEnabled;
    public static Omniconfig.IntParameter buttonOffsetX;
    public static Omniconfig.IntParameter buttonOffsetY;
    public static Omniconfig.IntParameter buttonOffsetXCreative;
    public static Omniconfig.IntParameter buttonOffsetYCreative;

    @SubscribeConfig(receiveClient=true)
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("EnderChest");
        if (builder.config.getSidedType() == Configuration.SidedConfigType.CLIENT) {
            inventoryButtonEnabled = builder.comment("Whether or not button for accessing Ender Chest should be added to inventory GUI when player has Ring of Ender equipped.").getBoolean("ButtonEnabled", true);
            buttonOffsetX = builder.comment("Allows to set offset for Ender Chest button on X axis.").minMax(32768.0).getInt("ButtonOffsetX", 0);
            buttonOffsetY = builder.comment("Allows to set offset for Ender Chest button on Y axis.").minMax(32768.0).getInt("ButtonOffsetY", 0);
            buttonOffsetXCreative = builder.comment("Allows to set offset for Ender Chest button on X axis, for creative inventory specifically.").minMax(32768.0).getInt("ButtonOffsetXCreative", 0);
            buttonOffsetYCreative = builder.comment("Allows to set offset for Ender Chest button on Y axis, for creative inventory specifically.").minMax(32768.0).getInt("ButtonOffsetYCreative", 0);
        }
        builder.popPrefix();
    }

    public EnderRing() {
        super(ItemBaseCurio.getDefaultProperties().func_208103_a(Rarity.UNCOMMON));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "ender_ring"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enderRing1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enderRing2");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", TextFormatting.LIGHT_PURPLE, ((ITextComponent)KeyBinding.func_193626_b((String)"key.enderRing").get()).getString().toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canRender(String identifier, int index, LivingEntity living, ItemStack stack) {
        return false;
    }
}

