/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

public class EnigmaticAmulet
extends ItemBaseCurio {
    public static Omniconfig.DoubleParameter damageBonus;
    public static Omniconfig.BooleanParameter vesselEnabled;
    public static Omniconfig.BooleanParameter ownerOnlyVessel;
    public static Omniconfig.BooleanParameter seededColorGen;
    public static Omniconfig.BooleanParameter multiequip;
    public static final String amuletColorTag = "AssignedColor";
    public static final String amuletInscriptionTag = "Inscription";

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("EnigmaticAmulet");
        damageBonus = builder.comment("The damage bonus stat provided by red Enigmatic Amulet.").minMax(32768.0).getDouble("DamageBonus", 1.5);
        vesselEnabled = builder.comment("Whether or not Enigmatic Amulet should be summoning Extradimensional Vessel on owner's death.").getBoolean("VesselEnabled", true);
        ownerOnlyVessel = builder.comment("If true, only original owner of Extradimensional Vessel will be able to pick it up.").getBoolean("OwnerOnlyVessel", false);
        seededColorGen = builder.comment("If true, color of Enigmatic Amulet will be assigned using player's name as seed for generating it, instead of randomly - so that every player will always receive one specific color.").getBoolean("SeededColorGen", false);
        multiequip = builder.comment("Whether or not it should be possible to equip multiple Enigmatic Amulets, granted player somehow gets more than one charm slot.").getBoolean("Multiequip", false);
        builder.popPrefix();
    }

    private AmuletColor evaluateColor(float colorVar) {
        float var = (float)((int)(colorVar * 10.0f)) / 10.0f;
        for (AmuletColor color : AmuletColor.values()) {
            if (var != color.colorVar) continue;
            return color;
        }
        return AmuletColor.RED;
    }

    public boolean ifHasColor(PlayerEntity player, AmuletColor color) {
        ItemStack enigmaticAmulet = SuperpositionHandler.getCurioStack((LivingEntity)player, EnigmaticLegacy.enigmaticAmulet);
        return enigmaticAmulet != null && EnigmaticLegacy.enigmaticAmulet.getColor(enigmaticAmulet) == color;
    }

    public AmuletColor getColor(ItemStack amulet) {
        return this.evaluateColor(ItemNBTHelper.getFloat(amulet, amuletColorTag, 0.0f));
    }

    public ItemStack setColor(ItemStack amulet, AmuletColor color) {
        if (amulet != null && amulet.func_77973_b().equals(this)) {
            ItemNBTHelper.setFloat(amulet, amuletColorTag, color.colorVar);
        }
        return amulet;
    }

    public ItemStack setRandomColor(ItemStack amulet) {
        if (amulet != null && amulet.func_77973_b().equals(this)) {
            ItemNBTHelper.setFloat(amulet, amuletColorTag, AmuletColor.getRandomColor().colorVar);
        }
        return amulet;
    }

    public ItemStack setSeededColor(ItemStack amulet) {
        if (amulet != null && amulet.func_77973_b().equals(this)) {
            String name = ItemNBTHelper.getString(amulet, amuletInscriptionTag, "Herobrine");
            long hash = name.hashCode();
            ItemNBTHelper.setFloat(amulet, amuletColorTag, AmuletColor.getSeededColor(new Random(hash)).colorVar);
        }
        return amulet;
    }

    public ItemStack setInscription(ItemStack amulet, String name) {
        if (amulet != null && amulet.func_77973_b().equals(this)) {
            ItemNBTHelper.setString(amulet, amuletInscriptionTag, name);
        }
        return amulet;
    }

    public EnigmaticAmulet() {
        super(ItemBaseCurio.getDefaultProperties().func_208103_a(Rarity.UNCOMMON).func_234689_a_());
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "enigmatic_amulet"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerVariants() {
        ItemModelsProperties.func_239418_a_((Item)this, (ResourceLocation)new ResourceLocation("enigmaticlegacy", "enigmatic_amulet_color"), (stack, world, entity) -> ItemNBTHelper.getFloat(stack, amuletColorTag, 0.0f));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == EnigmaticLegacy.enigmaticTab) {
            for (AmuletColor color : AmuletColor.values()) {
                items.add((Object)this.setColor(new ItemStack((IItemProvider)this), color));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        String name = ItemNBTHelper.getString(stack, amuletInscriptionTag, null);
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.func_231173_s_() && this.isVesselEnabled()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticAmuletShift1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticAmuletShift2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticAmuletShift3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticAmuletShift4");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticAmuletShift5");
        } else {
            if (this.isVesselEnabled()) {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            }
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticAmulet1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticAmulet2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticAmulet3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticAmulet4");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticAmulet5");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticAmulet6");
            if (name != null) {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticAmuletInscription", TextFormatting.DARK_RED, name);
            }
        }
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        ItemLoreHelper.addLocalizedFormattedString(list, "curios.modifiers.charm", TextFormatting.GOLD);
        if (this.getColor(stack) != AmuletColor.RED) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticAmuletModifier" + (Object)((Object)this.getColor(stack)));
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.enigmaticAmuletModifierRED", TextFormatting.GOLD, EnigmaticAmulet.minimizeNumber(damageBonus.getValue()));
        }
    }

    public Multimap<Attribute, AttributeModifier> getCurrentModifiers(ItemStack amulet, PlayerEntity player) {
        HashMultimap atts = HashMultimap.create();
        AmuletColor color = this.getColor(amulet);
        if (color == AmuletColor.RED) {
            atts.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(UUID.fromString("f5bb82c7-0332-4adf-a414-2e4f03471983"), "enigmaticlegacy:attack_bonus", damageBonus.getValue(), AttributeModifier.Operation.ADDITION));
        } else if (color == AmuletColor.AQUA) {
            atts.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(UUID.fromString("cde98b8a-0cfc-45dc-929f-9cce9b6fbdfa"), "enigmaticlegacy:sprint_bonus", player.func_70051_ag() ? (double)0.15f : 0.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        } else if (color == AmuletColor.MAGENTA) {
            atts.put((Object)ForgeMod.ENTITY_GRAVITY.get(), (Object)new AttributeModifier(UUID.fromString("d1a07f6f-1079-4b17-8dbd-c74dc5e9094d"), "enigmaticlegacy:gravity_bonus", -0.25, AttributeModifier.Operation.MULTIPLY_TOTAL));
        } else if (color == AmuletColor.BLUE) {
            atts.put((Object)ForgeMod.SWIM_SPEED.get(), (Object)new AttributeModifier(UUID.fromString("a4d4b794-a691-4757-b1cb-f5f2d5a25571"), "enigmaticlegacy:swim_bonus", 0.25, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        return atts;
    }

    public Multimap<Attribute, AttributeModifier> getAllModifiers() {
        HashMultimap atts = HashMultimap.create();
        atts.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(UUID.fromString("f5bb82c7-0332-4adf-a414-2e4f03471983"), "enigmaticlegacy:attack_bonus", damageBonus.getValue(), AttributeModifier.Operation.ADDITION));
        atts.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(UUID.fromString("cde98b8a-0cfc-45dc-929f-9cce9b6fbdfa"), "enigmaticlegacy:sprint_bonus", (double)0.15f, AttributeModifier.Operation.MULTIPLY_TOTAL));
        atts.put((Object)ForgeMod.ENTITY_GRAVITY.get(), (Object)new AttributeModifier(UUID.fromString("d1a07f6f-1079-4b17-8dbd-c74dc5e9094d"), "enigmaticlegacy:gravity_bonus", -0.25, AttributeModifier.Operation.MULTIPLY_TOTAL));
        atts.put((Object)ForgeMod.SWIM_SPEED.get(), (Object)new AttributeModifier(UUID.fromString("a4d4b794-a691-4757-b1cb-f5f2d5a25571"), "enigmaticlegacy:swim_bonus", 0.25, AttributeModifier.Operation.MULTIPLY_TOTAL));
        return atts;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K && ItemNBTHelper.verifyExistance(stack, amuletInscriptionTag) && !ItemNBTHelper.verifyExistance(stack, amuletColorTag)) {
            this.setSeededColor(stack);
        }
    }

    @Override
    public void onUnequip(String identifier, int index, LivingEntity living, ItemStack stack) {
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            AttributeModifierManager map = player.func_233645_dx_();
            map.func_233785_a_(this.getAllModifiers());
        }
    }

    @Override
    public void curioTick(String identifier, int index, LivingEntity living, ItemStack stack) {
        PlayerEntity player;
        ItemStack amulet;
        if (living instanceof PlayerEntity && (amulet = SuperpositionHandler.getCurioStack((LivingEntity)(player = (PlayerEntity)living), this)) != null) {
            AttributeModifierManager map = player.func_233645_dx_();
            map.func_233793_b_(this.getCurrentModifiers(amulet, player));
        }
    }

    @Override
    public boolean canEquip(String identifier, LivingEntity living, ItemStack stack) {
        if (multiequip.getValue()) {
            return true;
        }
        return super.canEquip(identifier, living, stack);
    }

    @Override
    public boolean showAttributesTooltip(String identifier, ItemStack stack) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canRender(String identifier, int index, LivingEntity living, ItemStack stack) {
        return false;
    }

    public boolean isVesselEnabled() {
        return vesselEnabled.getValue();
    }

    public boolean isVesselOwnerOnly() {
        return ownerOnlyVessel.getValue();
    }

    public static enum AmuletColor {
        RED(0.1f),
        AQUA(0.2f),
        VIOLET(0.3f),
        MAGENTA(0.4f),
        GREEN(0.5f),
        BLACK(0.6f),
        BLUE(0.7f);

        private float colorVar;

        private AmuletColor(float colorVar) {
            this.colorVar = colorVar;
        }

        public float getColorVar() {
            return this.colorVar;
        }

        public static AmuletColor getRandomColor() {
            return AmuletColor.values()[field_77697_d.nextInt(AmuletColor.values().length)];
        }

        public static AmuletColor getSeededColor(Random rand) {
            return AmuletColor.values()[rand.nextInt(AmuletColor.values().length)];
        }
    }
}

