/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseArmor;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EtheriumArmor
extends ItemBaseArmor {
    public static Omniconfig.PerhapsParameter shieldThreshold;
    public static Omniconfig.PerhapsParameter shieldReduction;

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("EtheriumArmor");
        shieldThreshold = builder.comment("The value of health to which player wearing full Etherium Armor set should be brough to activate the shield ability. Defined as percentage.").max(100.0).getPerhaps("ShieldThreshold", 40);
        shieldReduction = builder.comment("Damage reduction of shield generated by Etherium Armor. Defined as percentage.").max(100.0).getPerhaps("ShieldReduction", 50);
        builder.popPrefix();
    }

    public EtheriumArmor(IArmorMaterial materialIn, EquipmentSlotType slot) {
        super(materialIn, slot, ItemBaseArmor.getDefaultProperties().func_208103_a(Rarity.RARE).func_234689_a_());
    }

    public boolean hasShield(@Nonnull PlayerEntity player) {
        return player != null && this.hasFullSet(player) && (double)(player.func_110143_aJ() / player.func_110138_aP()) <= shieldThreshold.getValue().asMultiplier(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            if (stack.func_77973_b().equals((Object)EnigmaticLegacy.etheriumHelmet)) {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumHelmet1");
            } else if (stack.func_77973_b().equals((Object)EnigmaticLegacy.etheriumChestplate)) {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumChestplate1");
            } else if (stack.func_77973_b().equals((Object)EnigmaticLegacy.etheriumLeggings)) {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumLeggings1");
            } else if (stack.func_77973_b().equals((Object)EnigmaticLegacy.etheriumBoots)) {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumBoots1");
            }
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        if (this.hasFullSet((PlayerEntity)Minecraft.func_71410_x().field_71439_g) || ItemNBTHelper.verifyExistance(stack, "forceDisplaySetBonus") && ItemNBTHelper.getBoolean(stack, "forceDisplaySetBonus", false)) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumArmorSetBonus1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumArmorSetBonus2", TextFormatting.GOLD, shieldThreshold.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumArmorSetBonus3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumArmorSetBonus4", TextFormatting.GOLD, shieldReduction.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumArmorSetBonus5");
        }
        if (stack.func_77948_v()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        }
    }
}

