/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.api.items.IMultiblockMiningTool;
import com.integral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import com.integral.enigmaticlegacy.config.OmniconfigHandler;
import com.integral.enigmaticlegacy.helpers.AOEMiningHelper;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseTool;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.item.SwordItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EtheriumScythe
extends SwordItem
implements IMultiblockMiningTool {
    public static Omniconfig.IntParameter miningVolume;
    protected static final Map<Block, BlockState> HOE_LOOKUP;
    public Set<Material> effectiveMaterials;

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("EtheriumScythe");
        miningVolume = builder.comment("The volume Etherium Scythe AOE mining. Set to -1 to disable the feature.").min(-1.0).max(127.0).getInt("MiningVolume", 3);
        builder.popPrefix();
    }

    public EtheriumScythe() {
        super((IItemTier)EnigmaticMaterials.ETHERIUM, 3, -2.0f, ItemBaseTool.getDefaultProperties().func_208103_a(Rarity.RARE).func_234689_a_());
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "etherium_scythe"));
        this.effectiveMaterials = Sets.newHashSet();
        this.effectiveMaterials.add(Material.field_151584_j);
        this.effectiveMaterials.add(Material.field_215713_z);
        this.effectiveMaterials.add(Material.field_215712_y);
        this.effectiveMaterials.add(Material.field_204868_h);
        this.effectiveMaterials.add(Material.field_151585_k);
        this.effectiveMaterials.add(Material.field_203243_f);
        this.effectiveMaterials.add(Material.field_151582_l);
        this.effectiveMaterials.add(Material.field_151570_A);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (miningVolume.getValue() == -1) {
            return;
        }
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumScythe1", TextFormatting.GOLD, miningVolume.getValue());
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumScythe2", TextFormatting.GOLD, miningVolume.getValue());
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            if (!OmniconfigHandler.disableAOEShiftSuppression.getValue()) {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumScythe3");
            }
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumScythe4");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        if (!this.areaEffectsAllowed(stack)) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.aoeDisabled");
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (player.func_213453_ef()) {
            this.toggleAreaEffects(player, stack);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195999_j().func_213453_ef()) {
            return this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n()).func_188397_a();
        }
        ActionResultType type = Items.field_151012_L.func_195939_a(context);
        if (!this.areaEffectsEnabled(context.func_195999_j(), context.func_195996_i())) {
            return type;
        }
        int supRad = (miningVolume.getValue() - 1) / 2;
        if (type == ActionResultType.CONSUME) {
            for (int x = -supRad; x <= supRad; ++x) {
                for (int z = -supRad; z <= supRad; ++z) {
                    if (x == 0 & z == 0) continue;
                    Items.field_151012_L.func_195939_a(new ItemUseContext(context.func_195999_j(), context.func_221531_n(), new BlockRayTraceResult(context.func_221532_j().func_72441_c((double)x, 0.0, (double)z), Direction.UP, context.func_195995_a().func_177982_a(x, 0, z), context.func_221533_k())));
                }
            }
        }
        return type;
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (entityLiving instanceof PlayerEntity && this.areaEffectsEnabled((PlayerEntity)entityLiving, stack) && this.effectiveMaterials.contains(state.func_185904_a()) && !world.field_72995_K && miningVolume.getValue() != -1) {
            Direction face = Direction.UP;
            AOEMiningHelper.harvestCube(world, (PlayerEntity)entityLiving, face, pos.func_177982_a(0, (miningVolume.getValue() - 1) / 2, 0), this.effectiveMaterials, miningVolume.getValue(), miningVolume.getValue(), false, pos, stack, (objPos, objState) -> stack.func_222118_a(1, entityLiving, p -> p.func_213361_c(MobEntity.func_184640_d((ItemStack)stack))));
        }
        return super.func_179218_a(stack, world, state, pos, entityLiving);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        return !this.effectiveMaterials.contains(material) ? super.func_150893_a(stack, state) : this.func_200891_e().func_200928_b();
    }

    static {
        HOE_LOOKUP = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.field_196658_i, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_185774_da, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_150346_d, (Object)Blocks.field_150458_ak.func_176223_P(), (Object)Blocks.field_196660_k, (Object)Blocks.field_150346_d.func_176223_P()));
    }
}

