/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.Sets;
import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.api.items.IMultiblockMiningTool;
import com.integral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import com.integral.enigmaticlegacy.config.OmniconfigHandler;
import com.integral.enigmaticlegacy.helpers.AOEMiningHelper;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseTool;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class EtheriumShovel
extends ItemBaseTool
implements IMultiblockMiningTool {
    public static Omniconfig.IntParameter miningRadius;
    public static Omniconfig.IntParameter miningDepth;
    public static Item.Properties integratedProperties;
    public Set<Material> effectiveMaterials;

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("EtheriumShovel");
        miningRadius = builder.comment("The radius of Etherium Shovel AOE mining. Set to -1 to disable the feature.").min(-1.0).max(127.0).getInt("MiningRadius", 3);
        miningDepth = builder.comment("The depth of Etherium Shovel AOE mining.").max(127.0).getInt("MiningDepth", 1);
        builder.popPrefix();
    }

    public EtheriumShovel() {
        super(2.5f, -3.0f, EnigmaticMaterials.ETHERIUM, new HashSet<Block>(), ItemBaseTool.getDefaultProperties().func_200915_b((int)((double)EnigmaticMaterials.ETHERIUM.func_200926_a() * 1.5)).addToolType(ToolType.SHOVEL, EnigmaticMaterials.ETHERIUM.func_200925_d()).func_208103_a(Rarity.RARE).func_234689_a_());
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "etherium_shovel"));
        this.effectiveMaterials = Sets.newHashSet();
        this.effectiveMaterials.add(Material.field_151578_c);
        this.effectiveMaterials.add(Material.field_151577_b);
        this.effectiveMaterials.add(Material.field_151597_y);
        this.effectiveMaterials.add(Material.field_151596_z);
        this.effectiveMaterials.add(Material.field_151595_p);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (miningRadius.getValue() == -1) {
            return;
        }
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumShovel1", TextFormatting.GOLD, miningRadius.getValue(), miningDepth.getValue());
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            if (!OmniconfigHandler.disableAOEShiftSuppression.getValue()) {
                ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumShovel2");
            }
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumShovel3");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        if (!this.areaEffectsAllowed(stack)) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.aoeDisabled");
        }
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        BlockRayTraceResult trace;
        if (entityLiving instanceof PlayerEntity && this.areaEffectsEnabled((PlayerEntity)entityLiving, stack) && this.effectiveMaterials.contains(state.func_185904_a()) && !world.field_72995_K && miningRadius.getValue() != -1 && (trace = AOEMiningHelper.calcRayTrace(world, (PlayerEntity)entityLiving, RayTraceContext.FluidMode.ANY)).func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockTrace = trace;
            Direction face = blockTrace.func_216354_b();
            AOEMiningHelper.harvestCube(world, (PlayerEntity)entityLiving, face, pos, this.effectiveMaterials, miningRadius.getValue(), miningDepth.getValue(), false, pos, stack, (objPos, objState) -> stack.func_222118_a(1, entityLiving, p -> p.func_213361_c(MobEntity.func_184640_d((ItemStack)stack))));
        }
        return super.func_179218_a(stack, world, state, pos, entityLiving);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195999_j().func_213453_ef()) {
            return this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n()).func_188397_a();
        }
        return Items.field_151047_v.func_195939_a(context);
    }

    @Override
    public boolean func_150897_b(BlockState blockIn) {
        return Items.field_151047_v.func_150897_b(blockIn);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (player.func_213453_ef()) {
            this.toggleAreaEffects(player, stack);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    @Override
    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        return !this.effectiveMaterials.contains(material) ? super.func_150893_a(stack, state) : this.field_77864_a;
    }

    static {
        integratedProperties = new Item.Properties();
    }
}

