/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.api.items.IMultiblockMiningTool;
import com.integral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseTool;
import com.integral.enigmaticlegacy.objects.CooldownMap;
import com.integral.enigmaticlegacy.objects.Vector3;
import com.integral.enigmaticlegacy.packets.clients.PacketPlayerMotion;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.item.SwordItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class EtheriumSword
extends SwordItem
implements IMultiblockMiningTool {
    public static Omniconfig.IntParameter cooldown;
    public CooldownMap etheriumSwordCooldowns = new CooldownMap();

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("EtheriumSword");
        cooldown = builder.comment("Cooldown of Etherium Broadsword ability. Measured in ticks.").getInt("Cooldown", 40);
        builder.popPrefix();
    }

    public EtheriumSword() {
        super((IItemTier)EnigmaticMaterials.ETHERIUM, 6, -2.6f, ItemBaseTool.getDefaultProperties().func_208103_a(Rarity.RARE).func_234689_a_());
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "etherium_sword"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumSword1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumSword2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumSword3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumSword4", TextFormatting.GOLD, Float.valueOf((float)cooldown.getValue() / 20.0f));
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.etheriumSword5");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        if (!this.areaEffectsAllowed(stack)) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.abilityDisabled");
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand == Hand.OFF_HAND) {
            return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
        }
        if (player.func_213453_ef()) {
            this.toggleAreaEffects(player, stack);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (!player.field_70170_p.field_72995_K && !player.func_184811_cZ().func_185141_a((Item)this) && this.areaEffectsEnabled(player, stack)) {
            Vector3 look = new Vector3(player.func_70040_Z());
            Vector3 dir = look.multiply(1.0);
            this.knockBack(player, 1.0f, dir.x, dir.z);
            world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187866_fi, SoundCategory.PLAYERS, 1.0f, (float)((double)0.6f + Math.random() * 0.1));
            player.func_184811_cZ().func_185145_a((Item)this, cooldown.getValue());
            player.func_184598_c(hand);
            return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195999_j().func_213453_ef()) {
            return this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n()).func_188397_a();
        }
        return super.func_195939_a(context);
    }

    public void knockBack(PlayerEntity entityIn, float strength, double xRatio, double zRatio) {
        entityIn.field_70160_al = true;
        Vector3d vec3d = new Vector3d(0.0, 0.0, 0.0);
        Vector3d vec3d1 = new Vector3d(xRatio, 0.0, zRatio).func_72432_b().func_186678_a((double)strength);
        EnigmaticLegacy.packetInstance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)entityIn), (Object)new PacketPlayerMotion(vec3d.field_72450_a / 2.0 - vec3d1.field_72450_a, entityIn.func_233570_aj_() ? Math.min(0.4, vec3d.field_72448_b / 2.0 + (double)strength) : vec3d.field_72448_b, vec3d.field_72449_c / 2.0 - vec3d1.field_72449_c));
        entityIn.func_213293_j(vec3d.field_72450_a / 2.0 - vec3d1.field_72450_a, entityIn.func_233570_aj_() ? Math.min(0.4, vec3d.field_72448_b / 2.0 + (double)strength) : vec3d.field_72448_b, vec3d.field_72449_c / 2.0 - vec3d1.field_72449_c);
    }
}

