/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.api.items.ISpellstone;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemSpellstoneCurio;
import com.integral.enigmaticlegacy.objects.Vector3;
import com.integral.enigmaticlegacy.packets.clients.PacketPlayerSetlook;
import com.integral.enigmaticlegacy.packets.clients.PacketPortalParticles;
import com.integral.enigmaticlegacy.packets.clients.PacketRecallParticles;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class EyeOfNebula
extends ItemSpellstoneCurio
implements ISpellstone {
    public static Omniconfig.IntParameter spellstoneCooldown;
    public static Omniconfig.PerhapsParameter dodgeProbability;
    public static Omniconfig.DoubleParameter dodgeRange;
    public static Omniconfig.DoubleParameter phaseRange;
    public static Omniconfig.PerhapsParameter magicResistance;

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("EyeOfNebula");
        spellstoneCooldown = builder.comment("Active ability cooldown for Eye of the Nebula. Measured in ticks. 20 ticks equal to 1 second.").getInt("Cooldown", 60);
        dodgeProbability = builder.comment("Probability for Eye of the Nebula to teleport it's bearer from any attack without receiving any damage. Defined as percentage.").max(100.0).getPerhaps("DodgeChance", 15);
        dodgeRange = builder.comment("Range in which Eye of the Nebula searches for a position to teleport it's bearer to when dodging the attack.").min(1.0).max(128.0).getDouble("DodgeRange", 16.0);
        phaseRange = builder.comment("Range in which Eye of the Nebula can reach an entity when using it's active ability.").min(1.0).max(128.0).getDouble("PhaseRange", 32.0);
        magicResistance = builder.comment("Magic Damage resistance provided by Eye of the Nebula. Defined as percentage.").max(100.0).getPerhaps("MagicResistance", 65);
        builder.popPrefix();
    }

    public EyeOfNebula() {
        super(ItemSpellstoneCurio.getDefaultProperties().func_208103_a(Rarity.EPIC));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "eye_of_nebula"));
        Supplier<Float> magicResistanceSupplier = () -> Float.valueOf(magicResistance.getValue().asModifierInverted());
        this.resistanceList.put(DamageSource.field_76376_m.func_76355_l(), magicResistanceSupplier);
        this.resistanceList.put(DamageSource.field_188407_q.func_76355_l(), magicResistanceSupplier);
        this.resistanceList.put(DamageSource.field_82727_n.func_76355_l(), magicResistanceSupplier);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eyeOfNebula1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eyeOfNebula2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eyeOfNebulaCooldown", TextFormatting.GOLD, Float.valueOf((float)spellstoneCooldown.getValue() / 20.0f));
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eyeOfNebula3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eyeOfNebula4", TextFormatting.GOLD, magicResistance.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eyeOfNebula5", TextFormatting.GOLD, dodgeProbability.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.eyeOfNebula6");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", TextFormatting.LIGHT_PURPLE, ((ITextComponent)KeyBinding.func_193626_b((String)"key.spellstoneAbility").get()).getString().toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canRender(String identifier, int index, LivingEntity living, ItemStack stack) {
        return false;
    }

    @Override
    public void triggerActiveAbility(World world, ServerPlayerEntity player, ItemStack stack) {
        if (SuperpositionHandler.hasSpellstoneCooldown((PlayerEntity)player)) {
            return;
        }
        LivingEntity target = SuperpositionHandler.getObservedEntity((PlayerEntity)player, world, 3.0f, (int)phaseRange.getValue());
        if (target != null) {
            Vector3 targetPos = Vector3.fromEntityCenter((Entity)target);
            Vector3 chaserPos = Vector3.fromEntityCenter((Entity)player);
            Vector3 dir = targetPos.subtract(chaserPos);
            dir = dir.normalize();
            dir = dir.multiply(1.5);
            dir = targetPos.add(dir);
            world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
            EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 128.0, player.field_70170_p.func_234923_W_())), (Object)new PacketPortalParticles(player.func_226277_ct_(), player.func_226278_cu_() + (double)(player.func_213302_cg() / 2.0f), player.func_226281_cx_(), 72, 1.0, false));
            player.func_70634_a(dir.x, target.func_226278_cu_() + 0.25, dir.z);
            EnigmaticLegacy.packetInstance.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketPlayerSetlook(target.func_226277_ct_(), target.func_226278_cu_() - 1.0 + (double)(target.func_213302_cg() / 2.0f), target.func_226281_cx_()));
            world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
            EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 128.0, player.field_70170_p.func_234923_W_())), (Object)new PacketRecallParticles(player.func_226277_ct_(), player.func_226278_cu_() + (double)(player.func_213302_cg() / 2.0f), player.func_226281_cx_(), 24, false));
            SuperpositionHandler.setSpellstoneCooldown((PlayerEntity)player, spellstoneCooldown.getValue());
        }
    }
}

