/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ExperienceHelper;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.HeavenScroll;
import com.integral.enigmaticlegacy.items.generic.ItemBaseCurio;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FabulousScroll
extends HeavenScroll {
    public FabulousScroll() {
        super(ItemBaseCurio.getDefaultProperties().func_208103_a(Rarity.EPIC));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "fabulous_scroll"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.fabulousScroll1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.fabulousScroll2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.fabulousScroll3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.fabulousScroll4");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.fabulousScroll5");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    @Override
    public void curioTick(String identifier, int index, LivingEntity living, ItemStack stack) {
        if (living.field_70170_p.field_72995_K) {
            return;
        }
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            boolean inRange = SuperpositionHandler.isInBeaconRange(player);
            if (!SuperpositionHandler.isInBeaconRange(player)) {
                double d = Math.random();
                this.getClass();
                if (d <= 0.0125 * 8.0 * xpCostModifier.getValue() && player.field_71075_bZ.field_75100_b) {
                    ExperienceHelper.drainPlayerXP(player, 1);
                }
            }
            this.handleFabulousFlight(player, inRange);
        }
    }

    protected void handleFabulousFlight(PlayerEntity player, boolean inRange) {
        try {
            if (ExperienceHelper.getPlayerXP(player) > 0 || inRange) {
                if (!player.field_71075_bZ.field_75101_c) {
                    player.field_71075_bZ.field_75101_c = true;
                }
                player.func_71016_p();
                this.flyMap.put(player, 100);
            } else if ((Integer)this.flyMap.get(player) > 1) {
                this.flyMap.put(player, (Integer)this.flyMap.get(player) - 1);
            } else if ((Integer)this.flyMap.get(player) == 1) {
                if (!player.func_184812_l_()) {
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                    player.func_71016_p();
                    player.func_195064_c(new EffectInstance(Effects.field_204839_B, 200, 0, true, false));
                }
                this.flyMap.put(player, 0);
            }
        }
        catch (NullPointerException ex) {
            this.flyMap.put(player, 0);
        }
    }

    @Override
    public void onUnequip(String identifier, int index, LivingEntity entityLivingBase, ItemStack stack) {
        if (entityLivingBase instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLivingBase;
            if (!player.func_184812_l_()) {
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75100_b = false;
                player.func_71016_p();
            }
            this.flyMap.put(player, 0);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canRender(String identifier, int index, LivingEntity living, ItemStack stack) {
        return false;
    }
}

