/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseTool;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.SwordItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class ForbiddenAxe
extends SwordItem {
    public static Omniconfig.PerhapsParameter beheadingBase;
    public static Omniconfig.PerhapsParameter beheadingBonus;

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("ForbiddenAxe");
        beheadingBase = builder.comment("Default chance to behead an enemy with Axe of Executioner. Defined as percentage.").max(100.0).getPerhaps("BeheadingBase", 10);
        beheadingBonus = builder.comment("Bonus percantage to beheading chance from each Looting level applied to Axe of Executioner.").max(100.0).getPerhaps("BeheadingBonus", 5);
        builder.popPrefix();
    }

    public ForbiddenAxe() {
        super((IItemTier)EnigmaticMaterials.FORBIDDENAXE, 6, -2.4f, ItemBaseTool.getDefaultProperties().func_200915_b(2000).func_208103_a(Rarity.EPIC).func_234689_a_());
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "forbidden_axe"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ICuriosItemHandler handler;
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.forbiddenAxe1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.forbiddenAxe2", TextFormatting.GOLD, beheadingBonus.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.forbiddenAxe3");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        int looting = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)stack);
        if (Minecraft.func_71410_x().field_71439_g != null && (handler = (ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)Minecraft.func_71410_x().field_71439_g).orElse(null)) != null) {
            looting = handler.getLootingBonus();
        }
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.forbiddenAxeBeheadingChance", TextFormatting.GOLD, beheadingBase.getValue().asPercentage() + beheadingBonus.getValue().asPercentage() * looting + "%");
    }

    public boolean func_150897_b(BlockState blockIn) {
        return false;
    }
}

