/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.api.items.ISpellstone;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemSpellstoneCurio;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GolemHeart
extends ItemSpellstoneCurio
implements ISpellstone {
    public static Omniconfig.IntParameter spellstoneCooldown;
    public static Omniconfig.DoubleParameter defaultArmorBonus;
    public static Omniconfig.DoubleParameter superArmorBonus;
    public static Omniconfig.DoubleParameter superArmorToughnessBonus;
    public static Omniconfig.PerhapsParameter knockbackResistance;
    public static Omniconfig.PerhapsParameter meleeResistance;
    public static Omniconfig.PerhapsParameter explosionResistance;
    public static Omniconfig.DoubleParameter vulnerabilityModifier;
    public Object model;
    public Multimap<Attribute, AttributeModifier> attributesDefault = HashMultimap.create();
    public Multimap<Attribute, AttributeModifier> attributesNoArmor = HashMultimap.create();

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("GolemHeart");
        spellstoneCooldown = builder.comment("Active ability cooldown for Heart of the Golem. Measured in ticks. 20 ticks equal to 1 second.").getInt("Cooldown", 0);
        defaultArmorBonus = builder.comment("Default amount of armor points provided by Heart of the Golem.").max(256.0).getDouble("DefaultArmor", 4.0);
        superArmorBonus = builder.comment("The amount of armor points provided by Heart of the Golem when it's bearer has no armor equipped.").max(256.0).getDouble("SuperArmor", 16.0);
        superArmorToughnessBonus = builder.comment("The amount of armor toughness provided by Heart of the Golem when it's bearer has no armor equipped.").max(256.0).getDouble("SuperArmorToughness", 4.0);
        meleeResistance = builder.comment("Resistance to melee attacks provided by Heart of the Golem. Defined as percentage.").max(100.0).getPerhaps("MeleeResistance", 25);
        explosionResistance = builder.comment("Resistance to explosion damage provided by Heart of the Golem. Defined as percentage.").max(100.0).getPerhaps("ExplosionResistance", 40);
        knockbackResistance = builder.comment("Resistance to knockback provided by Heart of the Golem. Defined as percentage.").max(100.0).getPerhaps("KnockbackResistance", 100);
        vulnerabilityModifier = builder.comment("Modifier for Magic Damage vulnerability applied by Heart of the Golem. Default value of 2.0 means that player will receive twice as much damage from magic.").min(1.0).max(256.0).getDouble("VulnerabilityModifier", 2.0);
        builder.popPrefix();
    }

    public GolemHeart() {
        super(ItemSpellstoneCurio.getDefaultProperties().func_208103_a(Rarity.UNCOMMON));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "golem_heart"));
        this.immunityList.add(DamageSource.field_76367_g.field_76373_n);
        this.immunityList.add(DamageSource.field_191291_g.field_76373_n);
        this.immunityList.add(DamageSource.field_76368_d.field_76373_n);
        this.immunityList.add(DamageSource.field_82729_p.field_76373_n);
        this.immunityList.add(DamageSource.field_220302_v.field_76373_n);
        Supplier<Float> meleeResistanceSupplier = () -> Float.valueOf(meleeResistance.getValue().asModifierInverted());
        Supplier<Float> explosionResistanceSupplier = () -> Float.valueOf(explosionResistance.getValue().asModifierInverted());
        Supplier<Float> magicVulnerabilitySupplier = () -> Float.valueOf((float)vulnerabilityModifier.getValue());
        this.resistanceList.put(DamageSource.field_76377_j.field_76373_n, meleeResistanceSupplier);
        this.resistanceList.put("mob", meleeResistanceSupplier);
        this.resistanceList.put("player", meleeResistanceSupplier);
        this.resistanceList.put("explosion", explosionResistanceSupplier);
        this.resistanceList.put("explosion.player", explosionResistanceSupplier);
        this.resistanceList.put(DamageSource.field_76376_m.field_76373_n, magicVulnerabilitySupplier);
        this.resistanceList.put(DamageSource.field_82727_n.field_76373_n, magicVulnerabilitySupplier);
        this.resistanceList.put(DamageSource.field_188407_q.field_76373_n, magicVulnerabilitySupplier);
        this.initAttributes();
    }

    private void initAttributes() {
        this.attributesDefault.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(UUID.fromString("15faf191-bf21-4654-b359-cc1f4f1243bf"), "GolemHeart DAB", defaultArmorBonus.getValue(), AttributeModifier.Operation.ADDITION));
        this.attributesDefault.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(UUID.fromString("10faf191-bf21-4554-b359-cc1f4f1233bf"), "GolemHeart KR", (double)knockbackResistance.getValue().asModifier(false), AttributeModifier.Operation.ADDITION));
        this.attributesNoArmor.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(UUID.fromString("14faf191-bf23-4654-b359-cc1f4f1243bf"), "GolemHeart SAB", superArmorBonus.getValue(), AttributeModifier.Operation.ADDITION));
        this.attributesNoArmor.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(UUID.fromString("11faf181-bf23-4354-b359-cc1f5f1253bf"), "GolemHeart STB", superArmorToughnessBonus.getValue(), AttributeModifier.Operation.ADDITION));
        this.attributesNoArmor.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(UUID.fromString("12faf181-bf21-4554-b359-cc1f4f1254bf"), "GolemHeart KR", (double)knockbackResistance.getValue().asModifier(false), AttributeModifier.Operation.ADDITION));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeartCooldown", TextFormatting.GOLD, Float.valueOf((float)spellstoneCooldown.getValue() / 20.0f));
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart4", TextFormatting.GOLD, (int)defaultArmorBonus.getValue());
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart5");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart6", TextFormatting.GOLD, (int)superArmorBonus.getValue(), (int)superArmorToughnessBonus.getValue());
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart7", TextFormatting.GOLD, explosionResistance.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart8", TextFormatting.GOLD, meleeResistance.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart9", TextFormatting.GOLD, knockbackResistance.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart10");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.golemHeart11");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", TextFormatting.LIGHT_PURPLE, ((ITextComponent)KeyBinding.func_193626_b((String)"key.spellstoneAbility").get()).getString().toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void onUnequip(String identifier, int index, LivingEntity living, ItemStack stack) {
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            AttributeModifierManager map = player.func_233645_dx_();
            map.func_233785_a_(this.attributesDefault);
            map.func_233785_a_(this.attributesNoArmor);
        }
    }

    @Override
    public void curioTick(String identifier, int index, LivingEntity living, ItemStack stack) {
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            AttributeModifierManager map = player.func_233645_dx_();
            if (SuperpositionHandler.hasAnyArmor((LivingEntity)player)) {
                map.func_233785_a_(this.attributesDefault);
                map.func_233785_a_(this.attributesNoArmor);
                map.func_233793_b_(this.attributesDefault);
            } else {
                map.func_233785_a_(this.attributesDefault);
                map.func_233785_a_(this.attributesNoArmor);
                map.func_233793_b_(this.attributesNoArmor);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canRender(String identifier, int index, LivingEntity living, ItemStack stack) {
        return false;
    }
}

