/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.Lists;
import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.api.items.ICursed;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBase;
import com.integral.enigmaticlegacy.objects.Vector3;
import com.integral.enigmaticlegacy.packets.clients.PacketGenericParticleEffect;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinBruteBrain;
import net.minecraft.entity.monster.piglin.PiglinBruteEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class GuardianHeart
extends ItemBase
implements ICursed,
IVanishable {
    public static Omniconfig.IntParameter abilityRange;
    public static Omniconfig.IntParameter enrageRange;
    public static Omniconfig.IntParameter abilityCooldown;
    public static final List<Class<? extends LivingEntity>> excludedMobs;

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("GuardianHeart");
        abilityRange = builder.comment("Range of active/passive abilities of Heart of the Guardian.").getInt("AbilityRange", 24);
        enrageRange = builder.comment("Range in which monster enraged by active ability of Heart of the Guardian will seek new target. Monsters within this range will target enraged monster back.").getInt("EnrageRange", 12);
        abilityCooldown = builder.comment("Cooldown of enraging ability of Heart of the Guardian. Measured in ticks.").getInt("ActiveAbilityCooldown", 200);
        builder.popPrefix();
    }

    public GuardianHeart() {
        super(GuardianHeart.getDefaultProperties().func_200917_a(1).func_208103_a(Rarity.EPIC).func_234689_a_());
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "guardian_heart"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.guardianHeart1", TextFormatting.GOLD, abilityRange);
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.guardianHeart2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.guardianHeart3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.guardianHeart4");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.guardianHeart5", TextFormatting.GOLD, abilityRange);
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.guardianHeart6");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.guardianHeart7");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.guardianHeart8", TextFormatting.GOLD, enrageRange);
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.guardianHeart9");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.guardianHeart10");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.guardianHeart11");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.guardianHeart12", TextFormatting.GOLD, (double)abilityCooldown.getValue() / 20.0);
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        ItemLoreHelper.indicateCursedOnesOnly(list);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof PlayerEntity && !world.field_72995_K) {
            MonsterEntity closestMonster;
            List surroundingMobs;
            PlayerEntity player = (PlayerEntity)entity;
            List genericMobs = player.field_70170_p.func_217357_a(MonsterEntity.class, SuperpositionHandler.getBoundingBoxAroundEntity((Entity)player, abilityRange.getValue()));
            if (SuperpositionHandler.isTheCursedOne(player) && PlayerInventory.func_184435_e((int)itemSlot) && !player.func_184811_cZ().func_185141_a((Item)this)) {
                MonsterEntity oneWatched = null;
                for (MonsterEntity monster2 : genericMobs) {
                    if (!SuperpositionHandler.doesObserveEntity(player, (LivingEntity)monster2) || this.isExcluded((LivingEntity)monster2)) continue;
                    oneWatched = monster2;
                    break;
                }
                if (oneWatched != null && oneWatched.func_70089_S()) {
                    MonsterEntity theOne = oneWatched;
                    Vector3 vec = Vector3.fromEntityCenter(theOne);
                    surroundingMobs = player.field_70170_p.func_175647_a(MonsterEntity.class, SuperpositionHandler.getBoundingBoxAroundEntity((Entity)theOne, enrageRange.getValue()), living -> living.func_70089_S() && theOne.func_70685_l((Entity)living));
                    closestMonster = (MonsterEntity)SuperpositionHandler.getClosestEntity(surroundingMobs, monster -> monster != theOne, vec.x, vec.y, vec.z);
                    if (closestMonster != null) {
                        this.setAttackTarget(theOne, closestMonster);
                        theOne.func_195064_c(new EffectInstance(Effects.field_76440_q, 300, 0, false, true));
                        theOne.func_195064_c(new EffectInstance(Effects.field_76420_g, 300, 1, false, false));
                        theOne.func_195064_c(new EffectInstance(Effects.field_76429_m, 300, 1, false, false));
                        for (MonsterEntity otherMonster : surroundingMobs) {
                            this.setAttackTarget(otherMonster, theOne);
                        }
                        player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187514_aD, SoundCategory.HOSTILE, 1.0f, 1.0f);
                        if (player instanceof ServerPlayerEntity) {
                            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
                            EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(theOne.func_226277_ct_(), theOne.func_226278_cu_(), theOne.func_226281_cx_(), 64.0, theOne.field_70170_p.func_234923_W_())), (Object)new PacketGenericParticleEffect(theOne.func_226277_ct_(), theOne.func_226280_cw_(), theOne.func_226281_cx_(), 0, false, PacketGenericParticleEffect.Effect.GUARDIAN_CURSE));
                        }
                        player.func_184811_cZ().func_185145_a((Item)this, abilityCooldown.getValue());
                    }
                }
            }
            for (MonsterEntity monster3 : genericMobs) {
                GuardianEntity guardian;
                if (!(monster3 instanceof GuardianEntity) || monster3.getClass() == ElderGuardianEntity.class || (guardian = (GuardianEntity)monster3).func_70638_az() != null || (closestMonster = (MonsterEntity)SuperpositionHandler.getClosestEntity(surroundingMobs = player.field_70170_p.func_175647_a(MonsterEntity.class, SuperpositionHandler.getBoundingBoxAroundEntity((Entity)guardian, 12.0), living -> living.func_70089_S() && guardian.func_70685_l((Entity)living)), checked -> !(checked instanceof GuardianEntity), guardian.func_226277_ct_(), guardian.func_226278_cu_(), guardian.func_226281_cx_())) == null) continue;
                this.setAttackTarget((MonsterEntity)guardian, closestMonster);
            }
        }
    }

    private boolean isExcluded(LivingEntity entity) {
        boolean excluded = false;
        for (Class<? extends LivingEntity> excludedClass : excludedMobs) {
            if (!excludedClass.isInstance(entity)) continue;
            excluded = true;
        }
        return excluded;
    }

    private void setAttackTarget(MonsterEntity monster, MonsterEntity otherMonster) {
        if (monster != null && otherMonster != null && monster != otherMonster) {
            if (monster instanceof AbstractPiglinEntity) {
                ((AbstractPiglinEntity)monster).func_213375_cj().func_218205_a(MemoryModuleType.field_234103_o_, (Object)otherMonster);
                monster.func_70624_b((LivingEntity)otherMonster);
                monster.func_70604_c((LivingEntity)otherMonster);
                if (monster instanceof PiglinBruteEntity) {
                    PiglinBruteBrain.func_242353_a((PiglinBruteEntity)((PiglinBruteEntity)monster), (LivingEntity)otherMonster);
                } else if (monster instanceof PiglinEntity) {
                    PiglinTasks.func_234468_a_((PiglinEntity)((PiglinEntity)monster), (LivingEntity)otherMonster);
                }
            } else if (monster instanceof IAngerable) {
                ((IAngerable)monster).func_70624_b((LivingEntity)otherMonster);
            } else {
                monster.func_70624_b((LivingEntity)otherMonster);
                monster.func_70604_c((LivingEntity)otherMonster);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    static {
        excludedMobs = Lists.newArrayList((Object[])new Class[]{AbstractPiglinEntity.class, GuardianEntity.class});
    }
}

