/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ExperienceHelper;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HeavenScroll
extends ItemBaseCurio {
    public static Omniconfig.DoubleParameter xpCostModifier;
    public HashMap<PlayerEntity, Integer> flyMap = new HashMap();
    public final double baseXpConsumptionProbability = 0.0125;

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("HeavenScroll");
        xpCostModifier = builder.comment("Multiplier for experience consumption by Gift of the Heaven.").getDouble("XPCostModifier", 1.0);
        builder.popPrefix();
    }

    public HeavenScroll() {
        super(ItemBaseCurio.getDefaultProperties().func_208103_a(Rarity.EPIC));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "heaven_scroll"));
    }

    public HeavenScroll(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.heavenTome1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.heavenTome2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.heavenTome3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.heavenTome4");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    @Override
    public void curioTick(String identifier, int index, LivingEntity living, ItemStack stack) {
        if (living.field_70170_p.field_72995_K) {
            return;
        }
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            if (Math.random() <= this.baseXpConsumptionProbability * xpCostModifier.getValue() && player.field_71075_bZ.field_75100_b) {
                ExperienceHelper.drainPlayerXP(player, 1);
            }
            this.handleFlight(player);
        }
    }

    protected void handleFlight(PlayerEntity player) {
        try {
            if (ExperienceHelper.getPlayerXP(player) > 0 && SuperpositionHandler.isInBeaconRange(player)) {
                if (!player.field_71075_bZ.field_75101_c) {
                    player.field_71075_bZ.field_75101_c = true;
                }
                player.func_71016_p();
                this.flyMap.put(player, 100);
            } else if (this.flyMap.get(player) > 1) {
                this.flyMap.put(player, this.flyMap.get(player) - 1);
            } else if (this.flyMap.get(player) == 1) {
                if (!player.func_184812_l_()) {
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                    player.func_71016_p();
                    player.func_195064_c(new EffectInstance(Effects.field_204839_B, 200, 0, true, false));
                }
                this.flyMap.put(player, 0);
            }
        }
        catch (NullPointerException ex) {
            this.flyMap.put(player, 0);
        }
    }

    @Override
    public void onUnequip(String identifier, int index, LivingEntity entityLivingBase, ItemStack stack) {
        if (entityLivingBase instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLivingBase;
            if (!player.func_184812_l_()) {
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75100_b = false;
                player.func_71016_p();
            }
            this.flyMap.put(player, 0);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canRender(String identifier, int index, LivingEntity living, ItemStack stack) {
        return false;
    }
}

