/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Infinimeal
extends ItemBase
implements IVanishable {
    public Infinimeal() {
        super(Infinimeal.getDefaultProperties().func_200917_a(1).func_208103_a(Rarity.UNCOMMON));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "infinimeal"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.infinimeal1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.infinimeal2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.infinimeal3");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        int savedCount = stack.func_190916_E();
        ActionResultType result = Items.field_196106_bc.func_195939_a(context);
        stack.func_190920_e(savedCount);
        if (result == ActionResultType.PASS) {
            BlockPos pos = context.func_195995_a();
            World world = context.func_195991_k();
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block instanceof CactusBlock || block instanceof SugarCaneBlock) {
                BlockPos topMostPos = this.findTopmostGrowable(world, pos, block, true);
                BlockState topMostState = world.func_180495_p(topMostPos);
                if (topMostState.func_235901_b_((Property)BlockStateProperties.field_208171_X) && world.func_175623_d(topMostPos.func_177984_a())) {
                    int age = (Integer)topMostState.func_177229_b((Property)BlockStateProperties.field_208171_X);
                    int plantHeight = 1;
                    while (world.func_180495_p(topMostPos.func_177979_c(plantHeight)).func_203425_a(block)) {
                        ++plantHeight;
                    }
                    if (plantHeight >= 3) {
                        return result;
                    }
                    if (!world.field_72995_K) {
                        world.func_217379_c(2005, pos, 0);
                    }
                    world.func_180501_a(topMostPos, (BlockState)topMostState.func_206870_a((Property)BlockStateProperties.field_208171_X, (Comparable)Integer.valueOf(Math.min(age += field_77697_d.nextInt(20), 15))), 4);
                    if (world instanceof ServerWorld) {
                        block.func_225542_b_(world.func_180495_p(topMostPos), (ServerWorld)world, topMostPos, field_77697_d);
                    }
                    return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
                }
            } else {
                if (block instanceof VineBlock) {
                    if (!block.func_149653_t(state)) {
                        return result;
                    }
                    if (world.field_72995_K) {
                        EnigmaticLegacy.proxy.spawnBonemealParticles(world, pos, 0);
                    }
                    int cycles = 7 + field_77697_d.nextInt(7);
                    if (world instanceof ServerWorld) {
                        for (int i = 0; i <= cycles; ++i) {
                            block.func_225542_b_(state, (ServerWorld)world, pos, field_77697_d);
                        }
                        state.func_235734_a_((IWorld)world, pos, 4);
                    }
                    return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
                }
                if (block instanceof NetherWartBlock) {
                    if (!block.func_149653_t(state)) {
                        return result;
                    }
                    if (!world.field_72995_K) {
                        world.func_217379_c(2005, pos, 0);
                    }
                    int cycles = 1 + field_77697_d.nextInt(1);
                    cycles *= 11;
                    if (world instanceof ServerWorld) {
                        for (int i = 0; i <= cycles; ++i) {
                            block.func_225542_b_(state, (ServerWorld)world, pos, field_77697_d);
                        }
                    }
                    return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
                }
            }
        }
        return result;
    }

    private BlockPos findTopmostGrowable(World world, BlockPos pos, Block block, boolean goUp) {
        BlockPos top = pos;
        while (world.func_180495_p(top) != null && world.func_180495_p(top).func_177230_c() == block) {
            BlockPos nextUp;
            BlockPos blockPos = nextUp = goUp ? top.func_177984_a() : top.func_177977_b();
            if (world.func_180495_p(nextUp) == null || world.func_180495_p(nextUp).func_177230_c() != block) {
                return top;
            }
            top = nextUp;
        }
        return pos;
    }
}

