/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.integral.enigmaticlegacy.packets.clients.PacketPortalParticles;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class Megasponge
extends ItemBaseCurio
implements IVanishable {
    public static Omniconfig.IntParameter radius;

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("Megasponge");
        radius = builder.comment("Radius in which Exptrapolated Megaspong absorbs water. Default 4 equals to vanilla sponge").max(128.0).getInt("Radius", 4);
        builder.popPrefix();
    }

    public Megasponge() {
        super(ItemBaseCurio.getDefaultProperties().func_208103_a(Rarity.UNCOMMON));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "mega_sponge"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.megaSponge1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.megaSponge2");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    public BlockPos getCollidedWater(ITag.INamedTag<Fluid> fluidTag, PlayerEntity player) {
        AxisAlignedBB axisalignedbb = player.func_174813_aQ().func_186664_h(0.001);
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)axisalignedbb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        BlockPos pos = null;
        if (!player.field_70170_p.func_217344_a(i, k, i1, j, l, j1)) {
            return null;
        }
        try {
            BlockPos.Mutable blockpos$pooledmutableblockpos = new BlockPos.Mutable();
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = k; i2 < l; ++i2) {
                    for (int j2 = i1; j2 < j1; ++j2) {
                        blockpos$pooledmutableblockpos.func_181079_c(l1, i2, j2);
                        FluidState ifluidstate = player.field_70170_p.func_204610_c((BlockPos)blockpos$pooledmutableblockpos);
                        if (!ifluidstate.func_206884_a(fluidTag)) continue;
                        ifluidstate.func_206880_a(player.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos);
                        pos = new BlockPos(l1, i2, j2);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return pos;
    }

    @Override
    public void curioTick(String identifier, int index, LivingEntity living, ItemStack stack) {
        PlayerEntity player;
        if (living instanceof PlayerEntity & !living.field_70170_p.field_72995_K && !(player = (PlayerEntity)living).func_184811_cZ().func_185141_a((Item)this)) {
            BlockState initialState;
            ArrayList<BlockPos> doomedWaterBlocks = new ArrayList<BlockPos>();
            BlockPos initialPos = this.getCollidedWater((ITag.INamedTag<Fluid>)FluidTags.field_206959_a, player);
            BlockState blockState = initialState = initialPos != null ? player.field_70170_p.func_180495_p(initialPos) : null;
            if (initialPos != null && initialState != null && initialState.func_204520_s() != null && initialState.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) {
                doomedWaterBlocks.add(initialPos);
                ArrayList<BlockPos> processedBlocks = new ArrayList<BlockPos>();
                processedBlocks.add(initialPos);
                for (int counter = 0; counter <= radius.getValue(); ++counter) {
                    ArrayList<BlockPos> outputBlocks = new ArrayList<BlockPos>();
                    for (BlockPos checkedPos : processedBlocks) {
                        outputBlocks.addAll(this.getNearbyWater(player.field_70170_p, checkedPos));
                    }
                    processedBlocks.clear();
                    for (BlockPos thePos : outputBlocks) {
                        if (doomedWaterBlocks.contains(thePos)) continue;
                        processedBlocks.add(thePos);
                        doomedWaterBlocks.add(thePos);
                    }
                    outputBlocks.clear();
                }
                processedBlocks.clear();
                for (BlockPos exterminatedBlock : doomedWaterBlocks) {
                    this.absorbWaterBlock(exterminatedBlock, player.field_70170_p.func_180495_p(exterminatedBlock), player.field_70170_p);
                }
                doomedWaterBlocks.clear();
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187630_M, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 64.0, player.field_70170_p.func_234923_W_())), (Object)new PacketPortalParticles(player.func_226277_ct_(), player.func_226278_cu_() + (double)(player.func_213302_cg() / 2.0f), player.func_226281_cx_(), 40, 1.0, false));
                player.func_184811_cZ().func_185145_a((Item)this, 20);
            }
        }
    }

    public void absorbWaterBlock(BlockPos pos, BlockState state, World world) {
        if (!(state.func_177230_c() instanceof IBucketPickupHandler) || ((IBucketPickupHandler)state.func_177230_c()).func_204508_a((IWorld)world, pos, state) == Fluids.field_204541_a) {
            if (state.func_177230_c() instanceof FlowingFluidBlock) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            } else if (state.func_185904_a() == Material.field_203243_f || state.func_185904_a() == Material.field_204868_h) {
                TileEntity tileentity = state.hasTileEntity() ? world.func_175625_s(pos) : null;
                Block.func_220059_a((BlockState)state, (IWorld)world, (BlockPos)pos, (TileEntity)tileentity);
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            }
        }
    }

    public List<BlockPos> getNearbyWater(World world, BlockPos pos) {
        ArrayList<BlockPos> nearBlocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> waterBlocks = new ArrayList<BlockPos>();
        nearBlocks.add(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p()));
        nearBlocks.add(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()));
        nearBlocks.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
        nearBlocks.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()));
        nearBlocks.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1));
        nearBlocks.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1));
        for (BlockPos checkedPos : nearBlocks) {
            if (!world.func_180495_p(checkedPos).func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            waterBlocks.add(checkedPos);
        }
        return waterBlocks;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canRender(String identifier, int index, LivingEntity living, ItemStack stack) {
        return false;
    }
}

