/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

public class MiningCharm
extends ItemBaseCurio {
    public static Omniconfig.PerhapsParameter breakSpeedBonus;
    public static Omniconfig.DoubleParameter reachDistanceBonus;
    public final int nightVisionDuration = 210;

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("MiningCharm");
        breakSpeedBonus = builder.comment("Mining speed boost granted by Charm of Treasure Hunter. Defined as percentage.").max(1000.0).getPerhaps("BreakSpeed", 30);
        reachDistanceBonus = builder.comment("Additional block reach granted by Charm of Treasure Hunter.").max(16.0).getDouble("ReachDistance", 2.15);
        builder.popPrefix();
    }

    public MiningCharm() {
        super(ItemBaseCurio.getDefaultProperties().func_208103_a(Rarity.RARE));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "mining_charm"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        TranslationTextComponent mode = new TranslationTextComponent("tooltip.enigmaticlegacy.enabled");
        if (ItemNBTHelper.verifyExistance(stack, "nightVisionEnabled") && !ItemNBTHelper.getBoolean(stack, "nightVisionEnabled", true)) {
            mode = new TranslationTextComponent("tooltip.enigmaticlegacy.disabled");
        }
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharm1", TextFormatting.GOLD, breakSpeedBonus.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharm2", TextFormatting.GOLD, 1);
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharm3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharm4");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharm5");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharm6");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.miningCharmNightVision", null, mode);
    }

    public void removeNightVisionEffect(PlayerEntity player, int duration) {
        EffectInstance effect;
        if (player.func_70660_b(Effects.field_76439_r) != null && (effect = player.func_70660_b(Effects.field_76439_r)).func_76459_b() <= duration - 1) {
            player.func_195063_d(Effects.field_76439_r);
        }
    }

    @Override
    public void curioTick(String identifier, int index, LivingEntity living, ItemStack stack) {
        if (living instanceof PlayerEntity & !living.field_70170_p.field_72995_K && SuperpositionHandler.hasCurio(living, EnigmaticLegacy.miningCharm)) {
            PlayerEntity player = (PlayerEntity)living;
            if (ItemNBTHelper.getBoolean(stack, "nightVisionEnabled", true) && player.func_226278_cu_() < 50.0 && !player.field_70170_p.func_234923_W_().func_240901_a_().toString().equals("minecraft:the_nether") && !player.field_70170_p.func_234923_W_().func_240901_a_().toString().equals("minecraft:the_end") && !player.func_208600_a((ITag)FluidTags.field_206959_a) && !player.field_70170_p.func_175710_j(player.func_233580_cy_()) && player.field_70170_p.func_205049_d(player.func_233580_cy_(), 0) <= 8) {
                player.func_195064_c(new EffectInstance(Effects.field_76439_r, this.nightVisionDuration, 0, true, false));
            } else {
                this.removeNightVisionEffect(player, this.nightVisionDuration);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (ItemNBTHelper.getBoolean(stack, "nightVisionEnabled", true)) {
            ItemNBTHelper.setBoolean(stack, "nightVisionEnabled", false);
            world.func_184133_a(null, player.func_233580_cy_(), EnigmaticLegacy.HHOFF, SoundCategory.PLAYERS, (float)((double)0.8f + Math.random() * (double)0.2f), (float)((double)0.8f + Math.random() * (double)0.2f));
        } else {
            ItemNBTHelper.setBoolean(stack, "nightVisionEnabled", true);
            world.func_184133_a(null, player.func_233580_cy_(), EnigmaticLegacy.HHON, SoundCategory.PLAYERS, (float)((double)0.8f + Math.random() * (double)0.2f), (float)((double)0.8f + Math.random() * (double)0.2f));
        }
        player.func_184609_a(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Override
    public void onUnequip(String identifier, int index, LivingEntity living, ItemStack stack) {
        if (living instanceof PlayerEntity) {
            this.removeNightVisionEffect((PlayerEntity)living, this.nightVisionDuration);
        }
    }

    @Override
    public boolean canRightClickEquip(ItemStack stack) {
        return false;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(String identifier, ItemStack stack) {
        HashMultimap atts = HashMultimap.create();
        atts.put((Object)ForgeMod.REACH_DISTANCE.get(), (Object)new AttributeModifier(UUID.fromString("08c3c83d-7137-4b42-880f-b146bcb64d2e"), "Reach bonus", reachDistanceBonus.getValue(), AttributeModifier.Operation.ADDITION));
        return atts;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canRender(String identifier, int index, LivingEntity living, ItemStack stack) {
        return false;
    }

    @Override
    public int getFortuneBonus(String identifier, LivingEntity livingEntity, ItemStack curio, int index) {
        return super.getFortuneBonus(identifier, livingEntity, curio, index) + 1;
    }
}

