/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.api.items.ISpellstone;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ExperienceHelper;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemSpellstoneCurio;
import com.integral.omniconfig.Configuration;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

public class OceanStone
extends ItemSpellstoneCurio
implements ISpellstone {
    public static Omniconfig.IntParameter spellstoneCooldown;
    public static Omniconfig.PerhapsParameter swimminSpeedBoost;
    public static Omniconfig.PerhapsParameter underwaterCreaturesResistance;
    public static Omniconfig.DoubleParameter xpCostModifier;
    public static Omniconfig.BooleanParameter preventOxygenBarRender;
    public final int xpCostBase = 150;
    public final int nightVisionDuration = 210;

    @SubscribeConfig(receiveClient=true)
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("OceanStone");
        if (builder.config.getSidedType() != Configuration.SidedConfigType.CLIENT) {
            spellstoneCooldown = builder.comment("Active ability cooldown for Will of the Ocean. Measured in ticks. 20 ticks equal to 1 second.").getInt("Cooldown", 600);
            swimminSpeedBoost = builder.comment("Swimming speed boost provided by Will of the Ocean. Defined as percentage.").max(1000.0).getPerhaps("SwimBoost", 200);
            underwaterCreaturesResistance = builder.comment("Damage resistance against underwater creatures provided by Will of the Ocean. Defined as percentage.").max(100.0).getPerhaps("UnderwaterCreaturesResistance", 40);
            xpCostModifier = builder.comment("Multiplier for experience consumption by active ability of Will of the Ocean.").max(1000.0).getDouble("XPCostModifier", 1.0);
        } else {
            builder.popPrefix();
            preventOxygenBarRender = builder.comment("Whether or not oxygen bar should pe prevented from rendering if Will of the Ocean or Pearl of the Void is equipped.").getBoolean("SuppressUnneccessaryOxygenRender", true);
        }
        builder.popPrefix();
    }

    public OceanStone() {
        super(ItemSpellstoneCurio.getDefaultProperties().func_208103_a(Rarity.RARE));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "ocean_stone"));
        this.immunityList.add(DamageSource.field_76369_e.field_76373_n);
        this.resistanceList.put(DamageSource.field_76372_a.field_76373_n, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageSource.field_76370_b.field_76373_n, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageSource.field_76371_c.field_76373_n, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageSource.field_190095_e.field_76373_n, () -> Float.valueOf(2.0f));
        this.resistanceList.put("fireball", () -> Float.valueOf(2.0f));
    }

    private Multimap<Attribute, AttributeModifier> createAttributeMap(PlayerEntity player) {
        HashMultimap attributesDefault = HashMultimap.create();
        attributesDefault.put((Object)ForgeMod.ENTITY_GRAVITY.get(), (Object)new AttributeModifier(UUID.fromString("79e1cc36-fb4e-4c7d-802b-583b8d90648a"), "enigmaticlegacy:gravity_bonus", player.func_208600_a((ITag)FluidTags.field_206959_a) ? -1.0 : 0.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        return attributesDefault;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStoneCooldown", TextFormatting.GOLD, Float.valueOf((float)spellstoneCooldown.getValue() / 20.0f));
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone4");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone5", TextFormatting.GOLD, underwaterCreaturesResistance.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone6");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone7");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone8");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone9");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone10");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.oceanStone11");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", TextFormatting.LIGHT_PURPLE, ((ITextComponent)KeyBinding.func_193626_b((String)"key.spellstoneAbility").get()).getString().toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void triggerActiveAbility(World world, ServerPlayerEntity player, ItemStack stack) {
        if (SuperpositionHandler.hasSpellstoneCooldown((PlayerEntity)player)) {
            return;
        }
        if (!(player.field_70170_p.func_234923_W_().func_240901_a_().toString().equals("minecraft:the_end") || player.field_70170_p.func_234923_W_().func_240901_a_().toString().equals("minecraft:the_nether") || world.func_72912_H().func_76061_m())) {
            boolean paybackReceived = false;
            if (ExperienceHelper.getPlayerXP((PlayerEntity)player) >= this.xpCostBase * 2) {
                ExperienceHelper.drainPlayerXP((PlayerEntity)player, (int)(-(((double)this.xpCostBase + Math.random() * (double)this.xpCostBase) * xpCostModifier.getValue())));
                paybackReceived = true;
            }
            if (paybackReceived) {
                if (world instanceof ServerWorld) {
                    ServerWorld serverworld = (ServerWorld)world;
                    int thunderstormTime = (int)(10000.0 + Math.random() * 20000.0);
                    serverworld.func_241113_a_(0, thunderstormTime, true, true);
                }
                world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187754_de, SoundCategory.NEUTRAL, 2.0f, (float)((double)0.7f + Math.random() * 0.3));
                SuperpositionHandler.setSpellstoneCooldown((PlayerEntity)player, spellstoneCooldown.getValue());
            }
        }
    }

    @Override
    public void onUnequip(String identifier, int index, LivingEntity living, ItemStack stack) {
        if (living instanceof PlayerEntity) {
            EnigmaticLegacy.miningCharm.removeNightVisionEffect((PlayerEntity)living, this.nightVisionDuration);
            living.func_233645_dx_().func_233785_a_(this.createAttributeMap((PlayerEntity)living));
        }
    }

    @Override
    public void curioTick(String identifier, int index, LivingEntity living, ItemStack stack) {
        if (living instanceof PlayerEntity & !living.field_70170_p.field_72995_K && SuperpositionHandler.hasCurio(living, EnigmaticLegacy.oceanStone)) {
            PlayerEntity player = (PlayerEntity)living;
            if (player.func_208600_a((ITag)FluidTags.field_206959_a)) {
                player.func_195064_c(new EffectInstance(Effects.field_76439_r, this.nightVisionDuration, 0, true, false));
                player.func_70050_g(300);
            } else {
                EnigmaticLegacy.miningCharm.removeNightVisionEffect(player, this.nightVisionDuration);
            }
            player.func_233645_dx_().func_233793_b_(this.createAttributeMap(player));
        }
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(String identifier, ItemStack stack) {
        HashMultimap atts = HashMultimap.create();
        atts.put((Object)ForgeMod.SWIM_SPEED.get(), (Object)new AttributeModifier(UUID.fromString("13faf191-bf38-4654-b369-cc1f4f1143bf"), "Swim speed bonus", swimminSpeedBoost.getValue().asMultiplier(false), AttributeModifier.Operation.MULTIPLY_BASE));
        return atts;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canRender(String identifier, int index, LivingEntity living, ItemStack stack) {
        return false;
    }

    @Override
    public boolean showAttributesTooltip(String identifier, ItemStack stack) {
        return false;
    }
}

