/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ExperienceHelper;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBase;
import com.integral.enigmaticlegacy.triggers.RevelationGainTrigger;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RevelationTome
extends ItemBase
implements IVanishable {
    public static final String revelationPointsTag = "revelationPoints";
    public static final String xpPointsTag = "xpPoints";
    public static final String formerReadersTag = "formerReaders";
    public static final String lastHolderTag = "lastHolder";
    public final TomeType theType;
    public final String persistantPointsTag;

    public RevelationTome(Rarity rarity, TomeType type, String registryName) {
        super(ItemBase.getDefaultProperties().func_208103_a(rarity).func_200917_a(1));
        this.theType = type;
        this.persistantPointsTag = "enigmaticlegacy.revelation_points_" + this.theType.typeName;
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", registryName));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof ServerPlayerEntity) {
            ItemNBTHelper.setUUID(stack, lastHolderTag, entityIn.func_110124_au());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!RevelationTome.havePlayerRead(player, stack)) {
            RevelationTome.markRead(player, stack);
            int xp = ItemNBTHelper.getInt(stack, xpPointsTag, Item.field_77697_d.nextInt(1000));
            int revelation = ItemNBTHelper.getInt(stack, revelationPointsTag, 1);
            if (player instanceof ServerPlayerEntity) {
                int currentPoints = SuperpositionHandler.getPersistentInteger(player, this.persistantPointsTag, 0);
                ExperienceHelper.addPlayerXP(player, xp);
                SuperpositionHandler.setPersistentInteger(player, this.persistantPointsTag, currentPoints + revelation);
                world.func_184133_a(null, new BlockPos(player.func_213303_ch()), EnigmaticLegacy.LEARN, SoundCategory.PLAYERS, 0.75f, 1.0f);
                RevelationGainTrigger.INSTANCE.trigger((ServerPlayerEntity)player, this.theType, currentPoints + revelation);
                RevelationGainTrigger.INSTANCE.trigger((ServerPlayerEntity)player, TomeType.GENERIC, RevelationTome.getGenericPoints(player));
            } else {
                EnigmaticLegacy.proxy.pushRevelationToast(stack, xp, revelation);
            }
            player.func_184609_a(hand);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.revelationTome1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.revelationTome2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.revelationTome3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.revelationTome4");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (!RevelationTome.havePlayerRead((PlayerEntity)Minecraft.func_71410_x().field_71439_g, stack)) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.revelationTomeClick");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.revelationTomeMarkRead");
        }
    }

    public static int getGenericPoints(PlayerEntity player) {
        int overworldPoints = SuperpositionHandler.getPersistentInteger(player, "enigmaticlegacy.revelation_points_" + TomeType.OVERWORLD.typeName, 0);
        int netherPoints = SuperpositionHandler.getPersistentInteger(player, "enigmaticlegacy.revelation_points_" + TomeType.NETHER.typeName, 0);
        int endPoints = SuperpositionHandler.getPersistentInteger(player, "enigmaticlegacy.revelation_points_" + TomeType.END.typeName, 0);
        return overworldPoints + netherPoints + endPoints;
    }

    public ItemStack createTome(int revelationPoints, int experiencePoints) {
        ItemStack theTome = new ItemStack((IItemProvider)this);
        ItemNBTHelper.setInt(theTome, revelationPointsTag, revelationPoints);
        ItemNBTHelper.setInt(theTome, xpPointsTag, experiencePoints);
        return theTome;
    }

    public static boolean havePlayerRead(PlayerEntity player, ItemStack tome) {
        ListNBT uncheckedList;
        boolean haveReadBefore = false;
        CompoundNBT nbt = ItemNBTHelper.getNBT(tome);
        Object object = uncheckedList = nbt.func_74764_b(formerReadersTag) ? nbt.func_74781_a(formerReadersTag) : new ListNBT();
        if (uncheckedList instanceof ListNBT) {
            ListNBT list = uncheckedList;
            for (INBT entry : list) {
                if (!entry.func_150285_a_().equals(player.func_146103_bH().getName())) continue;
                haveReadBefore = true;
                break;
            }
        }
        return haveReadBefore;
    }

    public static void markRead(PlayerEntity player, ItemStack tome) {
        CompoundNBT nbt = ItemNBTHelper.getNBT(tome);
        ListNBT list = nbt.func_74781_a(formerReadersTag) instanceof ListNBT ? (ListNBT)nbt.func_74781_a(formerReadersTag) : new ListNBT();
        list.add((Object)StringNBT.func_229705_a_((String)player.func_146103_bH().getName()));
        nbt.func_218657_a(formerReadersTag, (INBT)list);
        tome.func_77982_d(nbt);
    }

    public int getBurnTime(ItemStack itemStack) {
        return 400;
    }

    public static enum TomeType {
        OVERWORLD("overworld"),
        NETHER("nether"),
        END("end"),
        GENERIC("generic");

        public final String typeName;

        private TomeType(String name) {
            this.typeName = name;
        }

        public static TomeType resolveType(@Nonnull String type) {
            if (type.equals("overworld")) {
                return OVERWORLD;
            }
            if (type.equals("nether")) {
                return NETHER;
            }
            if (type.equals("end")) {
                return END;
            }
            return GENERIC;
        }
    }
}

