/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.items.IPermanentCrystal;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBase;
import com.integral.enigmaticlegacy.objects.Vector3;
import com.integral.enigmaticlegacy.packets.clients.PacketRecallParticles;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class SoulCrystal
extends ItemBase
implements IPermanentCrystal,
IVanishable {
    public HashMap<PlayerEntity, Multimap<Attribute, AttributeModifier>> attributeDispatcher = new HashMap();

    public SoulCrystal() {
        super(ItemBase.getDefaultProperties().func_208103_a(Rarity.EPIC).func_200917_a(1).func_234689_a_().func_200916_a(EnigmaticLegacy.enigmaticTab));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "soul_crystal"));
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.soulCrystal1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.soulCrystal2");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    public ItemStack createCrystalFrom(PlayerEntity player) {
        int lostFragments = this.getLostCrystals(player);
        this.setLostCrystals(player, lostFragments + 1);
        return new ItemStack((IItemProvider)this);
    }

    public boolean retrieveSoulFromCrystal(PlayerEntity player, ItemStack stack) {
        int lostFragments = this.getLostCrystals(player);
        if (lostFragments > 0) {
            this.setLostCrystals(player, lostFragments - 1);
            if (!player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_184133_a(null, new BlockPos(player.func_213303_ch()), SoundEvents.field_206938_K, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public void setLostCrystals(PlayerEntity player, int lost) {
        SuperpositionHandler.setPersistentInteger(player, "enigmaticlegacy.lostsoulfragments", lost);
        this.updatePlayerSoulMap(player);
    }

    public int getLostCrystals(PlayerEntity player) {
        return SuperpositionHandler.getPersistentInteger(player, "enigmaticlegacy.lostsoulfragments", 0);
    }

    public Multimap<Attribute, AttributeModifier> getOrCreateSoulMap(PlayerEntity player) {
        if (this.attributeDispatcher.containsKey(player)) {
            return this.attributeDispatcher.get(player);
        }
        HashMultimap playerAttributes = HashMultimap.create();
        this.attributeDispatcher.put(player, (Multimap<Attribute, AttributeModifier>)playerAttributes);
        return playerAttributes;
    }

    public void applyPlayerSoulMap(PlayerEntity player) {
        Multimap<Attribute, AttributeModifier> soulMap = this.getOrCreateSoulMap(player);
        AttributeModifierManager attributeManager = player.func_233645_dx_();
        attributeManager.func_233793_b_(soulMap);
    }

    public void updatePlayerSoulMap(PlayerEntity player) {
        Multimap<Attribute, AttributeModifier> soulMap = this.getOrCreateSoulMap(player);
        AttributeModifierManager attributeManager = player.func_233645_dx_();
        attributeManager.func_233785_a_(soulMap);
        soulMap.clear();
        int lostFragments = SuperpositionHandler.getPersistentInteger(player, "enigmaticlegacy.lostsoulfragments", 0);
        if (lostFragments > 0) {
            soulMap.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(UUID.fromString("66a2aa2d-7e3c-4af4-882f-bd2b2ded8e7b"), "Lost Soul Health Modifier", (double)(-0.1f * (float)lostFragments), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        attributeManager.func_233793_b_(soulMap);
        this.attributeDispatcher.put(player, soulMap);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (this.retrieveSoulFromCrystal(player, stack)) {
            Vector3 playerCenter = Vector3.fromEntityCenter((Entity)player);
            if (!player.field_70170_p.field_72995_K) {
                EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(playerCenter.x, playerCenter.y, playerCenter.z, 64.0, player.field_70170_p.func_234923_W_())), (Object)new PacketRecallParticles(playerCenter.x, playerCenter.y, playerCenter.z, 48, false));
            }
            player.func_184609_a(hand);
            stack.func_190920_e(0);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }
}

