/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.items.IPermanentCrystal;
import com.integral.enigmaticlegacy.helpers.ExperienceHelper;
import com.integral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBase;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StorageCrystal
extends ItemBase
implements IPermanentCrystal,
IVanishable {
    public StorageCrystal() {
        super(ItemBase.getDefaultProperties().func_208103_a(Rarity.EPIC).func_200917_a(1).func_234689_a_().func_200916_a(null));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "storage_crystal"));
    }

    public ItemStack storeDropsOnCrystal(Collection<ItemEntity> drops, PlayerEntity player, @Nullable ItemStack embeddedSoulCrystal) {
        ItemStack crystal = new ItemStack((IItemProvider)this);
        CompoundNBT crystalNBT = ItemNBTHelper.getNBT(crystal);
        int counter = 0;
        for (ItemEntity drop : drops) {
            ItemStack dropStack = drop.func_92059_d();
            CompoundNBT nbt = dropStack.serializeNBT();
            crystalNBT.func_218657_a("storedStack" + counter, (INBT)nbt);
            ++counter;
        }
        if (embeddedSoulCrystal != null) {
            CompoundNBT deserializedCrystal = new CompoundNBT();
            embeddedSoulCrystal.deserializeNBT(deserializedCrystal);
            crystalNBT.func_218657_a("embeddedSoul", (INBT)deserializedCrystal);
        }
        ItemNBTHelper.setInt(crystal, "storedStacks", counter);
        int exp = ExperienceHelper.getPlayerXP(player);
        ExperienceHelper.drainPlayerXP(player, exp);
        ItemNBTHelper.setInt(crystal, "storedXP", exp);
        ItemNBTHelper.setBoolean(crystal, "isStored", true);
        return crystal;
    }

    public ItemStack retrieveDropsFromCrystal(ItemStack crystal, PlayerEntity player, ItemStack retrieveSoul) {
        CompoundNBT crystalNBT = ItemNBTHelper.getNBT(crystal);
        int counter = crystalNBT.func_74762_e("storedStacks") - 1;
        int exp = crystalNBT.func_74762_e("storedXP");
        for (int c = counter; c >= 0; --c) {
            CompoundNBT nbt = crystalNBT.func_74775_l("storedStack" + c);
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbt);
            if (!player.field_71071_by.func_70441_a(stack)) {
                ItemEntity drop = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack);
                player.field_70170_p.func_217376_c((Entity)drop);
            }
            crystalNBT.func_82580_o("storedStack" + c);
        }
        ExperienceHelper.addPlayerXP(player, exp);
        if (retrieveSoul != null) {
            EnigmaticLegacy.soulCrystal.retrieveSoulFromCrystal(player, retrieveSoul);
        } else {
            player.field_70170_p.func_184133_a(null, new BlockPos(player.func_213303_ch()), SoundEvents.field_206938_K, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        ItemNBTHelper.setBoolean(crystal, "isStored", false);
        ItemNBTHelper.setInt(crystal, "storedStacks", 0);
        ItemNBTHelper.setInt(crystal, "storedXP", 0);
        return crystal;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        playerIn.func_184598_c(handIn);
        if (!worldIn.field_72995_K) {
            // empty if block
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }
}

