/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.MagnetRing;
import com.integral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SuperMagnetRing
extends MagnetRing {
    public static Omniconfig.IntParameter range;
    public static Omniconfig.BooleanParameter soundEnabled;

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("SuperMagnetRing");
        range = builder.comment("The radius in which Dislocation Ring will collect items.").min(1.0).max(256.0).getInt("Range", 16);
        soundEnabled = builder.comment("Whether or not Dislocation Ring should play sound effect when teleporting items to player.").getBoolean("Sound", false);
        builder.popPrefix();
    }

    public SuperMagnetRing() {
        super(ItemBaseCurio.getDefaultProperties().func_208103_a(Rarity.EPIC));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "super_magnet_ring"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.superMagnetRing1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.superMagnetRing2", TextFormatting.GOLD, range.getValue());
            ItemLoreHelper.addLocalizedString(list, invertShift.getValue() ? "tooltip.enigmaticlegacy.superMagnetRing3_alt" : "tooltip.enigmaticlegacy.superMagnetRing3");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }

    @Override
    public void curioTick(String identifier, int index, LivingEntity living, ItemStack stack) {
        if (invertShift.getValue() ? !living.func_213453_ef() : living.func_213453_ef() || living.field_70170_p.field_72995_K || !(living instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)living;
        double x = living.func_226277_ct_();
        double y = living.func_226278_cu_() + 0.75;
        double z = living.func_226281_cx_();
        List items = living.field_70170_p.func_217357_a(ItemEntity.class, new AxisAlignedBB(x - (double)range.getValue(), y - (double)range.getValue(), z - (double)range.getValue(), x + (double)range.getValue(), y + (double)range.getValue(), z + (double)range.getValue()));
        int pulled = 0;
        for (ItemEntity item : items) {
            if (!this.canPullItem(item)) continue;
            if (pulled > 512) break;
            if (!SuperpositionHandler.canPickStack(player, item.func_92059_d())) continue;
            item.func_174868_q();
            item.func_70100_b_(player);
            ++pulled;
        }
    }

    @Override
    protected boolean canPullItem(ItemEntity item) {
        return super.canPullItem(item);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canRender(String identifier, int index, LivingEntity living, ItemStack stack) {
        return false;
    }
}

