/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBase;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.patchouli.api.PatchouliAPI;

public class TheAcknowledgment
extends ItemBase
implements IVanishable {
    private final Multimap<Attribute, AttributeModifier> attributes;
    private static final ResourceLocation bookID = new ResourceLocation("enigmaticlegacy", "the_acknowledgment");

    protected TheAcknowledgment(Item.Properties props, String name, double attackDamage, double attackSpeed) {
        super(props);
        this.setRegistryName("enigmaticlegacy", name);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(Item.field_111210_e, "Weapon modifier", attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(Item.field_185050_h, "Weapon modifier", attackSpeed, AttributeModifier.Operation.ADDITION));
        this.attributes = builder.build();
    }

    public TheAcknowledgment() {
        this(TheAcknowledgment.getDefaultProperties().func_208103_a(Rarity.EPIC).func_200917_a(1), bookID.func_110623_a(), 3.5, -2.1);
    }

    public static boolean isOpen() {
        return bookID.equals((Object)PatchouliAPI.instance.getOpenBookGui());
    }

    public static ITextComponent getEdition() {
        return PatchouliAPI.instance.getSubtitle(bookID);
    }

    public static ITextComponent getTitle(ItemStack stack) {
        ITextComponent title = stack.func_200301_q();
        String akashicTomeNBT = "akashictome:displayName";
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(akashicTomeNBT)) {
            title = new StringTextComponent(stack.func_77978_p().func_74779_i(akashicTomeNBT));
        }
        return title;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        target.func_70015_d(4);
        return super.func_77644_a(stack, target, attacker);
    }

    public int getItemEnchantability(ItemStack stack) {
        return 24;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        if (slot.equals((Object)EquipmentSlotType.MAINHAND)) {
            return this.attributes;
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)playerIn;
            PatchouliAPI.instance.openBookGUI((ServerPlayerEntity)playerIn, bookID);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        Map list = EnchantmentHelper.func_82781_a((ItemStack)book);
        if (list.size() == 1 && list.containsKey(Enchantments.field_180312_n)) {
            return true;
        }
        return super.isBookEnchantable(stack, book);
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_180312_n || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theAcknowledgment1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.theAcknowledgment2");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
    }
}

