/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.api.items.ISpellstone;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.items.generic.ItemSpellstoneCurio;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VoidPearl
extends ItemSpellstoneCurio
implements ISpellstone {
    public static Omniconfig.IntParameter spellstoneCooldown;
    public static Omniconfig.DoubleParameter baseDarknessDamage;
    public static Omniconfig.DoubleParameter regenerationDemodifier;
    public static Omniconfig.DoubleParameter shadowRange;
    public static Omniconfig.PerhapsParameter undeadProbability;
    public static Omniconfig.IntParameter witheringTime;
    public static Omniconfig.IntParameter witheringLevel;
    public List<String> healList = new ArrayList<String>();
    public DamageSource theDarkness;

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("VoidPearl");
        spellstoneCooldown = builder.comment("Active ability cooldown for Pearl of the Void. Measured in ticks. 20 ticks equal to 1 second.").getInt("Cooldown", 0);
        baseDarknessDamage = builder.comment("Base damage dealt by Darkness every half a second, when it devours a creature in proximity of bearer of the pearl.").max(1000.0).getDouble("BaseDarknessDamage", 4.0);
        regenerationDemodifier = builder.comment("Modifier for slowing down player's regeneration when bearing the pearl. This includes natural regeneration, as well as artificial healing effects that work over time. The greater it is, the slower player will regenerate.").max(1000.0).getDouble("RegenerationModifier", 1.0);
        shadowRange = builder.comment("Range in which Pearl of the Void will force darkness to devour living creatures.").max(128.0).getDouble("ShadowRange", 16.0);
        undeadProbability = builder.comment("Chance for Pearl of the Void to prevent it's bearer death from receiving lethal amout of damage. Defined as percentage.").max(100.0).getPerhaps("UndeadChance", 35);
        witheringTime = builder.comment("Amout of ticks for which bearer of the pearl will apply Withering effect to entities they attack. 20 ticks equals to 1 second.").getInt("WitheringTime", 100);
        witheringLevel = builder.comment("Level of Withering that bearer of the pearl will apply to entitities they attack.").max(3.0).getInt("WitheringLevel", 2);
        builder.popPrefix();
    }

    public VoidPearl() {
        super(ItemSpellstoneCurio.getDefaultProperties().func_200917_a(1).func_208103_a(Rarity.EPIC).func_234689_a_());
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "void_pearl"));
        this.immunityList.add(DamageSource.field_76369_e.field_76373_n);
        this.immunityList.add(DamageSource.field_76368_d.field_76373_n);
        this.healList.add(DamageSource.field_82727_n.field_76373_n);
        this.healList.add(DamageSource.field_76376_m.field_76373_n);
        this.theDarkness = new DamageSource("darkness");
        this.theDarkness.func_151518_m();
        this.theDarkness.func_76348_h();
        this.theDarkness.func_82726_p();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearlCooldown", TextFormatting.GOLD, Float.valueOf((float)spellstoneCooldown.getValue() / 20.0f));
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl6");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl7");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl8");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl9");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl10");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl11");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl12", TextFormatting.GOLD, undeadProbability.getValue().asPercentage() + "%");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.voidPearl13");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", TextFormatting.LIGHT_PURPLE, ((ITextComponent)KeyBinding.func_193626_b((String)"key.spellstoneAbility").get()).getString().toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void curioTick(String identifier, int index, LivingEntity living, ItemStack stack) {
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            if (player.func_70086_ai() < 300) {
                player.func_70050_g(300);
            }
            if (player.func_70027_ad()) {
                player.func_70066_B();
            }
            for (EffectInstance effect : new ArrayList(player.func_70651_bq())) {
                if (effect.func_188419_a() == Effects.field_76439_r && effect.func_76459_b() >= EnigmaticLegacy.miningCharm.nightVisionDuration - 10 && effect.func_76459_b() <= EnigmaticLegacy.miningCharm.nightVisionDuration) continue;
                player.func_195063_d(effect.func_188419_a());
            }
            if (player.field_70173_aa % 10 == 0) {
                List entities = living.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(player.func_226277_ct_() - shadowRange.getValue(), player.func_226278_cu_() - shadowRange.getValue(), player.func_226281_cx_() - shadowRange.getValue(), player.func_226277_ct_() + shadowRange.getValue(), player.func_226278_cu_() + shadowRange.getValue(), player.func_226281_cx_() + shadowRange.getValue()));
                if (entities.contains(player)) {
                    entities.remove(player);
                }
                for (LivingEntity victim : entities) {
                    PlayerEntity playerVictim;
                    if (victim.field_70170_p.func_205049_d(victim.func_233580_cy_(), 0) >= 3) continue;
                    if (victim instanceof PlayerEntity && SuperpositionHandler.hasCurio((LivingEntity)(playerVictim = (PlayerEntity)victim), EnigmaticLegacy.voidPearl)) {
                        playerVictim.func_195064_c(new EffectInstance(Effects.field_82731_v, 80, 1, false, true));
                        continue;
                    }
                    victim.func_70097_a(this.theDarkness, (float)baseDarknessDamage.getValue());
                    living.field_70170_p.func_184133_a(null, victim.func_233580_cy_(), SoundEvents.field_203257_fu, SoundCategory.PLAYERS, 1.0f, (float)((double)0.3f + Math.random() * 0.4));
                    victim.func_195064_c(new EffectInstance(Effects.field_82731_v, 80, 1, false, true));
                    victim.func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 2, false, true));
                    victim.func_195064_c(new EffectInstance(Effects.field_76440_q, 100, 0, false, true));
                    victim.func_195064_c(new EffectInstance(Effects.field_76438_s, 160, 2, false, true));
                    victim.func_195064_c(new EffectInstance(Effects.field_76419_f, 100, 3, false, true));
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canRender(String identifier, int index, LivingEntity living, ItemStack stack) {
        return false;
    }
}

