/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.helpers.ExperienceHelper;
import com.integral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.integral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.integral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class XPScroll
extends ItemBaseCurio {
    public static Omniconfig.DoubleParameter xpCollectionRange;
    public final int xpPortion = 5;

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("XPScroll");
        xpCollectionRange = builder.comment("Range in which Scroll of Ageless Wisdom collects experience orbs when active.").min(1.0).max(128.0).getDouble("CollectionRange", 16.0);
        builder.popPrefix();
    }

    public XPScroll() {
        super(ItemBaseCurio.getDefaultProperties().func_208103_a(Rarity.UNCOMMON));
        this.setRegistryName(new ResourceLocation("enigmaticlegacy", "xp_scroll"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        TranslationTextComponent cMode = !ItemNBTHelper.getBoolean(stack, "IsActive", false) ? new TranslationTextComponent("tooltip.enigmaticlegacy.xpTomeDeactivated") : (ItemNBTHelper.getBoolean(stack, "AbsorptionMode", true) ? new TranslationTextComponent("tooltip.enigmaticlegacy.xpTomeAbsorption") : new TranslationTextComponent("tooltip.enigmaticlegacy.xpTomeExtraction"));
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        if (Screen.func_231173_s_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome1");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome4");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome4_5");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome5");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome6");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome7");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome8");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome9");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome10");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTome11", TextFormatting.GOLD, (int)xpCollectionRange.getValue());
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTomeMode", null, cMode);
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTomeStoredXP");
        ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.xpTomeUnits", TextFormatting.GOLD, ItemNBTHelper.getInt(stack, "XPStored", 0), ExperienceHelper.getLevelForExperience(ItemNBTHelper.getInt(stack, "XPStored", 0)));
        try {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.currentKeybind", TextFormatting.LIGHT_PURPLE, ((ITextComponent)KeyBinding.func_193626_b((String)"key.xpScroll").get()).getString().toUpperCase());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        this.trigger(world, stack, player, handIn, true);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void trigger(World world, ItemStack stack, PlayerEntity player, Hand hand, boolean swing) {
        if (!player.func_213453_ef()) {
            if (ItemNBTHelper.getBoolean(stack, "AbsorptionMode", true)) {
                ItemNBTHelper.setBoolean(stack, "AbsorptionMode", false);
                world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * (double)0.2f));
            } else {
                ItemNBTHelper.setBoolean(stack, "AbsorptionMode", true);
                world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * (double)0.2f));
            }
        } else if (ItemNBTHelper.getBoolean(stack, "IsActive", false)) {
            ItemNBTHelper.setBoolean(stack, "IsActive", false);
            world.func_184133_a(null, player.func_233580_cy_(), EnigmaticLegacy.HHOFF, SoundCategory.PLAYERS, (float)((double)0.8f + Math.random() * (double)0.2f), (float)((double)0.8f + Math.random() * (double)0.2f));
        } else {
            ItemNBTHelper.setBoolean(stack, "IsActive", true);
            world.func_184133_a(null, player.func_233580_cy_(), EnigmaticLegacy.HHON, SoundCategory.PLAYERS, (float)((double)0.8f + Math.random() * (double)0.2f), (float)((double)0.8f + Math.random() * (double)0.2f));
        }
        if (swing) {
            player.func_184609_a(hand);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, "IsActive", false);
    }

    @Override
    public void curioTick(String identifier, int index, LivingEntity entity, ItemStack stack) {
        ItemStack itemstack = SuperpositionHandler.getCurioStack(entity, EnigmaticLegacy.xpScroll);
        if (!(entity instanceof PlayerEntity) || entity.field_70170_p.field_72995_K || !ItemNBTHelper.getBoolean(itemstack, "IsActive", false)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        World world = player.field_70170_p;
        if (ItemNBTHelper.getBoolean(itemstack, "AbsorptionMode", true)) {
            if (ExperienceHelper.getPlayerXP(player) >= this.xpPortion) {
                ExperienceHelper.drainPlayerXP(player, this.xpPortion);
                ItemNBTHelper.setInt(itemstack, "XPStored", ItemNBTHelper.getInt(itemstack, "XPStored", 0) + this.xpPortion);
            } else if (ExperienceHelper.getPlayerXP(player) > 0 & ExperienceHelper.getPlayerXP(player) < this.xpPortion) {
                int exp = ExperienceHelper.getPlayerXP(player);
                ExperienceHelper.drainPlayerXP(player, exp);
                ItemNBTHelper.setInt(itemstack, "XPStored", ItemNBTHelper.getInt(itemstack, "XPStored", 0) + exp);
            }
        } else {
            int xp = ItemNBTHelper.getInt(itemstack, "XPStored", 0);
            if (xp >= this.xpPortion) {
                ItemNBTHelper.setInt(itemstack, "XPStored", xp - this.xpPortion);
                ExperienceHelper.addPlayerXP(player, this.xpPortion);
            } else if (xp > 0 & xp < this.xpPortion) {
                ItemNBTHelper.setInt(itemstack, "XPStored", 0);
                ExperienceHelper.addPlayerXP(player, xp);
            }
        }
        List orbs = world.func_217357_a(ExperienceOrbEntity.class, SuperpositionHandler.getBoundingBoxAroundEntity((Entity)player, xpCollectionRange.getValue()));
        for (ExperienceOrbEntity processed : orbs) {
            if (!processed.func_70089_S()) continue;
            player.field_71090_bL = 0;
            processed.func_70100_b_(player);
        }
    }

    @Override
    public boolean canRightClickEquip(ItemStack stack) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canRender(String identifier, int index, LivingEntity living, ItemStack stack) {
        return false;
    }
}

