/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items.generic;

import com.integral.enigmaticlegacy.EnigmaticLegacy;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.LazyValue;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public abstract class ItemBaseArmor
extends ArmorItem {
    private final LazyValue<BipedModel<?>> model = (LazyValue)DistExecutor.runForDist(() -> () -> new LazyValue(() -> this.provideArmorModelForSlot(slot)), () -> () -> null);

    public ItemBaseArmor(IArmorMaterial materialIn, EquipmentSlotType slot, Item.Properties builder) {
        super(materialIn, slot, builder);
    }

    public ItemBaseArmor(IArmorMaterial materialIn, EquipmentSlotType slot) {
        this(materialIn, slot, ItemBaseArmor.getDefaultProperties());
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A original) {
        return (A)((BipedModel)this.model.func_179281_c());
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public BipedModel<?> provideArmorModelForSlot(EquipmentSlotType slot) {
        BipedModel model = new BipedModel(0.5f);
        model.func_178719_a(false);
        return model;
    }

    @Nonnull
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return "enigmaticlegacy:textures/models/armor/unseen_armor.png";
    }

    public boolean hasFullSet(@Nonnull PlayerEntity player) {
        if (player == null) {
            return false;
        }
        for (ItemStack stack : player.func_184193_aE()) {
            if (stack.func_77973_b().getClass() == ((Object)((Object)this)).getClass()) continue;
            return false;
        }
        return true;
    }

    public static Item.Properties getDefaultProperties() {
        Item.Properties props = new Item.Properties();
        props.func_200916_a(EnigmaticLegacy.enigmaticTab);
        props.func_200917_a(1);
        props.func_208103_a(Rarity.COMMON);
        return props;
    }
}

