/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.items.generic;

import com.integral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.integral.enigmaticlegacy.api.items.ISpellstone;
import com.integral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.integral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.integral.omniconfig.wrappers.Omniconfig;
import com.integral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class ItemSpellstoneCurio
extends ItemBaseCurio
implements ISpellstone {
    public static Omniconfig.BooleanParameter multiequip;
    public List<String> immunityList = new ArrayList<String>();
    public HashMap<String, Supplier<Float>> resistanceList = new HashMap();

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("Spellstones");
        multiequip = builder.comment("Whether or not it should be allowed to equip multiple spellstones if they are different items, granted player somehow gets more than one spellstone slot.").getBoolean("Multiequip", false);
        builder.popPrefix();
    }

    public ItemSpellstoneCurio() {
        this(ItemSpellstoneCurio.getDefaultProperties());
    }

    public ItemSpellstoneCurio(Item.Properties props) {
        super(props);
    }

    public boolean isResistantTo(String damageType) {
        return this.resistanceList.containsKey(damageType);
    }

    public boolean isImmuneTo(String damageType) {
        return this.immunityList.contains(damageType);
    }

    public Supplier<Float> getResistanceModifier(String damageType) {
        return this.resistanceList.get(damageType);
    }

    public static Item.Properties getDefaultProperties() {
        return ItemBaseCurio.getDefaultProperties();
    }

    @Override
    public boolean canEquip(String identifier, LivingEntity living, ItemStack stack) {
        if (multiequip.getValue()) {
            return super.canEquip(identifier, living, stack);
        }
        return super.canEquip(identifier, living, stack) && SuperpositionHandler.getSpellstone(living) == null;
    }
}

