/*
 * Decompiled with CFR 0.152.
 */
package com.integral.enigmaticlegacy.mixin;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.integral.enigmaticlegacy.EnigmaticLegacy;
import com.integral.enigmaticlegacy.helpers.LootTableHelper;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.LootTableLoadEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ForgeHooks.class}, remap=false)
public class MixinForgeHooks {
    @Inject(at={@At(value="RETURN")}, method={"loadLootTable"}, cancellable=true, remap=false)
    private static void onLoadLootTable(Gson gson, ResourceLocation name, JsonElement data, boolean custom, LootTableManager lootTableManager, CallbackInfoReturnable<LootTable> info) {
        LootTable returnedTable = (LootTable)info.getReturnValue();
        if (custom && returnedTable != null) {
            EnigmaticLegacy.logger.debug("Caught custom LootTable loading: " + name);
            try {
                EnigmaticLegacy.logger.debug("Unfreezing " + name + "...");
                LootTableHelper.unfreezePlease(returnedTable);
            }
            catch (Exception ex) {
                EnigmaticLegacy.logger.fatal("FAILED TO PROCESS LOOT TABLE: " + name);
                throw new RuntimeException(ex);
            }
            EnigmaticLegacy.logger.debug("Force dispatching LootTableLoadEvent for " + name + "...");
            LootTableLoadEvent event = new LootTableLoadEvent(name, returnedTable, lootTableManager);
            EnigmaticLegacy.enigmaticHandler.onLootTablesLoaded(event);
            if (event.isCanceled()) {
                returnedTable = LootTable.field_186464_a;
            }
            EnigmaticLegacy.logger.debug("Freezing " + name + " back...");
            returnedTable.freeze();
            EnigmaticLegacy.logger.debug("Returning " + name + " to Forge handler...");
            info.setReturnValue((Object)returnedTable);
        }
    }
}

